/* ////////// LICENSE INFO ////////////////////

 * Copyright (C) 2013 by NYSOL CORPORATION
 *
 * Unless you have received this program directly from NYSOL pursuant
 * to the terms of a commercial license agreement with NYSOL, then
 * this program is licensed to you under the terms of the GNU Affero General
 * Public License (AGPL) as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF 
 * NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please refer to the AGPL (http://www.gnu.org/licenses/agpl-3.0.txt)
 * for more details.

 ////////// LICENSE INFO ////////////////////*/
// =============================================================================
/// kgcommonHelp.h : kgcommon help
// =============================================================================
_title="参照ファイルによる行選択";
_doc="\
mcommon(参照ファイルによる行選択)コマンド\n\
\"k=\"パラメータで指定した入力ファイルの項目値と\n\
\"m=\"パラメータで指定した参照ファイルの項目値を比較し、\n\
同じ値を持つ入力ファイルの行を選択する。\n\
書式\n\
mcommon k= m= [K=] [u=] [-r] [-nfn] [-nfno] [-x] [i=] [o=] [-help]\n\
パラメータ\n\
k= 入力データ上の突き合わせる項目名リスト(複数項目指定可)【必須】\n\
   ここで指定した入力データの項目と\n\
   \"K=\"パラメータで指定された参照データの項目が同じ行が選択される。\n\
   事前に\"k=\"パラメータで指定する項目順に並べ替えておく必要がある。\n\
   x,nfnオプション使用時は、項目番号(0～)で指定可能。\n\
m= 参照ファイル名【必須】\n\
   参照ファイル名を指定する。\n\
   またこのパラメータが省略された時には標準入力が用いられる。(i=指定ありの場合)\n\
K= 参照データ上の突き合わせる項目名リスト(複数項目指定可)【任意】\n\
   ここで指定した参照データの項目と\n\
   \"k=\"パラメータで指定された入力データの項目が同じ行が選択される。\n\
   参照データ上に\"k=\"パラメータで指定した入力データ上の項目と同名の項目が\n\
   存在する場合は指定する必要はない。\n\
   ※事前に\"K=\"パラメータで指定する項目順に並べ替えておく必要がある。\n\
   x,nfnオプション使用時は、項目番号(0～)で指定可能。\n\
u= 不一致データ出力ファイル名【任意】\n\
   指定の条件に一致しない行を出力するファイル名。\n\
オプション\n\
-r 条件反転\n\
   \"k=\"パラメータで指定した入力ファイルの項目値と\n\
   \"m=\"パラメータで指定した参照ファイルの項目値を比較し、\n\
    同じ値を持たない入力ファイルの行を選択する。\n\
利用例\n\
例1 入力ファイルにある顧客項目と、参照ファイルにある顧客項目が同じ値を\n\
    持つ入力ファイルの行を選択する。\n\
    それ以外のデータはoth.csvという名前のファイルに出力する。\n\
    ※注意：この例では事前に入力ファイルと参照ファイルの両方の顧客項目順に\n\
    並べ替えてあることを前提にしている。\n\
------------------------------------------------\n\
# 入力ファイル(dat.csv)\n\
顧客,数量,金額\n\
A,1,10\n\
B,2,20\n\
C,1,15\n\
D,3,10\n\
E,1,20\n\
\n\
# 参照ファイル(ref.csv)\n\
顧客,性別\n\
A,女性\n\
B,男性\n\
E,女性\n\
\n\
$ mcommon k=顧客 m=ref.csv u=oth.csv i=dat.csv o=rsl.csv\n\
\n\
#出力ファイル(rsl.csv)\n\
顧客,数量,金額\n\
A,1,10\n\
B,2,20\n\
E,1,20\n\
\n\
#出力ファイル2(oth.csv)\n\
顧客,数量,金額\n\
C,1,15\n\
D,3,10\n\
------------------------------------------------\n\
例2\n\
入力ファイルにある顧客項目と、参照ファイルにある顧客項目が同じ値を\n\
持つ入力ファイル以外の行を選択する。\n\
※注意：この例では事前に入力ファイルと参照ファイルの両方の顧客項目順に\n\
並べ替えてあることを前提にしている。\n\
------------------------------------------------\n\
# 入力ファイル(dat.csv)\n\
顧客,数量,金額\n\
A,1,10\n\
B,2,20\n\
C,1,15\n\
D,3,10\n\
E,1,20\n\
\n\
#参照ファイル(ref.csv)\n\
顧客,性別\n\
A,女性\n\
B,男性\n\
E,女性\n\
\n\
$ mcommon k=顧客 m=ref.csv -r i=dat.csv o=rsl2.csv\n\
\n\
#出力ファイル1(rsl2.csv)\n\
顧客,数量,金額\n\
C,1,15\n\
D,3,10\n\
------------------------------------------------\n\
例3\n\
入力ファイルにある顧客項目、日付項目と、参照ファイルにある顧客\n\
ID項目,来店日項目が同じ値を持つ入力ファイルの行を選択する。\n\
※注意：この例では事前に入力ファイルと参照ファイルの両方の対象項目順に\n\
並べ替えてあることを前提にしている。\n\
------------------------------------------------\n\
#入力ファイル(dat2.csv)\n\
顧客,数量,金額,日付\n\
A,1,10,2012/01/01\n\
A,1,10,2012/01/01\n\
A,1,10,2012/01/02\n\
A,1,10,2012/01/03\n\
B,2,20,2012/01/01\n\
B,2,20,2012/01/01\n\
C,1,15,2012/01/01\n\
C,1,15,2012/01/03\n\
C,1,15,2012/01/04\n\
C,1,15,2012/01/05\n\
D,3,10,2012/01/01\n\
D,3,10,2012/01/01\n\
E,1,20,2012/01/02\n\
\n\
#参照ファイル(ref2.csv)\n\
顧客ID,性別,来店日\n\
A,女性,2012/01/01\n\
A,女性,2012/01/02\n\
B,男性,2012/01/01\n\
B,男性,2012/01/02\n\
B,男性,2012/01/03\n\
E,女性,2012/01/01\n\
E,女性,2012/01/02\n\
\n\
$ mcommon k=顧客,日付 K=顧客ID,来店日 i=dat2.csv m=ref2.csv o=rsl3.csv\n\
\n\
#出力ファイル(rsl3.csv)\n\
顧客,数量,金額,日付\n\
A,1,10,2012/01/01\n\
A,1,10,2012/01/01\n\
A,1,10,2012/01/02\n\
B,2,20,2012/01/01\n\
B,2,20,2012/01/01\n\
E,1,20,2012/01/02\n\
------------------------------------------------\n\
関連コマンド\n\
mselstr:文字列による行撰択\n\
msel:条件式による行撰択\n\
mjoin:参照ファイルの項目結合\n\
mnjoin:参照ファイル項目の自然結合\n\
";
