/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import com.ibm.media.bean.multiplayer.GrayFilter;
import com.ibm.media.bean.multiplayer.ImageLabel;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.net.URL;

public class ImageButton
extends ImageLabel {
    protected static final int defaultBorderWidth = 4;
    protected static final Color defaultBorderColor = new Color(160, 160, 160);
    private char[] text;
    private boolean txtButton = false;
    private boolean mouseIsDown = false;
    String actionCommand;
    transient ActionListener actionListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    private int darkness = -5263441;
    private Image grayImage = null;

    public ImageButton() {
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(String text, boolean txt, int width, int height) {
        this.width = width;
        this.height = height;
        if (txt) {
            int length = text.length();
            this.text = new char[length];
            text.getChars(0, length, this.text, 0);
            this.txtButton = txt;
        }
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(String imageURLString) {
        super(imageURLString);
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(URL imageURL) {
        super(imageURL);
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(URL imageDirectory, String imageFile) {
        super(imageDirectory, imageFile);
        this.enableEvents(144L);
        this.setBorders();
    }

    public ImageButton(Image image) {
        super(image);
        this.enableEvents(144L);
        this.setBorders();
    }

    public void waitForImage(boolean doLayout) {
        if (this.txtButton) {
            this.resize(this.width, this.height);
            this.doneLoading = true;
            return;
        }
        super.waitForImage(doLayout);
    }

    public void paint(Graphics g2) {
        if (!this.doneLoading) {
            this.waitForImage(true);
        } else if (!this.txtButton) {
            if (this.explicitSize) {
                g2.drawImage(this.image, this.border, this.border, this.width - 2 * this.border, this.height - 2 * this.border, this);
            } else {
                g2.drawImage(this.image, this.border, this.border, this);
            }
            this.drawRect(g2, 0, 0, this.width - 1, this.height - 1, this.border, this.borderColor);
            if (this.grayImage == null) {
                this.createGrayImage(g2);
            }
        } else {
            int tsize = this.text.length * 9 / 2;
            g2.drawChars(this.text, 0, this.text.length, this.width / 2 - tsize, this.height / 2 + 5);
        }
        this.drawBorder(true);
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener l2) {
        this.debug("[addActionListener]: " + l2);
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l2);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener l2) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l2);
    }

    protected void processEvent(AWTEvent e2) {
        this.debug("[processEvent]: " + e2);
        if (e2 instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e2);
            return;
        }
        if (e2 instanceof MouseEvent) {
            this.processMouseEvent((MouseEvent)e2);
            return;
        }
        super.processEvent(e2);
    }

    protected void processMouseEvent(MouseEvent e2) {
        if (e2.getID() == 502) {
            this.mouseIsDown = false;
            this.paint(this.getGraphics());
            this.processEvent(new ActionEvent(this, 1001, this.actionCommand));
        } else if (e2.getID() == 501) {
            this.mouseIsDown = true;
            Graphics g2 = this.getGraphics();
            int border = this.getBorder();
            if (!this.txtButton) {
                if (this.hasExplicitSize()) {
                    g2.drawImage(this.getGrayImage(), border, border, this.getWidth() - 2 * border, this.getHeight() - 2 * border, this);
                } else {
                    g2.drawImage(this.getGrayImage(), border, border, this);
                }
            }
            this.drawBorder(false);
        } else if (e2.getID() == 505 && this.mouseIsDown) {
            this.paint(this.getGraphics());
        }
        super.processMouseEvent(e2);
    }

    protected void processActionEvent(ActionEvent e2) {
        this.debug("Action Event occurred.");
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e2);
        }
    }

    protected void setText(String t) {
        if (this.txtButton) {
            this.text = new char[t.length()];
            t.getChars(0, t.length(), this.text, 0);
            this.paint(this.getGraphics());
            this.validate();
        }
    }

    public int getDarkness() {
        return this.darkness;
    }

    public void setDarkness(int darkness) {
        this.darkness = darkness;
    }

    public Image getGrayImage() {
        return this.grayImage;
    }

    public void setGrayImage(Image grayImage) {
        this.grayImage = grayImage;
    }

    public void drawBorder(boolean isUp) {
        Graphics g2 = this.getGraphics();
        if (g2 == null) {
            return;
        }
        g2.setColor(this.getBorderColor());
        int left = 0;
        int top = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        int border = this.getBorder();
        int i2 = 0;
        while (i2 < border) {
            g2.draw3DRect(left, top, width, height, isUp);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
            ++i2;
        }
    }

    private void setBorders() {
        this.setBorder(4);
        this.setBorderColor(defaultBorderColor);
    }

    private void createGrayImage(Graphics g2) {
        GrayFilter filter = new GrayFilter(this.darkness);
        FilteredImageSource producer = new FilteredImageSource(this.getImage().getSource(), filter);
        this.grayImage = this.createImage(producer);
        int border = this.getBorder();
        if (this.hasExplicitSize()) {
            this.prepareImage(this.grayImage, this.getWidth() - 2 * border, this.getHeight() - 2 * border, this);
        } else {
            this.prepareImage(this.grayImage, this);
        }
        super.paint(g2);
    }
}

