/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCS is C++ version NyARToolkit class library.
* 
* Copyright (C)2008 R.Iizuka
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this framework; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp>
* 
*/
#pragma once

#include "SquareContourDetector.h"


#include "NyARObserv2IdealMap.h"
#include "NyARPca2d_MatrixPCA_O2.h"

namespace NyARToolkitCPP
{
#define VERTEX_FACTOR 1.0// õt@N^

	SquareContourDetector::SquareContourDetector(const TNyARIntSize& i_size,const NyARCameraDistortionFactor& i_distfactor_ref)
	{
		//c݌vZe[uƁA8*width/height*2̗̈܂B
		//̈肽Ȃꍇ́Ai_dist_factor_ref̒l̂܂܎gĂB
		this->_dist_factor = new NyARObserv2IdealMap(i_distfactor_ref,i_size);


		// ֊sobt@͒_ϊ̂ŁA֊sobt@̂Q{B
		this->_pca=new NyARPca2d_MatrixPCA_O2();
		this->_xpos=new double[i_size.w+i_size.h];//őӒthis._width+this._height
		this->_ypos=new double[i_size.w+i_size.h];//őӒthis._width+this._height
		return;
	}
	SquareContourDetector::~SquareContourDetector()
	{
		NyAR_SAFE_DELETE(this->_dist_factor);
		NyAR_SAFE_DELETE(this->_pca);
		NyAR_SAFE_DELETE(this->_xpos);
		NyAR_SAFE_DELETE(this->_ypos);
		return;
	}


	bool SquareContourDetector::coordToSquare(const int* i_xcoord,const int* i_ycoord,int i_st_index,int i_coord_num,int i_label_area,NyARSquare& o_square)
	{

		int (&mkvertex)[5] = this->__detectMarker_mkvertex;

		// _擾
		if (!getSquareVertex(i_xcoord, i_ycoord, i_st_index, i_coord_num, i_label_area, mkvertex)) {
			// _̎擾oȂ̂Ŕj
			return false;
		}
		// }[J[o
		if (!getSquareLine(mkvertex, i_xcoord, i_ycoord, o_square)){
			// `ȂB
			return false;
		}
		return true;
	}


	bool SquareContourDetector::getSquareLine(const int* i_mkvertex,const int* i_xcoord,const int* i_ycoord, NyARSquare& o_square)
	{
		TNyARLinear* l_line = o_square.line;
		NyARDoubleMatrix22& evec=this->__getSquareLine_evec;
		TNyARDoublePoint2d mean;
		TNyARDoublePoint2d ev;


		for (int i = 0; i < 4; i++) {
			const double w1 = (double) (i_mkvertex[i + 1] - i_mkvertex[i] + 1) * 0.05 + 0.5;
			const int st = (int) (i_mkvertex[i] + w1);
			const int ed = (int) (i_mkvertex[i + 1] - w1);
			const int n = ed - st + 1;
			if (n < 2) {
				// n2ȉmatrix.PCAvZ邱Ƃ͂łȂ̂ŁAG[
				return false;
			}
			//z쐬
			this->_dist_factor->observ2IdealBatch(i_xcoord, i_ycoord, st, n,this->_xpos,this->_ypos);

			//听͂B
			this->_pca->pca(this->_xpos,this->_ypos,n,evec, ev,mean);
			TNyARLinear& l_line_i = l_line[i];
			l_line_i.run = evec.m01;// line[i][0] = evec->m[1];
			l_line_i.rise = -evec.m00;// line[i][1] = -evec->m[0];
			l_line_i.intercept = -(l_line_i.run * mean.x + l_line_i.rise * mean.y);// line[i][2] = -(line[i][0]*mean->v[0] + line[i][1]*mean->v[1]);
		}

		TNyARDoublePoint2d* l_sqvertex = o_square.sqvertex;
		TNyARIntPoint2d* l_imvertex = o_square.imvertex;
		for (int i = 0; i < 4; i++) {
			const TNyARLinear& l_line_i = l_line[i];
			const TNyARLinear& l_line_2 = l_line[(i + 3) % 4];
			const double w1 = l_line_2.run * l_line_i.rise - l_line_i.run * l_line_2.rise;
			if (w1 == 0.0) {
				return false;
			}
			l_sqvertex[i].x = (l_line_2.rise * l_line_i.intercept - l_line_i.rise * l_line_2.intercept) / w1;
			l_sqvertex[i].y = (l_line_i.run * l_line_2.intercept - l_line_2.run * l_line_i.intercept) / w1;
			// _CfNX璸_W𓾂ĕۑ
			l_imvertex[i].x = i_xcoord[i_mkvertex[i]];
			l_imvertex[i].y = i_ycoord[i_mkvertex[i]];
		}
		return true;
	}	
	bool SquareContourDetector::getSquareVertex(const int* i_x_coord,const int* i_y_coord, int i_vertex1_index, int i_coord_num, int i_area, int* o_vertex)
	{
		NyARVertexCounter& wv1 = this->__getSquareVertex_wv1;
		NyARVertexCounter& wv2 = this->__getSquareVertex_wv2;
		int end_of_coord = i_vertex1_index + i_coord_num - 1;
		int sx = i_x_coord[i_vertex1_index];// sx = marker_info2->x_coord[0];
		int sy = i_y_coord[i_vertex1_index];// sy = marker_info2->y_coord[0];
		int dmax = 0;
		int v1 = i_vertex1_index;
		for (int i = 1 + i_vertex1_index; i < end_of_coord; i++) {// for(i=1;i<marker_info2->coord_num-1;i++)
			// {
			const int d = (i_x_coord[i] - sx) * (i_x_coord[i] - sx) + (i_y_coord[i] - sy) * (i_y_coord[i] - sy);
			if (d > dmax) {
				dmax = d;
				v1 = i;
			}
		}
		const double thresh = (i_area / 0.75) * 0.01 * VERTEX_FACTOR;

		o_vertex[0] = i_vertex1_index;

		if (!wv1.getVertex(i_x_coord, i_y_coord, i_vertex1_index, v1, thresh)) { // if(get_vertex(marker_info2->x_coord,marker_info2->y_coord,0,v1,thresh,wv1,&wvnum1)<
			// 0 ) {
			return false;
		}
		if (!wv2.getVertex(i_x_coord, i_y_coord, v1, end_of_coord, thresh)) {// if(get_vertex(marker_info2->x_coord,marker_info2->y_coord,v1,marker_info2->coord_num-1,thresh,wv2,&wvnum2)
			// < 0) {
			return false;
		}

		int v2;
		if (wv1.number_of_vertex == 1 && wv2.number_of_vertex == 1) {// if(wvnum1 == 1 && wvnum2== 1) {
			o_vertex[1] = wv1.vertex[0];
			o_vertex[2] = v1;
			o_vertex[3] = wv2.vertex[0];
		} else if (wv1.number_of_vertex > 1 && wv2.number_of_vertex == 0) {// }else if( wvnum1 > 1 && wvnum2== 0) {
			//_ʒuAN_Ίp_̊Ԃ1/2ɂƗ\zāAB
			v2 = (v1-i_vertex1_index)/2+i_vertex1_index;
			if (!wv1.getVertex(i_x_coord, i_y_coord, i_vertex1_index, v2, thresh)) {
				return false;
			}
			if (!wv2.getVertex(i_x_coord, i_y_coord, v2, v1, thresh)) {
				return false;
			}
			if (wv1.number_of_vertex == 1 && wv2.number_of_vertex == 1) {
				o_vertex[1] = wv1.vertex[0];
				o_vertex[2] = wv2.vertex[0];
				o_vertex[3] = v1;
			} else {
				return false;
			}
		} else if (wv1.number_of_vertex == 0 && wv2.number_of_vertex > 1) {
			//v2 = (v1-i_vertex1_index+ end_of_coord-i_vertex1_index) / 2+i_vertex1_index;
			v2 = (v1+ end_of_coord)/2;

			if (!wv1.getVertex(i_x_coord, i_y_coord, v1, v2, thresh)) {
				return false;
			}
			if (!wv2.getVertex(i_x_coord, i_y_coord, v2, end_of_coord, thresh)) {
				return false;
			}
			if (wv1.number_of_vertex == 1 && wv2.number_of_vertex == 1) {
				o_vertex[1] = v1;
				o_vertex[2] = wv1.vertex[0];
				o_vertex[3] = wv2.vertex[0];
			} else {
				return false;
			}
		} else {
			return false;
		}
		o_vertex[4] = end_of_coord;
		return true;
	}

	/**
	* ֊s̋`oJn|Cg肵āAWבւ܂B
	* ֊s̐擪AΊpŒɂȂ_P_AŐԂobt@̌ɐڑ܂B
	* ߂l͑ΊpŒɂȂ_łB֐IAԋpl+i_coord_num̗vfLɂȂ܂B
	* @param i_xcoord
	* @param i_ycoord
	* @param i_coord_num
	* @return
	*/

	int SquareContourDetector::normalizeCoord(int* i_coord_x, int* i_coord_y,int i_coord_num)
	{
		//
		const int sx = i_coord_x[0];
		const int sy = i_coord_y[0];
		int d = 0;
		int w, x, y;
		int ret = 0;
		for (int i = 1; i < i_coord_num; i++) {
			x = i_coord_x[i] - sx;
			y = i_coord_y[i] - sy;
			w = x * x + y * y;
			if (w > d) {
				d = w;
				ret = i;
			}
			// ł܂IȂȁB
		}
		// vertex1EɂāAɔzA
		memcpy(i_coord_x+i_coord_num,i_coord_x+1,ret*sizeof(int));
		memcpy(i_coord_y+i_coord_num,i_coord_y+1,ret*sizeof(int));
		return ret;
	}
}
