/* 
 * PROJECT: NyARToolkitCPP
 * --------------------------------------------------------------------------------
 *
 * The NyARToolkitCS is C++ version NyARToolkit class library.
 * 
 * Copyright (C)2008 R.Iizuka
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this framework; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For further information please contact.
 *	http://nyatla.jp/nyatoolkit/
 *	<airmail(at)ebony.plala.or.jp>
 * 
 */
#include "NyARTransMat.h"
#include "NyARRotTransOptimize_O2.h"
#include "NyARTransportVectorSolver.h"
#include "NyARPartialDifferentiationOptimize.h"
#include "nyarcore.h"
#include <cstdlib>
namespace NyARToolkitCPP
{
#define FIT_DIFF_THRESHOLD 0.01
#define FIT_DIFF_THRESHOLD_CONT 1.0



	NyARTransMat::NyARTransMat()
	{
		this->_center.x=0;
		this->_center.y=0;
		//_calculator,_rotmatrix,_mat_optimizeRXgN^̏I
		//쐬Ċ蓖ĂĂB
		return;
	}
	NyARTransMat::NyARTransMat(const NyARParam* i_param)
	{
		this->_center.x=0;
		this->_center.y=0;
		const NyARCameraDistortionFactor* dist=&i_param->getDistortionFactor();
		const NyARPerspectiveProjectionMatrix* pmat=&i_param->getPerspectiveProjectionMatrix();
		this->_transsolver=new NyARTransportVectorSolver(pmat,4);
		//݊dvȎ́ANyARRotMatrix_ARToolKitgƁB
		//NyARRotMatrix_NyARToolKitNyARRotMatrix_ARToolKitǁAlB
		this->_rotmatrix = new NyARRotMatrix(pmat);
		this->_mat_optimize=new NyARPartialDifferentiationOptimize(pmat);
		this->_ref_dist_factor=dist;
		this->_projection_mat_ref=pmat;
	}
	NyARTransMat::~NyARTransMat()
	{
		NyAR_SAFE_DELETE(this->_transsolver);
		NyAR_SAFE_DELETE(this->_rotmatrix);
		NyAR_SAFE_DELETE(this->_mat_optimize);
		return;
	}

	void NyARTransMat::setCenter(double i_x, double i_y)
	{
		this->_center.x= i_x;
		this->_center.y= i_y;
		return;
	}


	void NyARTransMat::initVertexOrder(const NyARSquare& i_square, int i_direction,const TNyARDoublePoint2d* o_sqvertex_ref[],const TNyARLinear* o_liner_ref[])const
	{
		//_l`̒_
		o_sqvertex_ref[0]= &i_square.sqvertex[(4 - i_direction) % 4];
		o_sqvertex_ref[1]= &i_square.sqvertex[(5 - i_direction) % 4];
		o_sqvertex_ref[2]= &i_square.sqvertex[(6 - i_direction) % 4];
		o_sqvertex_ref[3]= &i_square.sqvertex[(7 - i_direction) % 4];	
		o_liner_ref[0]=&i_square.line[(4 - i_direction) % 4];
		o_liner_ref[1]=&i_square.line[(5 - i_direction) % 4];
		o_liner_ref[2]=&i_square.line[(6 - i_direction) % 4];
		o_liner_ref[3]=&i_square.line[(7 - i_direction) % 4];
		return;
	}


	void NyARTransMat::transMat(const NyARSquare& i_square, int i_direction, double i_width, NyARTransMatResult& o_result)
	{
		const TNyARDoublePoint2d* sqvertex_ref[4];
		const TNyARLinear* linear_ref[4];
		TNyARDoublePoint3d trans;
		
		//vZpɒ_iԒj
		initVertexOrder(i_square, i_direction, sqvertex_ref,linear_ref);
		
		TNyARDoublePoint2d vertex_2d[4];
		TNyARDoublePoint3d vertex_3d[4];

		//sړʌvZ@ɁA2DWnZbg
		this->_ref_dist_factor->ideal2ObservBatch(sqvertex_ref, vertex_2d,4);		
		this->_transsolver->set2dVertex(vertex_2d,4);
		
		//`3DWn쐬
		this->_offset.setSquare(i_width,this->_center);

		//]svZ
		this->_rotmatrix->initRotBySquare(linear_ref,sqvertex_ref);
		
		//]3DWnAsړʂvZ
		this->_rotmatrix->getPoint3dBatch(this->_offset.vertex,vertex_3d,4);
		this->_transsolver->solveTransportVector(vertex_3d,trans);
		
		//vZʂ̍œK(sړʂƉ]s̍œK)
		this->optimize(*this->_rotmatrix, trans,*this->_transsolver,this->_offset.vertex, vertex_2d);
		
		// }gNX̕ۑ
		this->updateMatrixValue(*this->_rotmatrix, this->_offset.point, trans,o_result);
		return;
	}


	void NyARTransMat::transMatContinue(const NyARSquare& i_square, int i_direction, double i_width, NyARTransMatResult& io_result_conv)
	{
		const TNyARDoublePoint2d* sqvertex_ref[4];
		const TNyARLinear* linear_ref[4];
		TNyARDoublePoint3d trans;

		// io_result_convlȂAtransMatŌvZB
		if (!io_result_conv.has_value) {
			this->transMat(i_square, i_direction, i_width, io_result_conv);
			return;
		}

		//vZpɒ_iԒj
		initVertexOrder(i_square, i_direction, sqvertex_ref,linear_ref);

		
		//sړʌvZ@ɁA2DWnZbg
		TNyARDoublePoint2d vertex_2d[4];
		TNyARDoublePoint3d vertex_3d[4];
		this->_ref_dist_factor->ideal2ObservBatch(sqvertex_ref, vertex_2d,4);		
		this->_transsolver->set2dVertex(vertex_2d,4);
		
		//`3DWn쐬
		this->_offset.setSquare(i_width,this->_center);

		//]svZ
		this->_rotmatrix->initRotByPrevResult(io_result_conv);
		
		//]3DWnAsړʂvZ
		this->_rotmatrix->getPoint3dBatch(this->_offset.vertex,vertex_3d,4);
		this->_transsolver->solveTransportVector(vertex_3d,trans);

		//݂̃G[[gvZĂ
		double min_err=errRate(*this->_rotmatrix,trans, this->_offset.vertex, vertex_2d,4,vertex_3d);
		NyARDoubleMatrix33& rot=this->__rot;
		//G[[g臒lĂAQC
		if(min_err<FIT_DIFF_THRESHOLD_CONT){
			rot.setValue(*this->_rotmatrix);
			//œKĂ݂B
			for (int i = 0;i<5; i++) {
				//ϊs̍œK
				this->_mat_optimize->modifyMatrix(rot, trans, this->_offset.vertex, vertex_2d, 4);
				double err=errRate(rot,trans,this->_offset.vertex, vertex_2d,4,vertex_3d);
				//System.out.println("E:"+err);
				if(min_err-err<FIT_DIFF_THRESHOLD){
					//System.out.println("BREAK");
					break;
				}
				this->_transsolver->solveTransportVector(vertex_3d, trans);
				this->_rotmatrix->setValue(rot);
				min_err=err;
			}
			this->updateMatrixValue(*this->_rotmatrix, this->_offset.point, trans,io_result_conv);
		}else{
			//]svZ
			this->_rotmatrix->initRotBySquare(linear_ref,sqvertex_ref);
			
			//]3DWnAsړʂvZ
			this->_rotmatrix->getPoint3dBatch(this->_offset.vertex,vertex_3d,4);
			this->_transsolver->solveTransportVector(vertex_3d,trans);
			
			//vZʂ̍œK(sړʂƉ]s̍œK)
			this->optimize(*this->_rotmatrix, trans,*this->_transsolver,this->_offset.vertex, vertex_2d);
			this->updateMatrixValue(*this->_rotmatrix, this->_offset.point, trans,io_result_conv);
		}
		return;
	}
	double NyARTransMat::optimize(NyARRotMatrix& io_rotmat,TNyARDoublePoint3d& io_transvec,const INyARTransportVectorSolver& i_solver,TNyARDoublePoint3d i_offset_3d[],TNyARDoublePoint2d i_2d_vertex[])
	{
		//System.out.println("START");
		TNyARDoublePoint3d vertex_3d[4];
		//̃G[lvZ
		double min_err=errRate(io_rotmat, io_transvec, i_offset_3d, i_2d_vertex,4,vertex_3d);
		NyARDoubleMatrix33& rot=this->__rot;
		rot.setValue(io_rotmat);
		for (int i = 0;i<5; i++) {
			//ϊs̍œK
			this->_mat_optimize->modifyMatrix(rot, io_transvec, i_offset_3d, i_2d_vertex, 4);
			double err=errRate(rot,io_transvec, i_offset_3d, i_2d_vertex,4,vertex_3d);
			//System.out.println("E:"+err);
			if(min_err-err<FIT_DIFF_THRESHOLD){
				//System.out.println("BREAK");
				break;
			}
			i_solver.solveTransportVector(vertex_3d, io_transvec);
			io_rotmat.setValue(rot);
			min_err=err;
		}
		//System.out.println("END");
		return min_err;
	}
	
	//G[[gvZ@
	double NyARTransMat::errRate(const NyARDoubleMatrix33& io_rot,const TNyARDoublePoint3d& i_trans, TNyARDoublePoint3d i_vertex3d[], TNyARDoublePoint2d i_vertex2d[],int i_number_of_vertex,TNyARDoublePoint3d o_rot_vertex[])
	{
		const NyARPerspectiveProjectionMatrix& cp = *this->_projection_mat_ref;
		double cp00=cp.m00;
		double cp01=cp.m01;
		double cp02=cp.m02;
		double cp11=cp.m11;
		double cp12=cp.m12;

		double err=0;
		for(int i=0;i<i_number_of_vertex;i++){
			double x3d,y3d,z3d;
			o_rot_vertex[i].x=x3d=io_rot.m00*i_vertex3d[i].x+io_rot.m01*i_vertex3d[i].y+io_rot.m02*i_vertex3d[i].z;
			o_rot_vertex[i].y=y3d=io_rot.m10*i_vertex3d[i].x+io_rot.m11*i_vertex3d[i].y+io_rot.m12*i_vertex3d[i].z;
			o_rot_vertex[i].z=z3d=io_rot.m20*i_vertex3d[i].x+io_rot.m21*i_vertex3d[i].y+io_rot.m22*i_vertex3d[i].z;
			x3d+=i_trans.x;
			y3d+=i_trans.y;
			z3d+=i_trans.z;
			
			//ˉeϊ
			double x2d=x3d*cp00+y3d*cp01+z3d*cp02;
			double y2d=y3d*cp11+z3d*cp12;
			double h2d=z3d;
			
			//G[[gvZ
			double t1=i_vertex2d[i].x-x2d/h2d;
			double t2=i_vertex2d[i].y-y2d/h2d;
			err+=t1*t1+t2*t2;
			
		}
		return err/i_number_of_vertex;
	}
	void NyARTransMat::updateMatrixValue(const NyARRotMatrix& i_rot,const TNyARDoublePoint3d& i_off, const TNyARDoublePoint3d& i_trans,NyARTransMatResult& o_result)
	{
		o_result.m00=i_rot.m00;
		o_result.m01=i_rot.m01;
		o_result.m02=i_rot.m02;
		o_result.m03=i_rot.m00 * i_off.x + i_rot.m01 * i_off.y + i_rot.m02 * i_off.z + i_trans.x;

		o_result.m10 = i_rot.m10;
		o_result.m11 = i_rot.m11;
		o_result.m12 = i_rot.m12;
		o_result.m13 = i_rot.m10 * i_off.x + i_rot.m11 * i_off.y + i_rot.m12 * i_off.z + i_trans.y;

		o_result.m20 = i_rot.m20;
		o_result.m21 = i_rot.m21;
		o_result.m22 = i_rot.m22;
		o_result.m23 = i_rot.m20 * i_off.x + i_rot.m21 * i_off.y + i_rot.m22 * i_off.z + i_trans.z;
		o_result.has_value = true;
		return;
	}
}

