/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCS is C++ version NyARToolkit class library.
* 
* Copyright (C)2008 R.Iizuka
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this framework; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp>
* 
*/
#pragma once
#include "NyARBaseClass.h"
#include "NyARParam.h"
#include "NyARMatchPatt_Color_WITHOUT_PCA.h"
#include "INyARSquareDetector.h"
#include "INyARTransMat.h"
#include "NyARTransMat.h"
#include "NyARRasterFilter_ARToolkitThreshold.h"
#include "NyARTransMatResult.h"
#include "NyARColorPatt_O3.h"
#include "NyARSquareDetector.h"
#include "NyARSquareStack.h"
#include "NyAR_types.h"
namespace NyARToolkitCPP
{
	class NyARCustomSingleDetectMarker: public NyARBaseClass
	{
	private:
		bool _is_continue;
		NyARMatchPatt_Color_WITHOUT_PCA* _match_patt;
		INyARSquareDetector* _square_detect;
		NyARSquareStack* _square_list;
		//
		double _marker_width;
		int _detected_direction;
		double _detected_confidence;
		NyARSquare* _detected_square;
		INyARColorPatt* _patt;
		//揈p
		NyARBinRaster* _bin_raster;
		//
		NyARMatchPattDeviationColorData* _deviation_data;
		TNyARMatchPattResult __detectMarkerLite_mr;
	protected:
		INyARTransMat* _transmat;
		//
		const INyARRasterFilter_RgbToBin* _tobin_filter;
		//
	protected:
		//filter͎Ō߂
		NyARCustomSingleDetectMarker();
		void initInstance(const NyARParam* i_param,const NyARCode* i_code, double i_marker_width,const INyARRasterFilter_RgbToBin* i_filter);
	public:
		NyARCustomSingleDetectMarker(const NyARParam* i_param,const NyARCode* i_code, double i_marker_width,const INyARRasterFilter_RgbToBin* i_filter);
		virtual ~NyARCustomSingleDetectMarker();
	public:
		bool detectMarkerLite(const INyARRgbRaster& i_raster);
		void getTransmationMatrix(NyARTransMatResult &o_result)const;
		void getSquarePosition(TNyARIntPoint2d o_point[])const;
		const TNyARIntPoint2d& refSquarePosition()const;
		double getConfidence()const;
		int getDirection()const;
		void setContinueMode(bool i_is_continue);
	};

}

