/*
 *  UART Driver
 */

#ifndef _UARTDEV_FM3_H_
#define _UARTDEV_FM3_H_


/*
 *  User Must Setting Value
 */
#define UART_CH          0                    /* Default UART CH     */
#define UART_BAUDRATE    115200               /* Default Baudrate    */
#define UART_DATABITS    UartDev_DATABITS_8   /* Default Data bits   */
#define UART_STOPBITS    UartDev_STOPBITS_1   /* Default Stop bits   */
#define UART_PARITY      UartDev_PARITY_NONE  /* Default Parity      */
#define UART_BITODER     UartDev_BITORDER_LSB /* Default BitOrder    */


/*
 *  Driver Status
 */
#define UART_UNINITIALIZED    0
#define UART_INITIALIZED      1



/*
 *  Internel setting, based User Setting
 */
#if (UART_CH == 0)
    #define USE_CH03
    #define UART_REG_ADR    FM3_MFS0_UART
#elif (UART_CH == 1)
    #define USE_CH03
    #define UART_REG_ADR    FM3_MFS1_UART
#elif (UART_CH == 2)
    #define USE_CH03
    #define UART_REG_ADR    FM3_MFS2_UART
#elif (UART_CH == 3)
    #define USE_CH03
    #define UART_REG_ADR    FM3_MFS3_UART
#elif (UART_CH == 4)
    #undef USE_CH03
    #define UART_REG_ADR    FM3_MFS4_UART
#elif (UART_CH == 5)
    #undef USE_CH03
    #define UART_REG_ADR    FM3_MFS5_UART
#elif (UART_CH == 6)
    #undef USE_CH03
    #define UART_REG_ADR    FM3_MFS6_UART
#elif (UART_CH == 7)
    #undef USE_CH03
    #define UART_REG_ADR    FM3_MFS7_UART
#else
    #error "UART_CH ERROR"
#endif


/*
 *  Register Bit Definition
 */
#define SMR_SOE          0x01U
#define SMR_BDS          0x04U
#define SMR_SBL          0x08U
#define SMR_WUCR         0x10U
#define SMR_MD_UART      0x00U
#define SMR_MD_UART_MP   0x20U
#define SMR_MD_SIO       0x40U
#define SMR_MD_LIN       0x60U
#define SMR_MD_I2C       0x80U

#define SCR_TXE          0x01U
#define SCR_RXE          0x02U
#define SCR_TBIE         0x04U
#define SCR_TIE          0x08U
#define SCR_RIE          0x10U
#define SCR_UPGL         0x80U

#define SSR_TBI          0x01U
#define SSR_TDRE         0x02U
#define SSR_RDRF         0x04U
#define SSR_ORE          0x08U
#define SSR_FRE          0x10U
#define SSR_PE           0x20U
#define SSR_REC          0x80U

#define ESCR_P           0x08U
#define ESCR_PEN         0x10U
#define ESCR_INV         0x20U
#define ESCR_ESBL        0x40U
#define ESCR_FLWEN       0x80U
#define ESCR_DATABITS_8  0x00U
#define ESCR_DATABITS_5  0x01U
#define ESCR_DATABITS_6  0x02U
#define ESCR_DATABITS_7  0x03U
#define ESCR_DATABITS_9  0x04U

#define BGR_EXT          0x8000U

#define FCR1_FSEL        0x01U
#define FCR1_FTIE        0x02U
#define FCR1_FDRQ        0x04U
#define FCR1_FRIIE       0x08U
#define FCR1_FLSTE       0x10U

#define FCR0_FE1         0x01U
#define FCR0_FE2         0x02U
#define FCR0_FCL1        0x04U
#define FCR0_FCL2        0x08U
#define FCR0_FSET        0x10U
#define FCR0_FLD         0x20U
#define FCR0_FLST        0x40U


/*
 *  Channel Common Function 
 */
int32_t  Uart_Init(void);
int32_t  Uart_UnInit(void);
int32_t  Uart_BufTx(void *pData, int32_t *pSize);
int32_t  Uart_BufRx(void *pData, int32_t *pSize);


#endif /* _UARTDEV_FM3_H_ */

