/**
 * @file ntmshell.h
 * @author Shinichiro Nakamura
 * @brief NTMシェルシステムの定義。
 */

/*
 * ===============================================================
 *  Natural Tiny Monitor (NT-Monitor)
 * ===============================================================
 * Copyright (c) 2011-2012 Shinichiro Nakamura
 * Inspired by M, Murakami
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#ifndef NTMSHELL_H
#define NTMSHELL_H

#include "ntmconf.h"

#if (NTMCONF_USE_NTSHELL == 1)

#   include "ntshell.h"
#   define ntmshell_t       ntshell_t
#   define ntmshell_version ntshell_version
#   define ntmshell_execute ntshell_execute

#else

    typedef struct {
        char buf_curr[NTMCONF_EDITOR_MAXLEN];
        char buf_prev[NTMCONF_EDITOR_MAXLEN];
        int len;
    } ntmshell_t;

    void ntmshell_version(int *major, int *minor, int *release);
    void ntmshell_execute(
            ntmshell_t *p,
            int (*func_read)(char *buf, int cnt),
            int (*func_write)(const char *buf, int cnt),
            int (*func_callback)(const char *text, void *extobj),
            void *func_callback_extobj);

#endif

#endif

