/**
 * @file ntmlibc.h
 * @author Shinichiro Nakamura
 * @brief NTMで用いる小規模libcの定義。
 */

/*
 * ===============================================================
 *  Natural Tiny Monitor (NT-Monitor)
 * ===============================================================
 * Copyright (c) 2011-2012 Shinichiro Nakamura
 * Inspired by M, Murakami
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#ifndef NTMLIBC_H
#define NTMLIBC_H

#include "ntmconf.h"

#if (NTMCONF_USE_NTSHELL == 1)

#   include "ntlibc.h"
#   define ntmlibc_strlen   ntlibc_strlen
#   define ntmlibc_strcpy   ntlibc_strcpy
#   define ntmlibc_strcat   ntlibc_strcat
#   define ntmlibc_strcmp   ntlibc_strcmp
#   define ntmlibc_strncmp  ntlibc_strncmp

#else

    int ntmlibc_strlen(const char *s);
    char *ntmlibc_strcpy(char *des, const char *src);
    char *ntmlibc_strcat(char *des, const char *src);
    int ntmlibc_strcmp(const char *s1, const char *s2);
    int ntmlibc_strncmp(const char *s1, const char *s2, int n);

#endif

#endif

