/**
 * @file ntmattr.h
 * @author Shinichiro Nakamura
 * @brief メモリ情報の定義。
 */

/*
 * ===============================================================
 *  Natural Tiny Monitor (NT-Monitor)
 * ===============================================================
 * Copyright (c) 2011-2012 Shinichiro Nakamura
 * Inspired by M, Murakami
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#ifndef NTMATTR_H
#define NTMATTR_H

#include "ntmint.h"

/**
 * @param メモリ属性の定義。
 */
typedef enum {
    NTMATTR_ATTR_UNKNOWN = 0,   /**< Unknown attribute. */
    NTMATTR_ATTR_RW = 1,        /**< Read / Write */
    NTMATTR_ATTR_RO = 2,        /**< Read Only */
    NTMATTR_ATTR_WO = 3,        /**< Write Only */
    NTMATTR_ATTR_RSV = 4,       /**< Reserved */
} ntmattr_attr_t;

/**
 * @param メモリ情報定義。
 */
typedef struct {
    char name[32];              /**< 名前。 */
    uint32_t addr_start;        /**< 開始アドレス。 */
    uint32_t addr_end;          /**< 終了アドレス。 */
    ntmattr_attr_t attr;         /**< メモリ属性。 */
} ntmattr_info_t;

/**
 * @brief メモリ情報を取得する。
 *
 * @param addr アドレス。
 * @param meminfo メモリ情報構造体。
 *
 * @retval 0 指定アドレスのメモリ情報が存在し取得した。
 * @retval !0 指定アドレスのメモリ情報が存在しなかった。
 */
int ntmattr_get_info(uint32_t addr, ntmattr_info_t *meminfo);

#endif

