/* Copyright 2013,2014 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <openssl/sha.h>
#include <pthread.h>

#include "env.h"
#include "utils/nt_std_t.h"
#include "utils/db.h"

static pthread_mutex_t g_init_path_lock_mutex = PTHREAD_MUTEX_INITIALIZER;

const char *nt_db_get_log_path()
{
	static char path[256];
	static int f = 0;
	pthread_mutex_lock(&g_init_path_lock_mutex);
	if(f == 0){
		strcpy(path, LOG_PATH);
		strcat(path, "/");
		strcat(path, LOG_DB_NAME);
	}
	pthread_mutex_unlock(&g_init_path_lock_mutex);
	return path;
}

const char *nt_db_get_idx_path()
{
	static char path[256];
	static int f = 0;
	pthread_mutex_lock(&g_init_path_lock_mutex);
	if(f == 0){
		strcpy(path, LOG_PATH);
		strcat(path, "/");
		strcat(path, INDEX_DB_NAME);
	}
	pthread_mutex_unlock(&g_init_path_lock_mutex);
	return path;
}


BOOL nt_db_cpy_key(const char *src, char *dst)
{
	assert(src != NULL);

	int len, offset;

	len = strlen(src);

	if(len < (DB_KEY_SIZE_MAX-1))
		return FALSE;

	offset = len - (DB_KEY_SIZE_MAX-1);
	memcpy(dst, src+offset, (DB_KEY_SIZE_MAX-1));
	dst[(DB_KEY_SIZE_MAX-1)] = '\0';

	return TRUE;
}
