/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/

#ifndef _NT_CLOUD_H_
#define _NT_CLOUD_H_

#include "usr/usr_db_t.h"

#ifdef NT_CLOUD


typedef struct tag_nt_cloud_handle *nt_cloud_handle;
typedef struct tag_nt_cloud_handle{
	int chk_sum;
}nt_cloud_handle_t;

extern nt_cloud_handle nt_cloud_init(
		const char *auth_url, const char *usr_id, const char *pass);
extern BOOL nt_cloud_chk_user(nt_cloud_handle handle);
extern BOOL nt_cloud_upload_file(nt_cloud_handle handle,
		const char *file_name, nt_link_tp lines);
extern nt_link_tp nt_cloud_download_file(nt_cloud_handle handle,
		const char *file_name);

extern BOOL nt_cloud_insert_lines_into_file(nt_cloud_handle handle,
		const char *file_name, nt_link_tp lines);
extern BOOL nt_cloud_delete_lines_from_file(nt_cloud_handle handle,
		const char *file_name, nt_link_tp lines);
extern BOOL nt_cloud_insert_lines_into_file_async(nt_cloud_handle handle,
		const char *file_name, nt_link_tp lines);
extern BOOL nt_cloud_delete_lines_from_file_async(nt_cloud_handle handle,
		const char *file_name, nt_link_tp lines);

extern void nt_cloud_update_read_count_async(nt_cloud_handle handle, 
		const wchar_t *board_name, const wchar_t *dat_name, 
		int res_number);
extern BOOL nt_cloud_update_read_count(nt_cloud_handle handle, 
		const wchar_t *board_name, const wchar_t *dat_name, 
		int res_number, int depth);
extern BOOL nt_cloud_query_board_attributes(nt_cloud_handle handle, 
		const wchar_t *board_name, nt_usr_db_handle db_handle, int depth);

extern void nt_cloud_delete_read_count_async(nt_cloud_handle handle, 
		const wchar_t *board_name, const wchar_t *dat_name);
extern BOOL nt_cloud_delete_read_count(nt_cloud_handle handle, 
		const wchar_t *board_name, const wchar_t *dat_name,
		int depth);

extern BOOL nt_cloud_query_favorite_attributes_async(nt_cloud_handle handle, 
		nt_usr_db_handle db_handle);
extern BOOL nt_cloud_query_attributes(nt_cloud_handle handle, 
		nt_usr_db_handle db_handle, int depth);



extern nt_cloud_handle nt_cloud_get_handle();
extern int nt_cloud_add_ref(nt_cloud_handle);
extern int nt_cloud_release_ref(nt_cloud_handle);

#ifdef NT_CLOUD_PRIVATE

#define NT_CLOUD_CHK_SUM (1478428)

typedef struct tag_nt_cloud_t *nt_cloud_tp;
typedef struct tag_nt_cloud_t {
	nt_cloud_handle_t handle;
	int ref_count;
	char *usr_id;
	char *passwd;
	char *auth_url;
	char *query_url;
	char *home_url;
	char *token;
	int error_no;
}nt_cloud_t;

extern int nt_get_cloud_result(const char *ptr);
extern nt_link_tp nt_split_line(char *data);

extern BOOL nt_wc_sjis_aes_b64_url_encode(
		iconv_t icd, nt_crypt_handle h_crypt,
		const wchar_t *in_data,
		unsigned char *wrk_buf, char *out_data, size_t max_len);
extern BOOL nt_url_b64_aes_sjis_wc_decode(
		iconv_t icd, nt_crypt_handle h_crypt,
		const char *in_data,
		unsigned char *wrk_buf, wchar_t *out_data, size_t max_len);

extern BOOL nt_ascii_aes_b64_url_encode(
		iconv_t icd, nt_crypt_handle h_crypt,
		const char *in_data,
		unsigned char *wrk_buf, char *out_data, size_t max_len);
extern BOOL nt_url_b64_aes_ascii_decode(
		iconv_t icd, nt_crypt_handle h_crypt,
		const char *in_data,
		unsigned char *wrk_buf, char *out_data, size_t max_len);

#define NT_CLOUD_INSERT_LINES_FILE_PHP "nc_insert_lines_file.php"
#define NT_CLOUD_DELETE_LINES_FILE_PHP "nc_delete_lines_file.php"
#define NT_CLOUD_WRITE_FILE_PHP "nc_write_file.php"
#define NT_CLOUD_UPDATE_READ_CNT_PHP "nc_update_readcnt_db.php"
#define NT_CLOUD_QUERY_ATTRIBUTES_PHP "nc_query_attributes_db.php"
#define NT_CLOUD_QUERY_BOARD_ATTRIBUTES_PHP "nc_query_board_attributes_db.php"
#define NT_CLOUD_DELETE_READ_CNT_PHP "nc_delete_readcnt_db.php"

#endif /*NT_CLOUD_PRIVATE*/

#endif /*NT_CLOUD*/
#endif /*_NT_CLOUD_H_*/
