﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using NotepadNeueExtension;

namespace BaseExtension
{
    public partial class ScriptExtension : CExtension
    {
        public override string ExtensionName
        {
            get
            {
                ///ここの名前を変える事でNotepadNeue内での表示名が変わります。
                return "スクリプト実行";
            }
            set
            {
            }
        }
        //Hostの参照
        public IExtensionHost Host
        {
            get;
            set;
        }
        //NotepadNeue内から呼び出されます。
        //Windowsアプリケーションとしてコンパイルしている間は呼び出されないので注意してください。
        public override void Initialize(IExtensionHost Host)
        {
            this.Host = Host;
            //メインフォームが閉じたときにイベントを取得する場合は以下のコメントアウトを解除し
            //Host_MainFormClosedメソッド内に処理を書いてください。
            //Host.MainFormClosed += new EventHandler(Host_MainFormClosed);
            InitializeComponent();
            this.GotFocus += new EventHandler(ScriptExtension_GotFocus);
            this.openFileDialog1.RestoreDirectory = true;
            this.openFileDialog1.Filter = "Pythonファイル(*.py)|*.py|Rubyファイル(*.rb)|*.rb|すべてのファイル(*.*)|*.*";
            this.openFileDialog1.FileName = "";
        }

        void ScriptExtension_GotFocus(object sender, EventArgs e)
        {
            this.textBox1.Focus();
        }

        void Host_MainFormClosed(object sender, EventArgs e)
        {

        }
        //このコンストラクタはWindowsアプリケーションとしてコンパイルする場合に使用してください。
        //クラスライブラリとしてコンパイルする場合にはコメントアウトしてください。
        public ScriptExtension()
        {
            //InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (this.textBox1.Text == "")
            {
                MessageBox.Show("テキストがありません");
                return;
            }
            Host.RunPythonFromString(this.textBox1.Text, new KeyValuePair<string, object>[0]);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (!File.Exists(this.textBox2.Text))
            {
                MessageBox.Show("ファイルが存在しません");
                return;
            }
            Host.RunPythonFromFile(this.textBox2.Text, new KeyValuePair<string, object>[0]);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                this.textBox2.Text = openFileDialog1.FileName;
            }
        }

        private void ScriptExtension_BackgroundImageChanged(object sender, EventArgs e)
        {
            ChangeBackground();
        }
        private void ChangeBackground()
        {
            if (splitContainer1.Panel2.Width > 0 && splitContainer1.Panel2.Height > 0)
            {
                Point zure = new Point(0, splitContainer1.Panel1.Height);
                Bitmap tempbit = new Bitmap(splitContainer1.Panel2.Width, splitContainer1.Panel2.Height);
                Graphics g = Graphics.FromImage(tempbit);
                if (this.BackgroundImage == null)
                {
                    SolidBrush sb = new SolidBrush(this.BackColor);
                    g.FillRectangle(sb, new Rectangle(0, 0, tempbit.Width, tempbit.Height));
                    splitContainer1.Panel2.BackgroundImage = tempbit;
                    sb.Dispose();
                }
                else
                {
                    g.DrawImage(this.BackgroundImage, new Rectangle(0, 0, tempbit.Width, tempbit.Height), new Rectangle(zure.X, zure.Y, tempbit.Width, tempbit.Height), GraphicsUnit.Pixel);
                    splitContainer1.Panel2.BackgroundImage = tempbit;
                }
            }
        }

        private void splitContainer1_SplitterMoved(object sender, SplitterEventArgs e)
        {
            ChangeBackground();
        }

        private void textBox1_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
        {
            if (e.KeyCode == Keys.Tab)
            {
                if (e.Shift)
                {
                    int size = textBox1.SelectionStart < 3 ? textBox1.SelectionStart : 3;
                    if (textBox1.Text.Substring(textBox1.SelectionStart - size, size).Trim() == "")
                    {
                        int selStart = textBox1.SelectionStart;
                        string newText = textBox1.Text.Remove(textBox1.SelectionStart - size, size);
                        textBox1.Text = newText;
                        textBox1.SelectionStart = selStart + size;
                    }
                }
                else
                {
                    int selStart = textBox1.SelectionStart;
                    string newText = textBox1.Text.Remove(textBox1.SelectionStart, textBox1.SelectionLength).Insert(textBox1.SelectionStart, "   ");
                    textBox1.Text = newText;
                    textBox1.SelectionStart = selStart + 3;
                }
                e.IsInputKey = true;
            }
            else if (e.KeyCode == Keys.Return)
            {
                int whiteSpaceCount = GetCurrentLineWhiteSpaceCount(textBox1.Text, textBox1.SelectionStart);
                int selStart = textBox1.SelectionStart;
                StringBuilder sb = new StringBuilder();
                sb.Append("\r\n");
                sb.Append(' ', whiteSpaceCount);
                string insertText = sb.ToString();
                string newText = textBox1.Text.Remove(textBox1.SelectionStart, textBox1.SelectionLength).Insert(textBox1.SelectionStart, insertText);
                textBox1.Text = newText;
                textBox1.SelectionStart = selStart + insertText.Length;
                e.IsInputKey = true;
            }
        }

        private int GetCurrentLineWhiteSpaceCount(string text, int index)
        {
            int count = 0;
            for (int i = index >= text.Length ? text.Length - 1 : index; i >= 0; i--)
            {
                bool finish = false;
                switch (text[i])
                {
                    case ' ':
                        count++;
                        break;
                    case '\n':
                        finish = true;
                        break;
                    case '\r':
                        finish = true;
                        break;
                }

                if (finish)
                {
                    break;
                }
            }
            return count;
        }

        private void textBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Tab)
            {
                e.Handled = true;
            }
            else if (e.KeyCode == Keys.Return)
            {
                e.Handled = true;
            }
        }

        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\t')
            {
                e.Handled = true;
            }
            else if (e.KeyChar == '\n' || e.KeyChar == '\r')
            {
                e.Handled = true;
            }
        }
    }
}
