﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseExtension.RegularExpressions
{
    class ParserRegexTokenContent : ParserRegexContent
    {
        public Func<ParseToken, bool> Func
        {
            get;
            private set;
        }

        public ParserRegexTokenContent(Func<ParseToken, bool> func)
        {
            Func = func;
        }

        public override bool IsMatch(ParseToken token)
        {
            if (Func != null)
            {
                return Func(token);
            }
            return false;
        }
    }
}
