﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseExtension.RegularExpressions
{
    class ParserRegexExpression
    {
        public ParserRegexContent Content
        {
            get;
            private set;
        }

        public ParserRegexType Type
        {
            get;
            private set;
        }

        public int Count
        {
            get;
            private set;
        }

        public ParserRegexCountType CountType
        {
            get;
            private set;
        }

        public string Name
        {
            get;
            private set;
        }

        public ParserRegexExpression(ParserRegexContent content, ParserRegexType type, int count, ParserRegexCountType countType)
            : this(content, type, count, countType, null)
        {
        }

        public ParserRegexExpression(ParserRegexContent content, ParserRegexType type, int count, ParserRegexCountType countType, string name)
        {
            if (count < 0)
            {
                count = 0;
                countType = ParserRegexCountType.MoreThanEqual;
            }

            Content = content;
            Type = type;
            Count = count;
            CountType = countType;
            Name = name;
        }

        public bool IsMatch(ParseToken token)
        {
            return Type.IsMatch(token) && Content.IsMatch(token);
        }
    }
}
