﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseExtension
{
    static class ParseTokenExtensions
    {
        public static string Join(this ParseToken[] tokens)
        {
            return Join(tokens, 0, tokens.Length);
        }

        public static string Join(this IEnumerable<ParseToken> tokens, int startIndex, int length)
        {
            return tokens.Skip(startIndex).Take(length).Aggregate("", (s, p) => String.Format("{0}{1}", s, p.Token));
        }
    }
}
