﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace NotepadNeueExtension
{
    /// <summary>
    /// オブジェクト情報
    /// </summary>
    public class ObjectInfo : AssistInformation
    {
        string name;
        /// <summary>
        /// オブジェクトが属する名前空間
        /// </summary>
        public NameSpaceInfo Namespace
        {
            get;
            set;
        }
        SortedList<string, ObjectInfo> inheritedobjects;
        SortedList<string, FunctionInfo> methods;
        SortedList<string, VariableInfo> variables;
        SortedList<string, DefineValueInfo> definevalues;
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ObjectInfo()
        {
            Image = NotepadNeueExtension.Properties.Resources._class;
            inheritedobjects = new SortedList<string, ObjectInfo>();
            methods = new SortedList<string, FunctionInfo>();
            variables = new SortedList<string, VariableInfo>();
            definevalues = new SortedList<string, DefineValueInfo>();
        }
        /// <summary>
        /// 継承オブジェクトを追加する
        /// </summary>
        /// <param name="inheritedobject"></param>
        /// <param name="name"></param>
        public void AddInheritedObject(ObjectInfo inheritedobject, string name)
        {
            if (!inheritedobjects.ContainsKey(name))
            {
                inheritedobjects.Add(name, inheritedobject);
            }
        }
        /// <summary>
        /// メソッドを追加する
        /// </summary>
        /// <param name="method"></param>
        /// <param name="name"></param>
        public void AddMethod(FunctionInfo method, string name)
        {
            if (!methods.ContainsKey(name))
            {
                methods.Add(name, method);
            }
            else
            {
                FunctionInfo tempfunctioninfo = null;
                if (methods.TryGetValue(name, out tempfunctioninfo))
                {
                    tempfunctioninfo.AddContent(method.ContentAt(0));
                }
            }
        }
        /// <summary>
        /// 変数を追加する
        /// </summary>
        /// <param name="variable"></param>
        /// <param name="name"></param>
        public void AddVariable(VariableInfo variable, string name)
        {
            if (!variables.ContainsKey(name))
            {
                variables.Add(name, variable);
            }
        }
        /// <summary>
        /// 定義値を追加する
        /// </summary>
        /// <param name="definevalue"></param>
        /// <param name="name"></param>
        public void AddDefineValueInfo(DefineValueInfo definevalue, string name)
        {
            if (!definevalues.ContainsKey(name))
            {
                definevalues.Add(name, definevalue);
            }
        }
        /// <summary>
        /// 名前から変数情報を取得する
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        public virtual VariableInfo GetVariableInfo(string name)
        {
            VariableInfo ret = null;
            variables.TryGetValue(name, out ret);
            return ret;
        }
        /// <summary>
        /// 全ての関数を取得する
        /// </summary>
        /// <returns></returns>
        public virtual FunctionInfo[] GetAllFunction()
        {
            List<FunctionInfo> ret = new List<FunctionInfo>();
            foreach (FunctionInfo fi in methods.Values)
            {
                ret.Add(fi);
            }
            foreach (ObjectInfo oi in inheritedobjects.Values)
            {
                foreach (FunctionInfo fi in oi.GetAllFunction())
                {
                    ret.Add(fi);
                }
            }
            return ret.ToArray();
        }
        /// <summary>
        /// 全ての関数を取得する
        /// </summary>
        /// <param name="accesstype"></param>
        /// <returns></returns>
        public virtual FunctionInfo[] GetAllFunction(AccessType accesstype)
        {
            List<FunctionInfo> ret = new List<FunctionInfo>();
            foreach (FunctionInfo fi in methods.Values)
            {
                if (fi.AccessType >= accesstype) ret.Add(fi);
            }
            foreach (ObjectInfo oi in inheritedobjects.Values)
            {
                foreach (FunctionInfo fi in oi.GetAllFunction(AccessType.Protected))
                {
                    if (fi.AccessType >= accesstype) ret.Add(fi);
                }
            }
            return ret.ToArray();
        }
        /// <summary>
        /// 全ての変数を取得する
        /// </summary>
        /// <returns></returns>
        public virtual VariableInfo[] GetAllVariable()
        {
            List<VariableInfo> ret = new List<VariableInfo>();
            foreach (VariableInfo vi in variables.Values)
            {
                ret.Add(vi);
            }
            foreach (ObjectInfo oi in inheritedobjects.Values)
            {
                foreach (VariableInfo vi in oi.GetAllVariable())
                {
                    ret.Add(vi);
                }
            }
            return ret.ToArray();
        }
        /// <summary>
        /// 全ての変数を取得する
        /// </summary>
        /// <param name="accesstype"></param>
        /// <returns></returns>
        public virtual VariableInfo[] GetAllVariable(AccessType accesstype)
        {
            List<VariableInfo> ret = new List<VariableInfo>();
            foreach (VariableInfo vi in variables.Values)
            {
                if (vi.AccessType >= accesstype) ret.Add(vi);
            }
            foreach (ObjectInfo oi in inheritedobjects.Values)
            {
                foreach (VariableInfo vi in oi.GetAllVariable(AccessType.Protected))
                {
                    if (vi.AccessType >= accesstype) ret.Add(vi);
                }
            }
            return ret.ToArray();
        }
        /// <summary>
        /// 全ての定義値を取得する
        /// </summary>
        /// <returns></returns>
        public virtual DefineValueInfo[] GetAllDefineValue()
        {
            return definevalues.Values.ToArray();
        }

        /// <summary>
        /// パース時に特定レベル内をクラス情報とするためのツリークラス
        /// </summary>
        public BasicTree UserObjectTree
        {
            get;
            set;
        }
        /// <summary>
        /// 名前
        /// </summary>
        public virtual string Name
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        /// <summary>
        /// クローン。但し、変数、関数、継承、名前空間を浅くコピーする
        /// </summary>
        /// <returns></returns>
        public ObjectInfo Clone()
        {
            ObjectInfo ret = new ObjectInfo();
            foreach (ObjectInfo oi in inheritedobjects.Values)
            {
                ret.AddInheritedObject(oi, oi.name);
            }
            foreach (FunctionInfo fi in methods.Values)
            {
                ret.AddMethod(fi, fi.Name);
            }
            foreach (VariableInfo vi in variables.Values)
            {
                ret.AddVariable(vi, vi.Name);
            }
            ret.Namespace = Namespace;
            ret.UserObjectTree = UserObjectTree;
            return ret;
        }
        /// <summary>
        /// 補完ウィンドウ表示テキスト(Nameを返す)
        /// </summary>
        public override string Text
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        /// <summary>
        /// ツールチップ表示ヒント(なにもしない)
        /// </summary>
        public override string HintText
        {
            get
            {
                return "";
            }
            set
            {

            }
        }
    }
}
