﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace NotepadNeueExtension
{
    /// <summary>
    /// 変数、関数のツリー管理
    /// </summary>
    public class BasicTree
    {
        SortedList<int, EitherVariableOrTree> data;
        SortedList<int, FunctionInfo> fdata;
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public BasicTree()
        {
            data = new SortedList<int, EitherVariableOrTree>();
            fdata = new SortedList<int, FunctionInfo>();
        }
        /// <summary>
        /// アクセスできる変数情報をインデックスから取得する
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        public VariableInfo[] GetVariableData(int index)
        {
            List<VariableInfo> ret = new List<VariableInfo>();
            if (Start <= index && index <= End)
            {
                foreach (EitherVariableOrTree evot in data.Values)
                {
                    if (evot.VariableInfo == null)
                    {
                        ret.AddRange(evot.BasicTree.GetVariableData(index));
                    }
                    else if (evot.VariableInfo.DefineLocation.DefineIndex < index)
                    {
                        ret.Add(evot.VariableInfo);
                    }
                }
            }
            return ret.ToArray();
        }
        /// <summary>
        /// アクセスできる関数情報をインデックスから取得する
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        public FunctionInfo[] GetFunctionData(int index)
        {
            List<FunctionInfo> ret = new List<FunctionInfo>();
            if (Start <= index && index <= End)
            {
                foreach (EitherVariableOrTree evot in data.Values)
                {
                    if (evot.VariableInfo == null && evot.BasicTree.Start <= index && index <= evot.BasicTree.End)
                    {
                        ret.AddRange(evot.BasicTree.GetFunctionData(index));
                    }
                }
            }
            ret.AddRange(fdata.Values);
            return ret.ToArray();
        }
        /// <summary>
        /// 変数かツリー情報の全て
        /// </summary>
        public EitherVariableOrTree[] VariableOrTrees
        {
            get
            {
                return data.Values.ToArray();
            }
        }
        /// <summary>
        /// 関数全て
        /// </summary>
        public FunctionInfo[] Functions
        {
            get
            {
                return fdata.Values.ToArray();
            }
        }
        /// <summary>
        /// 変数全て
        /// </summary>
        public VariableInfo[] Variables
        {
            get
            {
                return data.Values.Where(e => e.VariableInfo != null).Select(e => e.VariableInfo).ToArray();
            }
        }
        /// <summary>
        /// 子ツリー
        /// </summary>
        public BasicTree[] Trees
        {
            get
            {
                return data.Values.Where(e => e.BasicTree != null).Select(e => e.BasicTree).ToArray();
            }
        }
        /// <summary>
        /// 変数かツリー情報を加える
        /// </summary>
        /// <param name="evot"></param>
        /// <param name="index"></param>
        public void AddData(EitherVariableOrTree evot, int index)
        {
            if (!data.ContainsKey(index))
            {
                if (evot.BasicTree != null)
                {
                    evot.BasicTree.ParentTree = this;
                }
                else
                {
                    evot.VariableInfo.ParentTree = this;
                }
                data.Add(index, evot);
            }
        }
        /// <summary>
        /// 関数情報を加える
        /// </summary>
        /// <param name="finfo"></param>
        /// <param name="index"></param>
        public void AddFunctionData(FunctionInfo finfo, int index)
        {
            if (!fdata.ContainsKey(index))
            {
                finfo.ParentTree = this;
                fdata.Add(index, finfo);
            }
        }
        /// <summary>
        /// どのツリーに入るべきか、インデックスから取得する
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        public BasicTree GetTreeShouldBeIn(int index)
        {
            if (index < Start || End < index) return null;
            foreach (EitherVariableOrTree evot in data.Values)
            {
                if (evot.BasicTree != null)
                {
                    if (evot.BasicTree.Start <= index && index <= evot.BasicTree.End)
                    {
                        return evot.BasicTree.GetTreeShouldBeIn(index);
                    }
                }
            }
            return this;
        }
        /// <summary>
        /// どのツリーに入るべきか、インデックスから取得する
        /// ただし、次のツリー
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        public BasicTree GetTreeShouldBeInNext(int index)
        {
            if (index < this.Start || this.End < index) return null;
            foreach (EitherVariableOrTree evot in data.Values)
            {
                if (evot.BasicTree != null)
                {
                    if (index < evot.BasicTree.Start)
                    {
                        return evot.BasicTree;
                    }
                    else
                    {
                        BasicTree bt = evot.BasicTree.GetTreeShouldBeInNext(index);
                        if (bt != null) return bt;
                    }
                }
            }
            return this;
        }
        /// <summary>
        /// ツリーの開始インデックス
        /// </summary>
        public int Start
        {
            get;
            set;
        }
        /// <summary>
        /// ツリーの終了インデックス
        /// </summary>
        public int End
        {
            get;
            set;
        }
        public BasicTree ParentTree
        {
            get;
            internal set;
        }
    }

}
