﻿using System;
using System.Drawing;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeueExtension
{
    /// <summary>
    /// 補完情報基底クラス
    /// </summary>
    public class AssistInformation
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public AssistInformation()
        {
            Image = NotepadNeueExtension.Properties.Resources.error;
            DefineLocation = new DefineLocation();
        }
        /// <summary>
        /// 補完ウィンドウの右に表示する画像（特に用意しなくていい）
        /// </summary>
        public Image Image
        {
            get;
            set;
        }
        /// <summary>
        /// 補完ウィンドウに表示するテキスト
        /// </summary>
        public virtual string Text
        {
            get;
            set;
        }
        /// <summary>
        /// ツールチップに表示するヒント
        /// </summary>
        public virtual string HintText
        {
            get;
            set;
        }
        /// <summary>
        /// ツールチップに表示するサマリー
        /// </summary>
        public virtual string Summary
        {
            get;
            set;
        }
        /// <summary>
        /// どこで定義されたか(変数、関数などに使用)
        /// </summary>
        public virtual DefineLocation DefineLocation
        {
            get;
            set;
        }
        /// <summary>
        /// Textを返します
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            return Text;
        }
        /// <summary>
        /// 等号演算
        /// </summary>
        /// <param name="info"></param>
        /// <returns></returns>
        public virtual bool Equals(AssistInformation info)
        {
            if (info == null) return false;
            if (Image == info.Image && Text == info.Text && HintText == info.HintText)
            {
                return true;
            }
            return false;
        }
    }

    /// <summary>
    /// 定義された場所
    /// </summary>
    public class DefineLocation
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public DefineLocation()
        {
            DefineIndex = -1;
        }
        /// <summary>
        /// エディタ
        /// </summary>
        public IEditorControl Editor
        {
            get;
            set;
        }
        /// <summary>
        /// 定義されたインデックス
        /// </summary>
        public int DefineIndex
        {
            get;
            set;
        }
    }
    /// <summary>
    /// AssistInformation比較クラス
    /// </summary>
    public class AssistInfomationComparer : System.Collections.IComparer, System.Collections.Generic.IComparer<AssistInformation>
    {
        /// <summary>
        /// 比較関数
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <returns></returns>
        public int Compare(AssistInformation x, AssistInformation y)
        {
            //nullが最も小さいとする
            if (x == null && y == null)
                return 0;
            if (x == null)
                return -1;
            if (y == null)
                return 1;


            StringComparer sc = StringComparer.Create(System.Globalization.CultureInfo.CurrentCulture, false);
            return sc.Compare(x.ToString(), y.ToString());

        }
        /// <summary>
        /// 比較関数
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <returns></returns>
        public int Compare(object x, object y)
        {
            //nullが最も小さいとする
            if (x == null && y == null)
                return 0;
            if (x == null)
                return -1;
            if (y == null)
                return 1;

            //String型以外の比較はエラー
            if (!(x is AssistInformation) || !(y is AssistInformation))
                throw new ArgumentException();
            AssistInfomationComparer aic = new AssistInfomationComparer();

            return aic.Compare((AssistInformation)x, (AssistInformation)y);
        }
    }
}
