﻿# coding : utf-8

import sys
sys.path.insert(0,"./plugin/tex/Lib")

import clr
clr.AddReference("System.Windows.Forms")
clr.AddReference("System.Drawing")
clr.AddReference("System")
from System.Windows.Forms import *
from System.Drawing import Image
from System.Drawing import Color
from System import DateTime

import urllib, urllib2, re

def encodeURIComponent(str):
    def replace(match):
        val = hex(ord(match.group()))[2:].upper()
        return "%" + ("0" + val if len(val) == 1 else val)
    return re.sub(r"([^0-9A-Za-z!'()*\-._~])", replace, str.encode('utf-8'))

def download(content):
    content = content.replace('\r\n','\r').replace('\r','\n')
    url = "http://maru.bonyari.jp/texclip/render.php/texclip" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".png?s=" + encodeURIComponent(content) + "&f=c&r=150&m=p&b=f&k=f"
    
    try:
        proxy = {}
        proxy_handler = urllib2.ProxyHandler(proxy)
        opener = urllib2.build_opener(proxy_handler)
        urllib2.install_opener(opener)
        handle = urllib2.urlopen(url,timeout=1.5)
    except:
        proxy = {'http':'http://proxy.kuins.net:8080/'}
        proxy_handler = urllib2.ProxyHandler(proxy)
        opener = urllib2.build_opener(proxy_handler)
        urllib2.install_opener(opener)
        handle = urllib2.urlopen(url,timeout=1.5)
    f = open("texText.png","wb")
    f.write(handle.read())
    f.close()
    handle.close()
    
    form = Form()
    def keyDown(sender ,e):
        form.Close()
    form.KeyDown += keyDown
    form.FormBorderStyle = FormBorderStyle.None
    pb = PictureBox()
    pb.Image = Image.FromFile("texText.png")
    pb.Size = pb.Image.Size
    form.Size = pb.Size
    form.Controls.Add(pb)
    form.StartPosition = FormStartPosition.CenterParent
    def closed(sender,e):
        pb.Image.Dispose()
    form.FormClosed += closed
    form.ShowDialog()

reg1 = re.compile(r'\\begin\{([^{}]+)\}')
reg2 = re.compile(r'\\end\{([^{}]+)\}')
line, column = editor.GetLineColumnIndexFromCharIndex(editor.CaretIndex)
startLine = endLine = -1
startContent = ""
while line >= 0:
    lineContent = editor.Document.GetLineContent(line)
    match1 = reg1.match(lineContent)
    match2 = reg2.match(lineContent)
    if match1 is not None:
        startLine = line
        startContent = match1.group(1)
        break
    elif match2 is not None:
        break
    line -= 1

line += 1
if startLine >= 0:
    while line < editor.Document.LineCount:
        lineContent = editor.Document.GetLineContent(line)
        match1 = reg1.match(lineContent)
        match2 = reg2.match(lineContent)
        if match2 is not None:
            if startContent == match2.group(1):
                endLine = line
            break
        elif match1 is not None:
            break
        line += 1
        
if startLine >= 0 and endLine >= 0:
    startIndex = editor.Document.GetLineHeadIndex(startLine)
    endIndex = editor.Document.GetLineHeadIndex(endLine) + editor.Document.GetLineLength(endLine)
    text = editor.Document.GetTextInRange(startIndex,endIndex)
    download(text)
else:
    MessageBox.Show("No eqnarray")