﻿# coding : utf-8


import clr
clr.AddReference("System.Windows.Forms")
clr.AddReference("System.Drawing")

from System.Windows.Forms import *
from System.Drawing import *

def Keypress(sender,e):
   if e.KeyChar == '\r':
      e.Handled = True
      PressedOK(sender,e)


def PressedCancel(sender,e):
   fm = sender.FindForm()
   fm.Close()

def PressedOK(sender,e):
   fm = sender.FindForm()
   tb = fm.Controls[0]
   st = tb.Text
   try:
      num = int(st)
      st = u"\\multicolumn{"+st+u"}{c}{\\dotfill} "
      begin,end = editor.Document.GetSelection()
      editor.Document.Replace(st,begin,end)
      fm.Close()
   except ValueError:
      MessageBox.Show(u"テキストボックスの入力が数値ではありません")

fm = Form()
fm.MaximizeBox = False
fm.MinimizeBox = False
fm.FormBorderStyle = FormBorderStyle.FixedDialog
fm.ShowInTaskbar = False
fm.ShowIcon = False
fm.Text = u"点で埋める列数"
fm.Size = Size(200,150)
okbut = Button()
okbut.Location = Point(95-okbut.Width,80)
okbut.Text = u"OK"
okbut.Click += PressedOK
cancelbut = Button()
cancelbut.Location = Point(105,80)
cancelbut.Text = u"Cancel"
cancelbut.Click += PressedCancel
lab = Label()
lab.AutoSize = True
lab.Text = u"何個の列を埋めますか？"
lab.Location = Point(10,10)
tb = TextBox()
tb.Location = Point(10,30)
tb.Width = 170
tb.KeyPress += Keypress
fm.Controls.Add(tb)
fm.Controls.Add(okbut)
fm.Controls.Add(cancelbut)
fm.Controls.Add(lab)
fm.StartPosition = FormStartPosition.CenterScreen
fm.ShowDialog()
