﻿<?xml version="1.0" encoding="utf-8"?>
<root>
   <definevalue name="MB_CUR_MAX" value="">
      <summary text="設定されているロケールにおけるマルチバイト文字の最大バイト数を表すマクロ"/>
   </definevalue>
	<function name="malloc" type="void*" content="void *malloc(size_t n)">
	   <summary text="メモリを動的に確保します。確保したメモリのアドレス、確保できなかった場合はNULLを返します。使用後はfree()で解放してください。"/>
	   <argument text="確保するメモリサイズ。sizeof()で型のサイズを測れます。"/>
	</function>
	<function name="calloc" type="void*" content="void *calloc(size_t int nelem, size_t elsize)">
	   <summary text="メモリを動的に確保します。確保したメモリはゼロクリアされます。確保したメモリのアドレス、確保できなかった場合はNULLを返します。"/>
	   <argument text="要素数"/>
	   <argument text="1要素のサイズ。sizeof()で型のサイズを測れます。"/>
	</function>
	<function name="realloc" type="void*" content="void *realloc(void *ptr, size_t size)">
	   <summary text="確保したメモリサイズを変更します。中身は維持されます。確保したメモリのアドレス、確保できなかった場合はNULLを返します。"/>
	   <argument text="確保したメモリのアドレス"/>
	   <argument text="新しいメモリサイズ。sizeof()で型のサイズを測れます。"/>
	</function>
	<function name="free" type="void" content="void free(void *p)">
	   <summary text="動的に確保したメモリを解放します。"/>
	   <argument text="確保したメモリのアドレス"/>
	</function>
	<function name="abs" type="int" content="int abs(int n)">
	   <summary text="int型の絶対値を求めます。数値の絶対値を返します。"/>
	   <argument text="数値"/>
	</function>
	<function name="labs" type="long" content="long labs(long n)">
	   <summary text="long型の絶対値を求めます。数値の絶対値を返します。"/>
	   <argument text="数値"/>
	</function>
	<function name="atof" type="double" content="double atof(const char *s)">
	   <summary text="数字を含む文字列を実数値に変換します。変換後の値、変換できない場合は0を返します。"/>
	   <argument text="数字を含む文字列"/>
	</function>
	<function name="atoi" type="int" content="int atoi(const char *s)">
	   <summary text="数字を含む文字列を整数値に変換します。変換後の値、変換できない場合は0を返します。"/>
	   <argument text=""/>
	</function>
	<function name="atol" type="long" content="long atol(const char *s)">
	   <summary text="数字を含む文字列を整数値に変換します。変換後の値、変換できない場合は0を返します。"/>
	   <argument text="数字を含む文字列"/>
	</function>
	<function name="strtod" type="double" content="double strtod(const char *s, char **endptr)">
	   <summary text="数字を含む文字列を実数値に変換します。変換後の値、変換できない場合は0を返します。"/>
	   <argument text="数字を含む文字列"/>
	   <argument text="終了位置のアドレス"/>
	</function>
	<function name="strtol" type="long" content="long strtol(const char *s, char **endptr, int base)">
	   <summary text="数字を含む文字列を整数値に変換します。変換後の値。変換できない場合は0を返します。"/>
	   <argument text="数字を含む文字列"/>
	   <argument text="終了位置のアドレス"/>
	   <argument text="数値の基数(2進数や16進数)"/>
	</function>
	<function name="strtoul" type="unsigned long" content="unsigned long strtoul(const char *s, char **endptr, int base)">
	   <summary text="数字を含む文字列を符号無し整数値に変換します。変換後の値、変換できない場合は0を返します。"/>
	   <argument text="数字を含む文字列"/>
	   <argument text="終了位置のアドレス"/>
	   <argument text="数値の基数(2進数や16進数)"/>
	</function>
	<function name="div" type="div_t" content="div_t div(int num, int denom)">
	   <summary text="商と余りを同時に計算します。割り算の結果をdiv_t構造体で返します。"/>
	   <argument text="割られる数"/>
	   <argument text="割る数"/>
	</function>
	<object name="div_t">
	   <summary text="割り算の結果の商、余りを保持します"/>
	   <variable name="quat" type="int">
	      <summary text="商"/>
	   </variable>
	   <variable name="rem" type="int">
	      <summary text="余り"/>
	   </variable>
	</object>
	<function name="ldiv" type="ldiv_t" content="ldiv_t ldiv(long num, long denom)">
	   <summary text="商と余りを同時に計算します。割り算の結果をldiv_t構造体で返します。"/>
	   <argument text="割られる数"/>
	   <argument text="割る数"/>
	</function>
	<object name="ldiv_t">
	   <summary text="割り算の結果の商、余りを保持します"/>
	   <variable name="quat" type="long">
	      <summary text="商"/>
	   </variable>
	   <variable name="rem" type="long">
	      <summary text="余り"/>
	   </variable>
	</object>
	<function name="rand" type="int" content="int rand()">
	   <summary text="乱数を得ます。最大値はRAND_MAXで取得出来ます。"/>
	   <argument text=""/>
	</function>
	<definevalue name="RAND_MAX" value="">
	   <summary text="rand()を使って得られる最大値です。"/>
	</definevalue>
	<function name="srand" type="void" content="void srand(unsigned int seed)">
	   <summary text="乱数系列の初期値を与えます。srand((unsigned int)time(0));で実行毎に違う乱数が生成されるようになります。"/>
	   <argument text="乱数系列の初期値"/>
	</function>
	<function name="exit" type="void" content="void exit(int n)">
	   <summary text=" プログラムを終了させます。"/>
	   <argument text="終了コード。一般に EXIT_SUCCESS は正常終了、EXIT_FAILURE は異常終了。"/>
	</function>
	<definevalue name="EXIT_SUCCESS" value="">
	   <summary text="正常に終了したことを表す定義値です。"/>
	</definevalue>
	<definevalue name="EXIT_FAILURE" value="">
	   <summary text="異常終了したことを表す定義値です。"/>
	</definevalue>
	<function name="abort" type="void" content="void abort()">
	   <summary text="エラーが発生したときの終了に使用します。"/>
	</function>
	<function name="atexit" type="int" content="int atexit(void (*func)(void))">
	   <summary text="プログラム終了時に実行する関数を登録します。成功した場合は0、失敗した場合は0以外を返します。"/>
	   <argument text="関数のアドレス"/>
	</function>
	<function name="getenv" type="char*" content="char *getenv(const char *name)">
	   <summary text="環境変数を取得します。値を格納した文字列の先頭アドレス、見つからない場合はNULLを返します。"/>
	   <argument text="名前"/>
	</function>
	<function name="bsearch" type="void*" content="void *bsearch(const void *key, const void *base, size_t nmemb,size_t size, int (*compar)(const void *x, const void *y))">
	   <summary text="2分探索を行います。データは昇順に整列されていなけけばなりません。比較関数は、x &gt; yの場合は正、x = yの場合は0、x &lt; yの場合は負を返すようにしてください。見つかった要素のアドレス、見つからない場合はNULLを返します。"/>
	   <argument text="探す値"/>
	   <argument text="配列の先頭"/>
	   <argument text="探索数"/>
	   <argument text="1要素のサイズ"/>
	   <argument text="比較関数のアドレス"/>
	</function>
	<function name="qsort" type="void" content="void qsort(void *base, size_t nel, size_t width, int(*compar)(const void *x, const void *y))">
	   <summary text="配列を昇順に整列します。比較関数は、x &gt; yの場合は正、x = yの場合は0、x &lt; yの場合は負を返すようにしてください。"/>
	   <argument text="配列の先頭"/>
	   <argument text="整列個数"/>
	   <argument text="1要素のサイズ"/>
	   <argument text="比較関数のアドレス"/>
	</function>
	<function name="system" type="int" content="int system(const char *string)">
	   <summary text="処理系が用意しているコマンドを実行します。処理系のコマンド依存、コマンドを実行できなかった場合は-1を返します。"/>
	   <argument text="コマンド文字列"/>
	</function>
</root>