﻿using System;
using System.Collections.Generic;
using System.Text;
using SlimDX;
using SlimDX.Direct3D9;

namespace testgame
{
    class NormalDxString : IDisposable
    {
        float x;
        float y;
        float z;

        float maxwidth;
        bool allowscroll = false;
        bool scrollmode = false;
        int scrollcount = 0;
        const int scrollspeed = 5;
        int speedcount = 0;
        int wait = 600;
        bool disposed;
        Color4 color;
        int height;
        string text;
        Font font;

        Device device;
        Sprite sprite;

        public NormalDxString(string text, float x, float y, float z, int height, int width, FontWeight weight, string facename, Color4 color, Device device, Sprite sprite)
        {
            this.x = x;
            this.y = y;
            this.z = z;
            this.text = text;
            this.height = height;
            this.color = color;
            this.device = device;
            this.sprite = sprite;
            font = new Font(device, height, width, weight, 0, false, CharacterSet.ShiftJIS, Precision.Default, FontQuality.ClearTypeNatural, PitchAndFamily.Default, facename);
            this.maxwidth = this.width;
        }
        public NormalDxString(string text, float x, float y, float z, int height, int width, int maxwidth, FontWeight weight, string facename, Color4 color, Device device, Sprite sprite)
        {
            this.x = x;
            this.y = y;
            this.z = z;
            this.text = text;
            this.height = height;
            this.color = color;
            this.device = device;
            this.sprite = sprite;
            this.maxwidth = maxwidth;
            scrollmode = true;
            font = new Font(device, height, width, weight, 0, false, CharacterSet.ShiftJIS, Precision.Default, FontQuality.ClearTypeNatural, PitchAndFamily.Default, facename);
            if (this.width > maxwidth)
            {
                allowscroll = true;
            }
        }
        public virtual void Update()
        {


        }
        public virtual void Draw()
        {
            if (scrollmode && width > maxwidth)
            {
                if (allowscroll)
                {
                    if (wait > 600)
                    {
                        font.DrawString(this.sprite, this.text.Substring(scrollcount), new System.Drawing.Rectangle((int)this.x, (int)this.y, (int)this.maxwidth, this.height), DrawTextFormat.Left, this.color);
                    }
                    else
                    {
                        font.DrawString(this.sprite, this.text, new System.Drawing.Rectangle((int)this.x, (int)this.y, (int)(this.maxwidth - this.height * 3 / 2) * 2, this.height * 2), DrawTextFormat.Left, this.color);
                        font.DrawString(this.sprite, "...", new System.Drawing.Rectangle((int)this.x + (int)(this.maxwidth - this.height * 3 / 2) * 2, (int)this.y, (int)this.maxwidth * 2, this.height * 2), DrawTextFormat.Left, this.color);
                    }
                }
                else
                {
                    font.DrawString(this.sprite, this.text, new System.Drawing.Rectangle((int)this.x, (int)this.y, (int)(this.maxwidth - this.height * 3 / 2) * 2, this.height * 2), DrawTextFormat.Left, this.color);
                    font.DrawString(this.sprite, "...", new System.Drawing.Rectangle((int)this.x + (int)(this.maxwidth - this.height * 3 / 2) * 2, (int)this.y, (int)this.maxwidth * 2, this.height * 2), DrawTextFormat.Left, this.color);
                }
                if (allowscroll)
                {
                    wait++;
                    if (wait >= 600)
                    {
                        speedcount++;
                        if (speedcount > scrollspeed)
                        {
                            speedcount = 0;
                            scrollcount++;
                        }
                        if (scrollcount >= this.text.Length)
                        {
                            scrollcount = 0;
                            wait = 0;
                        }
                    }
                }
            }
            else
            {
                if (border != null)
                {
                    font.DrawString(this.sprite, this.text, (int)(this.x - border.thickness), (int)this.y, border.color);
                    font.DrawString(this.sprite, this.text, (int)(this.x + border.thickness), (int)this.y, border.color);
                    font.DrawString(this.sprite, this.text, (int)this.x, (int)(this.y - border.thickness), border.color);
                    font.DrawString(this.sprite, this.text, (int)this.x, (int)(this.y + border.thickness), border.color);
                }
                font.DrawString(this.sprite, this.text, (int)this.x, (int)this.y, this.color);
            }
        }
        public float alpha
        {
            get
            {
                return this.color.Alpha;
            }
            set
            {
                this.color.Alpha = value;
            }
        }
        public string Text
        {
            get
            {
                return text;
            }
            set
            {
                text = value;
                if (scrollmode)
                {
                    if (this.width > this.maxwidth)
                    {
                        allowscroll = true;
                    }
                }
            }
        }
        public bool AllowScroll
        {
            get
            {
                return allowscroll;
            }
            set
            {
                allowscroll = value;
                scrollcount = 0;
                wait = 600;
            }
        }
        public Vector2 position
        {
            get
            {
                return new Vector2(this.x, this.y);
            }
            set
            {
                this.x = value.X;
                this.y = value.Y;
            }
        }
        public int MeasureWidth(String st)
        {
            DrawTextFormat dtf = DrawTextFormat.SingleLine;
            return font.MeasureString(sprite, st, dtf).Width + countlastspace(st) * SpaceWidth();
        }
        public int MeasureWidthWithoutLastSpace(String st)
        {
            DrawTextFormat dtf = DrawTextFormat.SingleLine;
            return font.MeasureString(sprite, st, dtf).Width;
        }
        private int SpaceWidth()
        {
            int big = MeasureWidthWithoutLastSpace(" s");
            int small = MeasureWidthWithoutLastSpace("s");
            return big - small;
        }
        private int countlastspace(String st)
        {
            int before = st.Length;
            while (true)
            {
                if (st.EndsWith(" "))
                {
                    st = st.Substring(0,st.Length - 1);
                }
                else
                {
                    break;
                }
                if (st == "")
                {
                    break;
                }
            }
            int after = st.Length;
            return before - after;
        }
        public int width
        {
            get
            {
                DrawTextFormat dtf = DrawTextFormat.SingleLine;
                return font.MeasureString(sprite, text, dtf).Width;
            }
        }
        public int justwidth
        {
            get
            {
                DrawTextFormat dtf = DrawTextFormat.SingleLine;
                int w = font.MeasureString(sprite, text, dtf).Width;
                if (allowscroll)
                {
                    return w > maxwidth ? (int)maxwidth : width;
                }
                return w;
            }
        }
        public Border border
        {
            get;
            set;
        }
        public Color4 Color
        {
            get
            {
                return color;
            }
            set
            {
                color = value;
            }
        }
        public void changefont(int height, int width, FontWeight weight, string facename, Color4 color)
        {
            Font old = font;
            font = new Font(device, height, width, weight, 0, false, CharacterSet.ShiftJIS, Precision.Default, FontQuality.ClearTypeNatural, PitchAndFamily.Default, facename);
            old.Dispose();
        }
        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }
        private void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    font.Dispose();
                }
            }
            disposed = true;
        }
    }
}
