﻿using System;
using System.Drawing;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using SlimDX;
using SlimDX.Direct3D9;
using System.Windows.Forms;
using DirectShowLib;
using System.Runtime.InteropServices;
using System.Threading;
using System.Runtime.InteropServices.ComTypes;


namespace testgame
{
    class Movie : IDisposable
    {

        protected int left = 0;
        protected int right = 0;
        protected int top = 0;
        protected int bottom = 0;

        public event EventHandler Finished;
        public event EventHandler fadeoutfinish;


        protected const int fadestep = 2;
        protected enum State
        {
            fadein = 0,
            fadeout = 1,
            nothing = 2
        }

        protected object syncobject = new object();

        protected double length;
        public bool initialized = false;

        protected State state = State.nothing;

        protected float x;
        protected float y;
        protected float z;
        protected float a = 1.0f;
        protected float scale = 1.0f;

        protected int width;
        protected int height;
        protected Device device;
        protected Sprite sprite;
        protected Utility util;
        bool disposed = false;
        protected bool displaymovie = true;

        public int displaywidth = 800;
        public int displayheight = 450;
        public bool fixaspect = false;

        public Device Device
        {
            get
            {
                return device;
            }
            set
            {
                device = value;
            }
        }

        protected const int VolumeFull = -1000;
        protected const int VolumeSilence = -10000;

#if DEBUG
        private DsROTEntry rot = null;
#endif
        private IGraphBuilder graphBuilder2 = null;
        //private IFilterGraph2 graphBuilder2 = null;
        private IBaseFilter vmr9 = null;
        private IBaseFilter nullrenderer;
        private IMediaControl mediaControl = null;
        private IBasicAudio basicAudio = null;
        private IBasicVideo basicVideo = null;
        private IMediaEventEx mediaeventEx = null;
        protected IMediaPosition mediaPosition = null;
        //private IVideoFrameStep frameStep = null;
        protected Allocator9 allocator = null;
        public string filename = string.Empty;
        protected float maxu;
        protected float maxv;
        private IntPtr hDrain = IntPtr.Zero;
        private IntPtr userID = new IntPtr(unchecked((int)0xACDCACDC));
        // Application-defined message to notify app of filtergraph events
        //public const int WM_GRAPHNOTIFY = 0x8000 + 1;
        private const int WM_GRAPHNOTIFY = 0x0400 + 13;
        public Movie(string filename, float x, float y, float z, Device device, Sprite sprite, Utility util)
        {
            this.x = x;
            this.y = y;
            this.z = z;
            this.filename = filename;
            this.device = device;
            this.sprite = sprite;
            this.util = util;
            util.GraphNotify += new EventHandler(util_GraphNotify);
        }

        public int initialize()
        {
            //directshowtest
            //サンプルグラバーを接続するフォーマットを指定
            string filename1 = this.filename;
            try
            {
                int hr = 0;

                if (displaymovie)
                {

                    //this.graphBuilder2 = (IGraphBuilder)new FilterGraph();
                    this.graphBuilder2 = (IFilterGraph2)new FilterGraph();
                    vmr9 = (IBaseFilter)new VideoMixingRenderer9();
                    IVMRFilterConfig9 config = vmr9 as IVMRFilterConfig9;
                    hr = config.SetRenderingMode(VMR9Mode.Renderless);
                    DsError.ThrowExceptionForHR(hr);
                    hr = config.SetNumberOfStreams(1);
                    DsError.ThrowExceptionForHR(hr);
                    allocator = new Allocator9(device, util.d3d);
                    IVMRSurfaceAllocatorNotify9 vmrSurfAllocNotify = (IVMRSurfaceAllocatorNotify9)vmr9;
                    hr = vmrSurfAllocNotify.AdviseSurfaceAllocator(userID, allocator);
                    DsError.ThrowExceptionForHR(hr);
                    hr = allocator.AdviseNotify(vmrSurfAllocNotify);
                    DsError.ThrowExceptionForHR(hr);
                    IVMRMixerControl9 mixerControl = (IVMRMixerControl9)vmr9;
                    hr = mixerControl.SetMixingPrefs(VMR9MixerPrefs.RenderTargetYUV | VMR9MixerPrefs.NoDecimation | VMR9MixerPrefs.ARAdjustXorY | VMR9MixerPrefs.BiLinearFiltering);
                    DsError.ThrowExceptionForHR(hr);
                    try
                    {
                        hr = graphBuilder2.AddFilter(vmr9, "Video Mixing Renderer 9");
                    }
                    catch (Exception eee)
                    {
                        MessageBox.Show("致命的なえらーなのでし");
                        Exception e = new Exception();
                        throw e;
                    }
                    DsError.ThrowExceptionForHR(hr);
                    hr = this.graphBuilder2.RenderFile(filename1, null);
                    DsError.ThrowExceptionForHR(hr);
                    // QueryInterface for DirectShow interfaces
                    this.mediaControl = (IMediaControl)this.graphBuilder2;
                    this.mediaPosition = (IMediaPosition)this.graphBuilder2;


                    // Query for video interfaces, which may not be relevant for audio files
                    this.basicVideo = this.graphBuilder2 as IBasicVideo;
                    // Query for audio interfaces, which may not be relevant for video-only files
                    this.basicAudio = this.graphBuilder2 as IBasicAudio;
                    this.mediaeventEx = this.graphBuilder2 as IMediaEventEx;
                }
                else
                {
                    graphBuilder2 = new FilterGraph() as IFilterGraph2;
                    nullrenderer = (IBaseFilter)new NullRenderer();
                    hr = this.graphBuilder2.RenderFile(filename1, null);
                    DsError.ThrowExceptionForHR(hr);
                    IBaseFilter videorenderer = null;
                    hr = graphBuilder2.FindFilterByName("Video Renderer", out videorenderer);
                    DsError.ThrowExceptionForHR(hr);
                    IPin pin = null;
                    hr = videorenderer.FindPin("VMR Input0", out pin);
                    DsError.ThrowExceptionForHR(hr);
                    IPin wantpin = null;
                    hr = pin.ConnectedTo(out wantpin);
                    DsError.ThrowExceptionForHR(hr);
                    hr = pin.Disconnect();
                    DsError.ThrowExceptionForHR(hr);
                    hr = graphBuilder2.RemoveFilter(videorenderer);
                    DsError.ThrowExceptionForHR(hr);
                    hr = graphBuilder2.AddFilter(nullrenderer, "Null Renderer");
                    DsError.ThrowExceptionForHR(hr);
                    hr = nullrenderer.FindPin("In", out pin);
                    DsError.ThrowExceptionForHR(hr);
                    hr = graphBuilder2.Connect(wantpin, pin);
                    DsError.ThrowExceptionForHR(hr);
                    // QueryInterface for DirectShow interfaces
                    this.mediaControl = (IMediaControl)this.graphBuilder2;
                    this.mediaPosition = (IMediaPosition)this.graphBuilder2;
                    // Query for video interfaces, which may not be relevant for audio files
                    this.basicVideo = this.graphBuilder2 as IBasicVideo;
                    // Query for audio interfaces, which may not be relevant for video-only files
                    this.basicAudio = this.graphBuilder2 as IBasicAudio;
                    this.mediaeventEx = this.graphBuilder2 as IMediaEventEx;
                }
                if (mediaControl == null)
                {
                    Exception exp = new Exception("Failed to get mediacontrol");
                    throw exp;
                }
                if (mediaPosition == null)
                {
                    Exception exp = new Exception("Failed to get mediaposition");
                    throw exp;
                }
                if (basicVideo == null)
                {
                    Exception exp = new Exception("Failed to get basicvideo");
                    throw exp;
                }
                if (basicAudio == null)
                {
                    Exception exp = new Exception("Failed to get basicaudio");
                    throw exp;
                }
                if (mediaeventEx == null)
                {
                    Exception exp = new Exception("Failed to get mediaeventEx");
                    throw exp;
                }
                //グラフを解析してプリント
                IEnumFilters fils = null;
                hr = this.graphBuilder2.EnumFilters(out fils);
                IBaseFilter[] fil = new IBaseFilter[1];
                IntPtr ptr = IntPtr.Zero;
                StreamWriter sw = new StreamWriter("filterinfo.log");
                try
                {
                    while (true)
                    {
                        hr = fils.Next(1, fil, ptr);
                        DsError.ThrowExceptionForHR(hr);
                        FilterInfo fi;
                        hr = fil[0].QueryFilterInfo(out fi);
                        try
                        {
                            DsError.ThrowExceptionForHR(hr);
                        }
                        catch
                        {
                            //next works fine 
                            continue;
                        }
                        sw.WriteLine(fi.achName);
                    }
                }
                catch
                {

                }
                finally
                {
                    sw.Close();
                }
                if (allocator != null)
                {
                    this.width = allocator.VideoSize.Width;
                    this.height = allocator.VideoSize.Height;
                    this.maxu = (float)allocator.VideoSize.Width / allocator.TextureSize.Width;
                    this.maxv = (float)allocator.VideoSize.Height / allocator.TextureSize.Height;
                }
                hr = this.mediaPosition.get_Duration(out this.length);
                DsError.ThrowExceptionForHR(hr);
                state = State.nothing;
                setvolume(VolumeFull);
                hr = mediaeventEx.SetNotifyWindow(util.Window, WM_GRAPHNOTIFY, IntPtr.Zero);
                DsError.ThrowExceptionForHR(hr);
                this.initialized = true;
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
                return -1;
            }
            return 0;
        }
        public void Seek(double time)
        {
            if (time <= this.length && time >= 0)
            {
                int hr = this.mediaPosition.put_CurrentPosition(time);
                DsError.ThrowExceptionForHR(hr);
            }
        }
        public double GetTime()
        {
            double ret = 0;
            int hr = this.mediaPosition.get_CurrentPosition(out ret);
            DsError.ThrowExceptionForHR(hr);
            return ret;
        }
        public void Play()
        {
            int hr = this.mediaControl.Run();
            DsError.ThrowExceptionForHR(hr);
        }

        public void Stop()
        {
            if (!initialized) return;
            //int hr = this.mediaControl.Stop();
            int hr = this.mediaControl.StopWhenReady();
            DsError.ThrowExceptionForHR(hr);
        }

        public void Pause()
        {
            if (!initialized) return;
            //int hr = this.mediaControl.Pause();
            int hr = this.mediaControl.StopWhenReady();
            DsError.ThrowExceptionForHR(hr);
        }
        public void fadein()
        {
            if (!initialized) return;
            this.a = 0;
            int hr = this.basicAudio.put_Volume(VolumeSilence);
            DsError.ThrowExceptionForHR(hr);
            state = State.fadein;
        }
        public void fadeout()
        {
            if (!initialized) return;
            //this.a = 1.0f;
            //this.basicAudio.put_Volume(VolumeFull);
            state = State.fadeout;
        }
        public void setvolume(int num)
        {
            if (this.basicAudio != null)
            {
                int hr = this.basicAudio.put_Volume(num);
                DsError.ThrowExceptionForHR(hr);
            }
        }
        public void makevisible()
        {
            this.a = 1;
            int hr = this.basicAudio.put_Volume(VolumeFull);
            DsError.ThrowExceptionForHR(hr);
            state = State.nothing;
        }
        protected void getpic()
        {
            /*int size = 0;
            sampGrabber.GetCurrentBuffer(ref size, IntPtr.Zero);
            IntPtr src = Marshal.AllocCoTaskMem(size);
            sampGrabber.GetCurrentBuffer(ref size, src);
            if (src != null)
            {
                int start = System.Environment.TickCount;
                DataRectangle rec = sampTexture.LockRectangle(0, new Rectangle(0, 0, this.width, this.height), LockFlags.Discard);
                rec.Data.WriteRange(src, size);
                sampTexture.UnlockRectangle(0);
                int end = System.Environment.TickCount;
                Console.WriteLine("time is " + (end - start));*/

            //}
            //Marshal.FreeCoTaskMem(src);

        }

        public virtual void anotherDraw()
        {
            if (!initialized) return;
            checkstate();



            if (allocator != null && allocator.createdtexture)
            {
                float x = 0;
                float y = 0;
                float z = 0.5f;
                float w = 1.0f;

                // 画像サイズ；大きいので半分に縮小表示する
                float width = displaywidth;
                float height = displayheight;

                if (fixaspect)
                {
                    float originalratio = (float)this.width / this.height;
                    float demandratio = (float)displaywidth / displayheight;
                    if (originalratio > demandratio)
                    {
                        width = displaywidth;
                        height = width / this.width * this.height;
                        y = (displayheight - height) / 2;
                    }
                    else
                    {
                        height = displayheight;
                        width = height / this.height * this.width;
                        x = (displaywidth - width) / 2;
                    }
                }

                // 頂点の色；テクスチャを貼るポリゴンは白色にしておく
                int color = new Color4(1.0f, 1.0f, 1.0f, 1.0f).ToArgb();

                var cv頂点データ = new TransformedColoredTexturedVertex[4]{
        // 左上の頂点
        new TransformedColoredTexturedVertex()
        {
          Position = new Vector4( x, y, z, w ),
          Color = color,
          TextureCoordinates = new Vector2() { X = (float)left/this.width*maxu, Y = (float)top/this.height*maxv  },
        },
        // 右上の頂点
        new TransformedColoredTexturedVertex()
        {
          Position = new Vector4( x + width, y, z, w ),
          Color = color,
          TextureCoordinates = new Vector2() { X = (1.0f-(float)right/this.width)*maxu, Y = (float)top/this.height*maxv },
        },
        // 左下の頂点
        new TransformedColoredTexturedVertex()
        {
          Position = new Vector4( x, y + height, z, w ),
          Color = color,
          TextureCoordinates = new Vector2() { X = (float)left/this.width*maxu, Y = (1.0f-(float)bottom/this.height)*maxv },
        },
        // 右下の頂点
        new TransformedColoredTexturedVertex()
        {
          Position = new Vector4( x + width, y + height, z, w ),
          Color = color,
          TextureCoordinates = new Vector2() { X = (1.0f-(float)right/this.width)*maxu, Y = (1.0f-(float)bottom/this.height)*maxv },
        }
                };
                // テクスチャを貼った2枚の三角ポリゴンを表示
                this.device.SetTexture(0, allocator.Texture);
                this.device.VertexFormat = TransformedColoredTexturedVertex.Format;
                this.device.DrawUserPrimitives(PrimitiveType.TriangleStrip, 0, 2, cv頂点データ);
            }

            //checkfinish();
        }


        protected void checkfinish()
        {
            double check = 0;
            int hr = this.mediaPosition.get_CurrentPosition(out check);
            DsError.ThrowExceptionForHR(hr);
            if (this.length <= check)
            {
                if (this.Finished != null)
                {
                    this.Finished(this, new EventArgs());
                }
            }
        }
        public virtual void setsetting(int a, int b, int c, int d)
        {
            left = a;
            right = b;
            top = c;
            bottom = d;
        }
        protected void checkstate()
        {
            switch (state)
            {
                case State.fadein:
                    bool check1 = false, check2 = false;
                    this.a += fadestep / 100f;
                    if (this.a >= 1.0f)
                    {
                        this.a = 1.0f;
                        check1 = true;
                    }
                    int vo = 0;
                    int hr = this.basicAudio.get_Volume(out vo);
                    DsError.ThrowExceptionForHR(hr);
                    vo += fadestep * 100;
                    if (vo <= VolumeFull)
                    {
                        hr = this.basicAudio.put_Volume(vo);
                        DsError.ThrowExceptionForHR(hr);
                    }
                    else
                    {
                        hr = this.basicAudio.put_Volume(VolumeFull);
                        DsError.ThrowExceptionForHR(hr);
                        check2 = true;
                    }
                    if (check1 && check2)
                    {
                        state = State.nothing;

                    }
                    break;
                case State.fadeout:
                    check1 = false; check2 = false;
                    a -= fadestep / 100f;
                    if (this.a <= 0.0f)
                    {
                        this.a = 0.0f;
                        check1 = true;
                    }
                    vo = 0;
                    hr = this.basicAudio.get_Volume(out vo);
                    DsError.ThrowExceptionForHR(hr);
                    vo -= fadestep * 100;
                    if (vo >= VolumeSilence)
                    {
                        hr = this.basicAudio.put_Volume(vo);
                        DsError.ThrowExceptionForHR(hr);
                    }
                    else
                    {
                        hr = this.basicAudio.put_Volume(VolumeSilence);
                        DsError.ThrowExceptionForHR(hr);
                        check2 = true;
                    }
                    if (check1 && check2)
                    {
                        state = State.nothing;
                        if (this.fadeoutfinish != null)
                        {
                            this.fadeoutfinish(this, new EventArgs());
                        }
                    }
                    break;

                case State.nothing:
                    break;
            }
        }
        void util_GraphNotify(object sender, EventArgs e)
        {
            OnGraphNotify();
        }

        void OnGraphNotify()
        {
            if (mediaeventEx == null) return;
            EventCode code;
            IntPtr p1 = IntPtr.Zero, p2 = IntPtr.Zero;
            int hr = 0;
            do
            {
                hr = mediaeventEx.GetEvent(out code, out p1, out p2, 0);
                if (hr < 0)
                    break;
                hr = mediaeventEx.FreeEventParams(code, p1, p2);
                switch (code)
                {
                    case EventCode.Complete:
                        if (this.Finished != null)
                        {
                            this.Finished(this, new EventArgs());
                        }
                        break;
                }
            }
            while (hr == 0);
        }
        public void releaseCOM()
        {
            if (!initialized) return;
            int hr = 0;
            // Stop previewing data
            if (this.mediaControl != null)
            {
                hr = this.mediaControl.Stop();
                DsError.ThrowExceptionForHR(hr);
                FilterState state;
                hr = mediaControl.GetState(0, out state);
                DsError.ThrowExceptionForHR(hr);
                while (state != FilterState.Stopped)
                {
                    System.Threading.Thread.Sleep(10);
                }
            }
            // Relinquish ownership (IMPORTANT!) of the video window.
            // Failing to call put_Owner can lead to assert failures within
            // the video renderer, as it still assumes that it has a valid
            // parent window.
            if (mediaeventEx != null)
            {
                mediaeventEx.SetNotifyWindow(IntPtr.Zero, WM_GRAPHNOTIFY, IntPtr.Zero);
                mediaeventEx = null;
            }

            // Remove filter graph from the running object table
#if DEBUG
            if (rot != null)
            {
                rot.Dispose();
                rot = null;
            }
#endif
            if (allocator != null)
            {
                allocator.Dispose();
            }
            // Release DirectShow interfaces
            if (vmr9 != null)
            {
                while (Marshal.ReleaseComObject(this.vmr9) > 0) ; this.vmr9 = null;
            }
            if (nullrenderer != null)
            {
                while (Marshal.ReleaseComObject(this.nullrenderer) > 0) ; this.nullrenderer = null;
            }
            if (mediaControl != null)
            {
                Marshal.ReleaseComObject(this.mediaControl); this.mediaControl = null;
            }
            if (mediaPosition != null)
            {
                Marshal.ReleaseComObject(this.mediaPosition); this.mediaPosition = null;
            }
            if (basicAudio != null)
            {
                Marshal.ReleaseComObject(this.basicAudio); this.basicAudio = null;
            }
            if (basicVideo != null)
            {
                Marshal.ReleaseComObject(this.basicVideo); this.basicVideo = null;
            }
            if (this.graphBuilder2 != null)
            {
                //RemoveAllFilters();
                Marshal.ReleaseComObject(this.graphBuilder2); this.graphBuilder2 = null;
            }
            this.initialized = false;
            GC.Collect();
            GC.WaitForPendingFinalizers();
        }
        public void RemoveAllFilters()
        {
            int hr = 0;
            IEnumFilters enumFilters;
            ArrayList filtersArray = new ArrayList();

            hr = this.graphBuilder2.EnumFilters(out enumFilters);
            DsError.ThrowExceptionForHR(hr);

            IBaseFilter[] filters = new IBaseFilter[1];

            while (enumFilters.Next(filters.Length, filters, IntPtr.Zero) == 0)
            {
                filtersArray.Add(filters[0]);
            }

            foreach (IBaseFilter filter in filtersArray)
            {
                hr = this.graphBuilder2.RemoveFilter(filter);
                while (Marshal.ReleaseComObject(filter) > 0) ;
            }
        }
        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }
        private void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    releaseCOM();
                    util.GraphNotify -= util_GraphNotify;
                }
            }
            disposed = true;
        }
        public double Length
        {
            get
            {
                return this.length;
            }
        }
        public double Position
        {
            get
            {
                double check = 0;
                this.mediaPosition.get_CurrentPosition(out check);
                return check;
            }
        }
    }
}
