﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeue
{
    public enum AccessType
    {
        Private = 0,
        Protected = 1,
        Public = 2
    }

    public class VariableInfo : AssistInformation
    {
        int start;
        int end;
        string type;
        string name;
        AccessType accesstype;
        public VariableInfo()
        {
            Image = NotepadNeue.Properties.Resources.variable;
            accesstype = AccessType.Public;
        }
        public AccessType AccessType
        {
            get
            {
                return accesstype;
            }
            set
            {
                accesstype = value;
            }
        }
        public int Start
        {
            get
            {
                return start;
            }
            set
            {
                start = value;
            }
        }
        public int End
        {
            get
            {
                return end;
            }
            set
            {
                end = value;
            }
        }
        public string Name
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        public string Type
        {
            get
            {
                return type;
            }
            set
            {
                type = value;
            }
        }
        public override string Text
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        public override string HintText
        {
            get
            {
                return type;
            }
            set
            {
                type = value;
            }
        }
    }
}
