﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeue
{
    public class NullNameSpaceManager : NameSpaceInfo
    {
        private static NullNameSpaceManager ins = new NullNameSpaceManager();
        private NullNameSpaceManager()
        {
        }
        public static NullNameSpaceManager NullNSM
        {
            get
            {
                return ins;
            }
        }
    }
    public class NameSpaceInfo : AssistInformation
    {
        NameSpaceInfo parentnamespace;
        bool completeread;
        string name;
        SortedList<string, NameSpaceInfo> namespaces;
        SortedList<string, FunctionInfo> functioninfos;
        SortedList<string, ObjectInfo> objectinfos;
        SortedList<string, VariableInfo> variableinfos;
        SortedList<string, DefineValueInfo> definevalueinfos;
        public NameSpaceInfo()
        {
            Image = NotepadNeue.Properties.Resources._namespace;
            namespaces = new SortedList<string, NameSpaceInfo>();
            functioninfos = new SortedList<string, FunctionInfo>();
            objectinfos = new SortedList<string, ObjectInfo>();
            variableinfos = new SortedList<string, VariableInfo>();
            definevalueinfos = new SortedList<string, DefineValueInfo>();
        }
        public void AddNameSpace(NameSpaceInfo namespacemanager, string name)
        {
            if (!namespaces.ContainsKey(name))
            {
                namespaces.Add(name, namespacemanager);
                namespacemanager.parentnamespace = this;
            }
        }
        public void AddFunction(FunctionInfo functioninfo, string name)
        {
            if (!functioninfos.ContainsKey(name))
            {
                functioninfos.Add(name, functioninfo);
            }
            else
            {
                FunctionInfo tempfunctioninfo = null;
                if (functioninfos.TryGetValue(name, out tempfunctioninfo))
                {
                    tempfunctioninfo.AddContent(functioninfo.ContentAt(0));
                }
            }
        }
        public void AddObject(ObjectInfo objectinfo, string name)
        {
            if (!objectinfos.ContainsKey(name))
            {
                objectinfos.Add(name, objectinfo);
                objectinfo.Namespace = this;
            }
        }
        public void AddVariable(VariableInfo variableinfo, string name)
        {
            if (!variableinfos.ContainsKey(name))
            {
                variableinfos.Add(name, variableinfo);
            }
        }
        public void AddDefineValueInfo(DefineValueInfo definevalueinfo, string name)
        {
            if (!definevalueinfos.ContainsKey(name))
            {
                definevalueinfos.Add(name, definevalueinfo);
            }
        }
        public ObjectInfo GetObjectInfo(string objectname)
        {
            ObjectInfo ret = null;
            objectinfos.TryGetValue(objectname, out ret);
            return ret;
        }
        public IList<ObjectInfo> GetAllObjectType()
        {
            return objectinfos.Values;
        }
        public IList<FunctionInfo> GetALLFunction()
        {
            return functioninfos.Values;
        }
        public IList<NameSpaceInfo> GetALLNameSpace()
        {
            return namespaces.Values;
        }
        public IList<VariableInfo> GetALLVariable()
        {
            return variableinfos.Values;
        }
        public IList<DefineValueInfo> GetALLDefineValue()
        {
            return definevalueinfos.Values;
        }
        public NameSpaceInfo GetNameSpaceManager(string key)
        {
            NameSpaceInfo ret = null;
            namespaces.TryGetValue(key, out ret);
            return ret;
        }
        public string Name
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        public bool CompleteRead
        {
            get
            {
                return completeread;
            }
            set
            {
                completeread = value;
            }
        }
        public NameSpaceInfo ParentNamespace
        {
            get
            {
                return parentnamespace;
            }
            set
            {
                parentnamespace = value;
            }
        }
        public override string Text
        {
            get
            {
                return name;
            }
            set
            {
                name = value;
            }
        }
        public override string HintText
        {
            get
            {
                return "";
            }
            set
            {

            }
        }
    }
}
