﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeue
{
    public class BasicTree
    {

        int start;
        int end;
        SortedList<int, EitherVariableOrTree> data;
        SortedList<int, FunctionInfo> fdata;
        public BasicTree()
        {
            data = new SortedList<int, EitherVariableOrTree>();
            fdata = new SortedList<int, FunctionInfo>();
        }
        public VariableInfo[] Getdata(int index)
        {
            if (this.start <= index && index <= this.end)
            {
                VariableInfo[] ret = new VariableInfo[0];
                foreach (EitherVariableOrTree evot in data.Values)
                {
                    if (evot.VariableInfo == null)
                    {
                        BasicTree bt = evot.BasicTree;
                        VariableInfo[] returndata = bt.Getdata(index);
                        if (returndata.Length != 0)
                        {
                            Array.Resize(ref ret, ret.Length + returndata.Length);
                            Array.Copy(returndata, 0, ret, ret.Length - returndata.Length, returndata.Length);
                        }
                    }
                    else
                    {
                        if (evot.VariableInfo.End <= index)
                        {
                            Array.Resize(ref ret, ret.Length + 1);
                            ret[ret.Length - 1] = evot.VariableInfo;
                        }
                        else
                        {
                            break;
                        }
                    }
                }
                return ret;
            }
            else
            {
                return new VariableInfo[0];
            }
        }
        public FunctionInfo[] GetfData(int index)
        {
            FunctionInfo[] ret = new FunctionInfo[0];
            if (this.start <= index && index <= this.end)
            {

                foreach (EitherVariableOrTree evot in data.Values)
                {
                    if (evot.VariableInfo == null)
                    {
                        if (evot.BasicTree.start <= index && index <= evot.BasicTree.end)
                        {
                            FunctionInfo[] temp = evot.BasicTree.GetfData(index);
                            if (temp.Length != 0)
                            {
                                Array.Resize(ref ret, ret.Length + temp.Length);
                                Array.Copy(temp, 0, ret, ret.Length - temp.Length, temp.Length);
                            }
                        }
                    }
                }
            }
            Array.Resize(ref ret, ret.Length + fdata.Count);
            FunctionInfo[] ownfi = new FunctionInfo[fdata.Count];
            int iter = 0;
            foreach (FunctionInfo fi in fdata.Values)
            {
                ownfi[iter] = fi;
                iter++;
            }
            Array.Copy(ownfi, 0, ret, ret.Length - ownfi.Length, ownfi.Length);
            return ret;
        }
        public IList<EitherVariableOrTree> evot
        {
            get
            {
                return data.Values;
            }
        }
        public IList<FunctionInfo> finfos
        {
            get
            {
                return fdata.Values;
            }
        }
        public VariableInfo[] vinfos
        {
            get
            {
                ArrayList temp = new ArrayList(10);
                foreach (EitherVariableOrTree evot in data.Values)
                {
                    if (evot.VariableInfo != null)
                    {
                        temp.Add(evot.VariableInfo);
                    }
                }
                VariableInfo[] ret = new VariableInfo[temp.Count];
                Array.Copy(temp.ToArray(), ret, ret.Length);
                return ret;
            }
        }
        public void AddData(EitherVariableOrTree evot, int index)
        {
            if (!data.ContainsKey(index))
            {
                data.Add(index, evot);
            }
        }
        public void AddfData(FunctionInfo finfo, int index)
        {
            if (!fdata.ContainsKey(index))
            {
                fdata.Add(index, finfo);
            }
        }
        public BasicTree getTreeshouldbeinput(int index)
        {
            if (index < this.start || this.end < index) return null;
            foreach (EitherVariableOrTree evot in data.Values)
            {
                if (evot.BasicTree != null)
                {
                    if (evot.BasicTree.start <= index && index <= evot.BasicTree.end)
                    {
                        return evot.BasicTree.getTreeshouldbeinput(index);
                    }
                }
            }
            return this;
        }
        public BasicTree getTreeshouldbeinputnext(int index)
        {
            if (index < this.start || this.end < index) return null;
            foreach (EitherVariableOrTree evot in data.Values)
            {
                if (evot.BasicTree != null)
                {
                    if (index < evot.BasicTree.start)
                    {
                        return evot.BasicTree;
                    }
                    else
                    {
                        BasicTree bt = evot.BasicTree.getTreeshouldbeinputnext(index);
                        if (bt != null) return bt;
                    }
                }
            }
            return this;
        }
        public int Start
        {
            get
            {
                return start;
            }
            set
            {
                start = value;
            }
        }
        public int End
        {
            get
            {
                return end;
            }
            set
            {
                end = value;
            }
        }


    }

}
