﻿using System;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeue
{
    public class Shortcutmanager
    {
        SortedList<CustomShortcut, Delegate> sdata;
        public Shortcutmanager()
        {
            sdata = new SortedList<CustomShortcut, Delegate>(new CustomshortcutComparer());
        }

        public CustomShortcut AddShortcut(string s, Delegate d)
        {
            CustomShortcut cs = new CustomShortcut();
            if (String.IsNullOrEmpty(s))
            {
                return cs;
            }
            string[] splitdata = s.Split(new string[] { ", " }, StringSplitOptions.None);
            int keyiter = 0;
            for (int i = 0; i < splitdata.Length; i++)
            {
                if (splitdata[i] == "Control")
                {
                    cs.modifiers = cs.modifiers | Keys.Control;
                }
                else if (splitdata[i] == "Shift")
                {
                    cs.modifiers = cs.modifiers | Keys.Shift;
                }
                else if (splitdata[i] == "Alt")
                {
                    cs.modifiers = cs.modifiers | Keys.Alt;
                }
                else
                {
                    if (keyiter == 0)
                    {
                        KeysConverter kc = new KeysConverter();
                        try
                        {
                            cs.firstkey = (Keys)kc.ConvertFromString(splitdata[i]);
                        }
                        catch
                        {
                        }
                    }
                    else if (keyiter == 1)
                    {
                        KeysConverter kc = new KeysConverter();
                        try
                        {
                            cs.secondkey = (Keys)kc.ConvertFromString(splitdata[i]);
                        }
                        catch
                        {

                        }
                    }
                    keyiter++;
                }
            }
            if ((cs.modifiers & Keys.Control) == Keys.Control || (cs.modifiers & Keys.Shift) == Keys.Shift || (cs.modifiers & Keys.Alt) == Keys.Alt)
            {
                if (cs.firstkey != Keys.None)
                {
                    if (!sdata.ContainsKey(cs))
                    {
                        sdata.Add(cs, d);
                        return cs;
                    }
                    else
                    {
                        Delegate del;
                        sdata.TryGetValue(cs, out del);
                        MessageBox.Show("ショートカットの多重定義です\n" + cs.ToString() + "\n" + del.Method.ToString());
                    }
                }
            }
            else if (Keys.F1 <= cs.firstkey && cs.firstkey <= Keys.F24)
            {
                if (!sdata.ContainsKey(cs))
                {
                    sdata.Add(cs, d);
                    return cs;
                }
                else
                {
                    Delegate del;
                    sdata.TryGetValue(cs, out del);
                    MessageBox.Show("ショートカットの多重定義です\n" + cs.ToString() + "\n" + del.Method.ToString());
                }
            }
            cs = null;
            return cs;
        }
        public void removeshortcut(CustomShortcut cs)
        {
            if (sdata.ContainsKey(cs))
            {
                sdata.Remove(cs);
            }
        }
        public bool Containshortcut(CustomShortcut cs)
        {
            return sdata.ContainsKey(cs);
        }
        public bool Containshortcut(CustomShortcut cs, out CustomShortcut managedcs)
        {
            int index = -1;
            managedcs = null;
            if ((index = sdata.IndexOfKey(cs)) >= 0)
            {
                managedcs = sdata.Keys[index];
            }
            return sdata.ContainsKey(cs);
        }
        public Delegate Getdelegate(CustomShortcut cs)
        {
            Delegate del;
            if (sdata.TryGetValue(cs, out del))
            {
                return del;
            }
            return null;
        }
    }
}
