﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Reflection;

namespace NotepadNeue
{
    static class Program
    {
        public static string AppDir
        {
            get
            {
                return Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            }
        }

        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main(string[] args)
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            MainForm fm1 = null;
            try
            {
                if (args.Length != 0)
                {
                    System.Text.StringBuilder sb = new System.Text.StringBuilder();
                    for (int i = 0; i < args.Length; i++)
                    {
                        if (i != 0) sb.Append(" ");
                        sb.Append(args[i]);
                    }
                    fm1 = new MainForm(sb.ToString());
                    Application.Run(fm1);
                }
                else
                {
                    fm1 = new MainForm("");
                    Application.Run(fm1);
                }
            }
            catch (Exception e)
            {
#if DEBUG
                MessageBox.Show("エラーです。終了します\n" + e.Message + "\n" + e.StackTrace);
#endif
                MessageBox.Show("エラーです。終了します。error.logを開発者に送ってください\nSome error happened. Please send error.log to the developer.\n" + e.Message);
                WriteError(e);
            }
        }

        public static void WriteError(Exception e)
        {
            try
            {
                StreamWriter sw = new StreamWriter("error.log");
                sw.WriteLine(e.Data);
                sw.WriteLine(e.HelpLink);
                sw.WriteLine(e.InnerException);
                sw.WriteLine(e.Message);
                sw.WriteLine(e.Source);
                sw.WriteLine(e.StackTrace);
                sw.WriteLine(e.TargetSite);
                sw.Close();
            }
            catch
            {

            }
        }
    }
}
