﻿using System;
using System.Collections.Generic;
using System.Text;
using NotepadNeueExtension;

namespace NotepadNeue
{
    class NotepadNeueExtensionInfo
    {
        private string _location;
        private string _className;

        /// <summary>
        /// NotepadNeueExtensionInfoクラスのコンストラクタ
        /// </summary>
        /// <param name="path">アセンブリファイルのパス</param>
        /// <param name="cls">クラスの名前</param>
        private NotepadNeueExtensionInfo(string path, string cls)
        {
            this._location = path;
            this._className = cls;
        }

        /// <summary>
        /// アセンブリファイルのパス
        /// </summary>
        public string Location
        {
            get { return _location; }
        }

        /// <summary>
        /// クラスの名前
        /// </summary>
        public string ClassName
        {
            get { return _className; }
        }

        /// <summary>
        /// 有効なプラグインを探す
        /// </summary>
        /// <returns>有効なプラグインのNotepadNeueExtensionInfo配列</returns>
        public static NotepadNeueExtensionInfo[] FindExtensions(string pluginDir)
        {
            System.Collections.ArrayList plugins =
                new System.Collections.ArrayList();

            if (!System.IO.Directory.Exists(pluginDir))
                throw new ApplicationException(
                    "プラグインフォルダ\"" + pluginDir +
                    "\"が見つかりませんでした。");

            //.dllファイルを探す
            string[] dlls =
                System.IO.Directory.GetFiles(pluginDir, "*.dll");

            foreach (string dll in dlls)
            {
                try
                {
                    //アセンブリとして読み込む
                    System.Reflection.Assembly asm =
                        System.Reflection.Assembly.LoadFrom(dll);
                    foreach (Type t in asm.GetTypes())
                    {
                        //アセンブリ内のすべての型について、
                        //プラグインとして有効か調べる
                        if (t.IsClass && t.IsPublic && !t.IsAbstract
                            && t.BaseType == typeof(CExtension))
                        {
                            //NotepadNeueExtensionInfoをコレクションに追加する
                            plugins.Add(
                                new NotepadNeueExtensionInfo(dll, t.FullName));
                        }
                    }
                }
                catch
                {
                }
            }

            //コレクションを配列にして返す
            return (NotepadNeueExtensionInfo[])
                plugins.ToArray(typeof(NotepadNeueExtensionInfo));
        }

        /// <summary>
        /// プラグインクラスのインスタンスを作成する
        /// </summary>
        /// <returns>プラグインクラスのインスタンス</returns>
        public CExtension CreateInstance(IExtensionHost host)
        {
            try
            {
                //アセンブリを読み込む
                System.Reflection.Assembly asm = System.Reflection
                    .Assembly.LoadFrom(this.Location);
                //クラス名からインスタンスを作成する
                CExtension plugin = (CExtension)
                    asm.CreateInstance(this.ClassName);
                //初期化
                plugin.Initialize(host);
                return plugin;
            }
            catch
            {
                return null;
            }
        }

    }
}
