﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace NotepadNeue
{
    public partial class MyToolTip : UserControl
    {
        string text = String.Empty;
        Point startpos = new Point(5, 5);
        int verticalspace = 5;
        Font bFont;
        public MyToolTip()
        {
            InitializeComponent();
            bFont = new Font(this.Font, FontStyle.Bold);
            TextRenderingHint = System.Drawing.Text.TextRenderingHint.SystemDefault;
        }
        public string DisplayText
        {
            get
            {
                return text;
            }
            set
            {
                if (text != value)
                {
                    text = value;
                    Invalidate();
                }
            }
        }
        public System.Drawing.Text.TextRenderingHint TextRenderingHint
        {
            get;
            set;
        }

        private void PaintImpl(Graphics g)
        {
            string[] splitdata = text.Split('\n');
            g.TextRenderingHint = TextRenderingHint;
            int maxwidth = 0;
            int extraheight = 0;
            for (int i = 0; i < splitdata.Length; i++)
            {
                string[] secondsplitdata = splitdata[i].Split(new string[] { "<#<b>#>" }, StringSplitOptions.None);
                int posx = 0;
                for (int j = 0; j < secondsplitdata.Length; j++)
                {
                    if (j % 2 == 1)
                    {
                        if (i == 0)
                        {
                            g.DrawString(secondsplitdata[j], this.bFont, Brushes.Black, startpos.X + posx, startpos.Y + i * (Font.Height + verticalspace));
                            posx += (int)g.MeasureString(secondsplitdata[j], this.bFont).Width;
                        }
                        else
                        {
                            Rectangle rec = new Rectangle(startpos.X + posx, startpos.Y + i * (Font.Height + verticalspace), Math.Max(600, maxwidth), 800);
                            g.DrawString(secondsplitdata[j], this.bFont, Brushes.Black, rec);
                            SizeF sf = g.MeasureString(secondsplitdata[j], this.Font, Math.Max(600, maxwidth));
                            posx += (int)sf.Width;
                            extraheight += (int)sf.Height / (FontHeight + verticalspace);
                        }
                    }
                    else
                    {
                        if (i == 0)
                        {
                            g.DrawString(secondsplitdata[j], this.Font, Brushes.Black, startpos.X + posx, startpos.Y + i * (Font.Height + verticalspace));
                            posx += (int)g.MeasureString(secondsplitdata[j], this.Font).Width;
                        }
                        else
                        {
                            Rectangle rec = new Rectangle(startpos.X + posx, startpos.Y + i * (Font.Height + verticalspace), Math.Max(600, maxwidth), 800);
                            g.DrawString(secondsplitdata[j], this.Font, Brushes.Black, rec);
                            SizeF sf = g.MeasureString(secondsplitdata[j], this.Font, Math.Max(600, maxwidth));
                            posx += (int)sf.Width;
                            extraheight += (int)sf.Height / (FontHeight + verticalspace);
                        }
                    }
                }
                maxwidth = Math.Max(maxwidth, posx);
            }
            this.Size = new Size(maxwidth + startpos.X * 2, (splitdata.Length + extraheight) * (Font.Height + verticalspace) + startpos.Y);
        }

        private void MyToolTip_Paint(object sender, PaintEventArgs e)
        {
            try
            {
                PaintImpl(e.Graphics);
            }
            catch
            {
            }
        }

        private void MyToolTip_FontChanged(object sender, EventArgs e)
        {
            bFont = new Font(this.Font, FontStyle.Bold);
        }
    }
}
