﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace NotepadNeue
{
    public partial class Form6 : Form
    {
        const string st1 = "F1～F24以外のキーが１つ目のキーに設定されている場合は、最低でも一つの修飾キー(Control,Shift,Alt)を選択する必要があります";
        const string st2 = "Shiftキーのみのショートカットは認められません";
        public string[] sdata;
        bool ignore;
        int keymapmode = 0;
        int beforeselectedindex = -1;
        public Form6(string[] s, string[] data)
        {
            InitializeComponent();
            sdata = s;
            listBox1.BeginUpdate();
            foreach (string sss in data)
            {
                this.listBox1.Items.Add(sss);
            }
            listBox1.EndUpdate();
            comboBox1.BeginUpdate();
            comboBox2.BeginUpdate();
            for (int i = 0; i < 255; i++)
            {
                string ss = ((Keys)i).ToString();
                if (ss.IndexOf(',') == -1)
                {
                    comboBox1.Items.Add(ss);
                    comboBox2.Items.Add(ss);
                }
            }
            comboBox1.EndUpdate();
            comboBox2.EndUpdate();
            listBox1.SelectedIndex = 0;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            if (!iffirstfunctionkey() && !atleastchecked())
            {
                MessageBox.Show(st1);
                this.checkBox1.Checked = true;
                return;
            }
            change();
        }

        private void comboBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            change();
        }
        public void change()
        {
            if (beforeselectedindex >= 0 && beforeselectedindex < sdata.Length)
            {
                try
                {
                    StringBuilder sb = new StringBuilder();
                    sb.Append(checkBox1.Checked ? "Control" : "");
                    if (sb.ToString() != "") sb.Append(checkBox2.Checked ? ", Shift" : "");
                    else sb.Append(checkBox2.Checked ? "Shift" : "");
                    if (sb.ToString() != "") sb.Append(checkBox3.Checked ? ", Alt" : "");
                    else sb.Append(checkBox3.Checked ? "Alt" : "");
                    if (sb.ToString() != "")
                    {
                        sb.Append(", ");
                    }
                    sb.Append(comboBox1.Text);
                    sb.Append(", ");
                    sb.Append(comboBox2.Text);
                    sdata[beforeselectedindex] = sb.ToString();
                }
                catch
                {
                }
            }
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            if (!iffirstfunctionkey())
            {
                if (!atleastchecked())
                {
                    MessageBox.Show(st1);
                    this.checkBox1.Checked = true;
                    return;
                }
                if (onlyshiftcheck())
                {
                    MessageBox.Show(st2);
                    this.checkBox1.Checked = true;
                    return;
                }
            }
            change();
        }

        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            if (!iffirstfunctionkey())
            {
                if (!atleastchecked())
                {
                    MessageBox.Show(st1);
                    this.checkBox2.Checked = true;
                    return;
                }
                if (onlyshiftcheck())
                {
                    MessageBox.Show(st2);
                    this.checkBox2.Checked = true;
                    return;
                }
            }
            change();
        }

        private void checkBox3_CheckedChanged(object sender, EventArgs e)
        {
            if (ignore) return;
            if (!iffirstfunctionkey())
            {
                if (!atleastchecked())
                {
                    MessageBox.Show(st1);
                    this.checkBox3.Checked = true;
                    return;
                }
                if (onlyshiftcheck())
                {
                    MessageBox.Show(st2);
                    this.checkBox3.Checked = true;
                    return;
                }
            }
            change();
        }
        private bool atleastchecked()
        {
            if (!checkBox1.Checked && !checkBox2.Checked && !checkBox3.Checked)
            {
                return false;
            }
            return true;
        }
        private bool onlyshiftcheck()
        {
            if (!checkBox1.Checked && checkBox2.Checked && !checkBox3.Checked) return true;
            return false;
        }
        private bool iffirstfunctionkey()
        {
            int num = this.comboBox1.Items.IndexOf("F1");
            if (num <= this.comboBox1.SelectedIndex && this.comboBox1.SelectedIndex < num + 24) return true;
            return false;
        }
        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            change();
            ignore = true;
            this.comboBox1.Text = "None";
            this.comboBox2.Text = "None";
            this.checkBox1.Checked = false;
            this.checkBox2.Checked = false;
            this.checkBox3.Checked = false;
            if (listBox1.SelectedIndex >= 0 && listBox1.SelectedIndex < sdata.Length && sdata[listBox1.SelectedIndex] != "")
            {
                string shortcut = sdata[listBox1.SelectedIndex];
                string[] splitdata = shortcut.Split(',');
                int keyiter = 0;
                foreach (string ss in splitdata)
                {
                    string s = ss.Replace(" ", "");
                    if (s == "Control")
                    {
                        this.checkBox1.Checked = true;
                    }
                    else if (s == "Shift")
                    {
                        this.checkBox2.Checked = true;
                    }
                    else if (s == "Alt")
                    {
                        this.checkBox3.Checked = true;
                    }
                    else
                    {
                        if (keyiter == 0)
                        {
                            this.comboBox1.Text = s;
                            keyiter++;
                        }
                        else if (keyiter == 1)
                        {
                            this.comboBox2.Text = s;
                            keyiter++;
                        }
                    }
                }
            }
            if (!checkBox1.Checked && !checkBox2.Checked && !checkBox3.Checked)
            {
                checkBox1.Checked = true;
            }
            ignore = false;
            beforeselectedindex = listBox1.SelectedIndex;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            this.label1.Show();
            keymapmode = 1;
        }

        private void button4_Click(object sender, EventArgs e)
        {
            this.label1.Show();
            keymapmode = 2;
        }
        private void Form6_KeyDown(object sender, KeyEventArgs e)
        {
            if (keymapmode == 1)
            {
                this.comboBox1.Text = e.KeyCode.ToString();
                keymapmode = 0;
                this.label1.Hide();
            }
            else if (keymapmode == 2)
            {
                this.comboBox2.Text = e.KeyCode.ToString();
                keymapmode = 0;
                this.label1.Hide();
            }
        }

        private void Form6_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
        {
            if (keymapmode == 1)
            {
                this.comboBox1.Text = e.KeyCode.ToString();
                keymapmode = 0;
                this.label1.Hide();
            }
            else if (keymapmode == 2)
            {
                this.comboBox2.Text = e.KeyCode.ToString();
                keymapmode = 0;
                this.label1.Hide();
            }
        }

    }
}
