﻿using System;
using System.Collections.Generic;
using System.Text;
using Sgry.Azuki;

namespace NotepadNeue
{
    public static class ExActions
    {
        public static void SmartBackSpace(IUserInterface ui)
        {
            Document doc = ui.Document;
            IView view = ui.View;

            // do nothing if the document is read-only
            if (doc.IsReadOnly)
            {
                Plat.Inst.MessageBeep();
                return;
            }

            // switch logic according to selection state
            if (doc.RectSelectRanges != null)
            {
                Actions.BackSpace(ui);
            }
            else if (doc.AnchorIndex != doc.CaretIndex)
            {
                Actions.BackSpace(ui);
            }
            else
            {
                //--- case of no selection ---
                int delLen = 1;
                int caret = doc.CaretIndex;

                // if the caret is at document head, there is no chars to delete
                if (caret <= 0)
                {
                    Plat.Inst.MessageBeep();
                    return;
                }

                if (doc[caret - 1] == ' ')
                {
                    while (delLen < ui.TabWidth)
                    {
                        if (caret - delLen - 1 < 0) break;
                        if (doc[caret - delLen - 1] != ' ') break;
                        delLen++;
                    }
                    // delete char(s).
                    doc.Replace(String.Empty, caret - delLen, caret);
                }
                else
                {
                    Actions.BackSpace(ui);
                }
            }

            // update desired column
            view.SetDesiredColumn();
            view.ScrollToCaret();
        }
        public static void SmartDelete(IUserInterface ui)
        {
            Document doc = ui.Document;
            IView view = ui.View;

            // do nothing if the document is read-only
            if (doc.IsReadOnly)
            {
                Plat.Inst.MessageBeep();
                return;
            }

            // switch logic according to selection state
            if (doc.RectSelectRanges != null)
            {
                Actions.Delete(ui);
            }
            else if (doc.AnchorIndex != doc.CaretIndex)
            {
                Actions.Delete(ui);
            }
            else
            {
                //--- case of no selection ---
                int delLen = 1;
                int caret = doc.CaretIndex;

                //check currentline is not last line
                int linenum, columnnum,headindex;
                doc.GetLineColumnIndexFromCharIndex(doc.CaretIndex, out linenum, out columnnum);
                headindex = doc.GetLineHeadIndex(linenum);
                if (linenum < doc.LineCount - 1)
                {
                    //not last line
                    if (doc.GetLineLength(linenum) == caret - headindex)
                    {
                        //at last of line
                        string nextline = doc.GetLineContent(linenum + 1);
                        bool ok = true;
                        int iter = 0;
                        while (iter < nextline.Length)
                        {
                            if (nextline[iter] != ' ' && nextline[iter] != '\t')
                            {
                                ok = false;
                                break;
                            }
                            iter++;
                        }
                        if (ok)
                        {
                            //ok delete nexeline
                            doc.Replace("", caret, doc.GetLineHeadIndex(linenum + 1) + nextline.Length);
                            return;
                        }
                    }
                }



                // if the caret is at document end, there is no chars to delete
                if (doc.Length <= doc.CaretIndex)
                {
                    Plat.Inst.MessageBeep();
                    return;
                }

                if (doc[caret] == ' ')
                {
                    while (delLen < ui.TabWidth)
                    {
                        if (caret + delLen >= doc.Length) break;
                        if (doc[caret + delLen] != ' ') break;
                        delLen++;
                    }
                    // delete char(s).
                    doc.Replace(String.Empty, caret, caret + delLen);
                }
                else
                {
                    Actions.Delete(ui);
                }
            }

            // update desired column
            view.SetDesiredColumn();
            view.ScrollToCaret();
        }
    }
}
