﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeue
{
    public class EditorAssistData
    {
        private int caretpos;
        private int scrapedtime;
        public ArrayList loadedbuffername;
        public List<NameSpaceInfo> usingnamespace;
        public List<ObjectInfo> globalclass;
        public List<NameSpaceInfo> globalnamespace;
        public List<FunctionInfo> globalfunction;
        public List<VariableInfo> globalvariable;
        public List<DefineValueInfo> definevalue;
        public BasicTree VariableDatas;

        public int CaretPos
        {
            set
            {
                caretpos = value;
                scrapedtime = System.Environment.TickCount;
            }
        }
        public int getCaretPos(int pos)
        {
            if (System.Environment.TickCount - scrapedtime > 1000)
            {
                return pos;
            }
            return caretpos;
        }
        public EditorAssistData()
        {
            loadedbuffername = new ArrayList();
            usingnamespace = new List<NameSpaceInfo>();
            globalclass = new List<ObjectInfo>();
            globalnamespace = new List<NameSpaceInfo>();
            globalfunction = new List<FunctionInfo>();
            globalvariable = new List<VariableInfo>();
            definevalue = new List<DefineValueInfo>();
            VariableDatas = new BasicTree();
        }

        public bool IsEqualToNull
        {
            get
            {
                return loadedbuffername.Count == 0 && usingnamespace.Count == 0 && globalclass.Count == 0 &&
                    globalfunction.Count == 0 && globalnamespace.Count == 0 && globalvariable.Count == 0 && definevalue.Count == 0 &&
                    VariableDatas.vinfos.Length == 0 && VariableDatas.finfos.Count == 0 && VariableDatas.evot.Count == 0;
            }
        }
    }
}
