﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;
using System.IO;

namespace NotepadNeue
{
    public partial class ExMyExplorer : NotepadNeueExtension.ExDockContent
    {
        const string directorynodekey = "directory";
        const string notcheckednodetext = "karinode";
        const string cutsigntagtext = "forcut";

        TreeNode rightselectedfilenode = null;
        TreeNode rightselecteddirectorynode = null;
        TreeNode cutnode = null;
        string cutorcopyfilename;

        bool Renamemode = false;

        PictureBox p;
        PictureBox error;
        CheckBox cb;
        public ExMyExplorer()
        {
            InitializeComponent();
            this.GotFocus += new EventHandler(ExMyExplorer_GotFocus);
            Point basepoint = toolStripTextBox1.TextBox.Location;
            basepoint = new Point(toolStrip1.Location.X + basepoint.X, toolStrip1.Location.Y + basepoint.Y);
            Padding pad = toolStripTextBox1.Padding;
            p = new PictureBox();
            p.Size = new Size(16, 16);
            p.Padding = new Padding(0, 0, 0, 0);
            p.Location = new Point(basepoint.X + this.toolStripTextBox1.Width - 38 + pad.Left, basepoint.Y + 2 + pad.Top);
            p.Image = NotepadNeue.Properties.Resources.search;
            p.Cursor = Cursors.IBeam;
            p.MouseDown += new MouseEventHandler(p_MouseDown);
            error = new PictureBox();
            error.Size = new Size(16, 16);
            error.Padding = new Padding(0, 0, 0, 0);
            error.Location = new Point(basepoint.X + this.toolStripTextBox1.Width - 22 + pad.Left, basepoint.Y + 2 + pad.Top);
            error.Image = NotepadNeue.Properties.Resources.warn;
            error.Cursor = Cursors.IBeam;
            error.Visible = false;
            cb = new CheckBox();
            cb.Text = "";
            cb.Location = new Point(basepoint.X + this.toolStripTextBox1.Width - 22 + pad.Left, basepoint.Y + 3 + pad.Top);
            cb.Width = 14;
            cb.Height = 14;
            cb.Margin = new Padding(0, 0, 0, 0);
            toolStripTextBox1.GotFocus += new EventHandler(toolStripTextBox1_GotFocus);
            toolStripTextBox1.LostFocus += new EventHandler(toolStripTextBox1_LostFocus);
            this.Controls.Add(error);
            this.Controls.SetChildIndex(error, 0);
            this.Controls.Add(p);
            this.Controls.SetChildIndex(p, 0);
            this.Controls.Add(cb);
            this.Controls.SetChildIndex(cb, 0);
            this.toolTip1.SetToolTip(cb, "正規表現で検索ならチェック");
            this.toolTip1.SetToolTip(error, "正規表現にエラーがあります");
            cb.TabIndex = 1;
            cb.TabStop = true;
        }

        void ExMyExplorer_GotFocus(object sender, EventArgs e)
        {
            if (treeView1.Selectednode == null)
            {
                if (treeView1.Focusednode != null)
                {
                    treeView1.Selectednode = treeView1.Focusednode;
                    treeView1.DrawandReflash();
                }
                else
                {
                    if (treeView1.Nodes.Count > 0)
                    {
                        treeView1.Selectednode = treeView1.Nodes[0];
                        treeView1.DrawandReflash();
                    }
                }
            }
        }
        void toolStripTextBox1_LostFocus(object sender, EventArgs e)
        {
            p.Visible = true;
            cb.Visible = true;
        }

        void toolStripTextBox1_GotFocus(object sender, EventArgs e)
        {
            p.Visible = false;
            cb.Visible = false;
        }

        void p_MouseDown(object sender, MouseEventArgs e)
        {
            toolStripTextBox1.Focus();
        }
        public string UserDirectory
        {
            get;
            set;
        }
        public string CurrentDirectory
        {
            get;
            set;
        }
        public Form1 fm1
        {
            get;
            set;
        }
        public void Initialize()
        {
            TreeNode tn = CreateNormalNode(Path.GetFileName(Path.GetDirectoryName(UserDirectory)));
            this.treeView1.Nodes.Add(tn);
            this.treeView1.ImageList = new ImageList();
            this.treeView1.ImageList.ColorDepth = ColorDepth.Depth32Bit;
            this.treeView1.ImageList.Images.Add(directorynodekey, NotepadNeue.Properties.Resources.folder);
            tn.ImageKey = directorynodekey;
            tn.SelectedImageKey = directorynodekey;
            recursiveaddfile(tn, UserDirectory);
            tn.Expand();
            treeView1.Width = this.Width;
            if (treeView1.Nodes.Count > 0)
            {
                int height = recursivegetheight(treeView1.Nodes[0]);
                treeView1.Height = height > this.Height ? this.Height : height;
            }
            textBox1.LostFocus += new EventHandler(textBox1_LostFocus);
        }
        private void recursiveaddfile(TreeNode tn, string directory)
        {
            try
            {
                string[] dirs = Directory.GetDirectories(directory);

                for (int i = 0; i < dirs.Length; i++)
                {
                    TreeNode temp = CreateNormalNode(Path.GetFileNameWithoutExtension(dirs[i]));
                    tn.Nodes.Add(temp);
                    temp.ImageKey = directorynodekey;
                    temp.SelectedImageKey = directorynodekey;
                    TreeNode karinode = CreateNormalNode(notcheckednodetext);
                    temp.Nodes.Add(karinode);
                    //recursiveaddfile(temp, dirs[i]);
                }
                string[] fns = Directory.GetFiles(directory);
                for (int i = 0; i < fns.Length; i++)
                {
                    TreeNode temp = CreateNormalNode(Path.GetFileName(fns[i]));
                    tn.Nodes.Add(temp);
                    string extension = Path.GetExtension(fns[i]);
                    if (extension == "") extension = ".txt";
                    if (extension == ".exe")
                    {
                        Icon icon = IconHandler.IconHandler.IconFromExecuteFile(fns[i], IconHandler.IconSize.Small);
                        if (icon != null)
                        {
                            treeView1.ImageList.Images.Add(fns[i], icon);
                            temp.ImageKey = fns[i];
                            temp.SelectedImageKey = fns[i];
                            continue;
                        }
                    }
                    if (!treeView1.ImageList.Images.ContainsKey(extension))
                    {
                        Icon icon = IconHandler.IconHandler.IconFromExtension(extension, IconHandler.IconSize.Small);
                        treeView1.ImageList.Images.Add(extension, icon);
                    }
                    temp.ImageKey = extension;
                    temp.SelectedImageKey = extension;
                }
            }
            catch
            {
                MessageBox.Show("ファイルアクセスエラーです。 @ " + directory);
            }
        }
        private void treeView1_BeforeExpand(object sender, TreeViewCancelEventArgs e)
        {
            if (e.Node.Nodes.Count == 1 && e.Node.Nodes[0].Text == notcheckednodetext)
            {
                e.Node.Nodes.Clear();
                string s = treeView1.GetFullPath(e.Node);
                s = UserDirectory + s; //s.Substring(s.IndexOf("\\") + 1);
                recursiveaddfile(e.Node, s);
            }
        }

        private void treeView1_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            if ((e.Button & MouseButtons.Right) == MouseButtons.Right)
            {
                if (e.Node.ImageKey != directorynodekey)
                {
                    rightselectedfilenode = e.Node;
                    contextMenuStrip1.Show(treeView1, e.X, e.Y);
                }
                else
                {
                    rightselecteddirectorynode = e.Node;
                    contextMenuStrip2.Show(treeView1, e.X, e.Y);
                }
            }
        }
        private void treeView1_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            if (e.Node.ImageKey != directorynodekey)
            {
                string s = treeView1.GetFullPath(e.Node);
                s = UserDirectory + s;
                fm1.OpenFile(s);
            }
            /*string s = e.Node.FullPath;
            if (Path.GetExtension(s) == ".exe")
            {
                s = currentdirectory + s.Substring(s.IndexOf("\\") + 1);
                System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo();
                //ComSpecのパスを取得する
                psi.FileName = System.Environment.GetEnvironmentVariable("ComSpec");
                //出力を読み取れるようにする
                psi.RedirectStandardInput = false;
                psi.RedirectStandardOutput = false;
                psi.UseShellExecute = false;
                //ウィンドウを表示しないようにする
                psi.CreateNoWindow = false;
                psi.WorkingDirectory = this.currentdirectory;
                StreamWriter sw = new StreamWriter(currentdirectory + "temp.bat");
                sw.Write(s);
                sw.Close();
                //コマンドラインを指定（"/c"は実行後閉じるために必要）
                psi.Arguments = "/k temp.bat";
                //起動
                System.Diagnostics.Process.Start(psi);
            }
            else
            {
                s = s.Substring(s.IndexOf("\\") + 1);
                if (File.Exists(currentdirectory + s))
                {
                    try
                    {
                        System.Diagnostics.Process.Start(currentdirectory + s);
                    }
                    catch (Exception ee)
                    {
                        MessageBox.Show(ee.Message);
                    }
                }
            }*/
        }


        private void toolStripMenuItem7_Click(object sender, EventArgs e)
        {
            //open with a certain program
            if (rightselectedfilenode != null)
            {
                string filename = UserDirectory + treeView1.GetFullPath(rightselectedfilenode);
                if (Path.GetExtension(filename) == ".exe")
                {
                    System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo();
                    //ComSpecのパスを取得する
                    psi.FileName = System.Environment.GetEnvironmentVariable("ComSpec");
                    //出力を読み取れるようにする
                    psi.RedirectStandardInput = false;
                    psi.RedirectStandardOutput = false;
                    psi.UseShellExecute = false;
                    //ウィンドウを表示しないようにする
                    psi.CreateNoWindow = false;
                    psi.WorkingDirectory = CurrentDirectory;
                    try
                    {
                        StreamWriter sw = new StreamWriter(CurrentDirectory + "temp.bat");
                        sw.Write("\"" + filename + "\"");
                        sw.Close();
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.Message);
                        return;
                    }
                    //コマンドラインを指定（"/c"は実行後閉じるために必要）
                    psi.Arguments = "/k temp.bat";
                    //起動
                    System.Diagnostics.Process.Start(psi);
                }
                else
                {
                    if (File.Exists(filename))
                    {
                        try
                        {
                            System.Diagnostics.Process.Start(filename);
                        }
                        catch (Exception ee)
                        {
                            MessageBox.Show(ee.Message);
                        }
                    }
                }
            }
        }
        private void ExMyExplorer_BackgroundImageChanged(object sender, EventArgs e)
        {
            if (toolStrip1.Width > 0 && toolStrip1.Height > 0 && treeView1.Width > 0 && treeView1.Height > 0)
            {
                Bitmap tempbit = new Bitmap(toolStrip1.Width, toolStrip1.Height);
                Graphics g = Graphics.FromImage(tempbit);
                if (this.BackgroundImage == null)
                {
                    SolidBrush sb = new SolidBrush(this.BackColor);
                    g.FillRectangle(sb, new Rectangle(0, 0, tempbit.Width, tempbit.Height));
                    toolStrip1.BackgroundImage = tempbit;
                    tempbit = new Bitmap(treeView1.Width, treeView1.Height);
                    g = Graphics.FromImage(tempbit);
                    g.FillRectangle(sb, new Rectangle(0, 0, tempbit.Width, tempbit.Height));
                    treeView1.BackgroundImage = tempbit;
                    sb.Dispose();
                }
                else
                {
                    g.DrawImage(this.BackgroundImage, new Rectangle(0, 0, tempbit.Width, tempbit.Height), new Rectangle(0, 0, tempbit.Width, tempbit.Height), GraphicsUnit.Pixel);
                    toolStrip1.BackgroundImage = tempbit;
                    tempbit = new Bitmap(treeView1.Width, treeView1.Height);
                    g = Graphics.FromImage(tempbit);
                    Point p = PointToClient(treeView1.PointToScreen(treeView1.Location));
                    g.DrawImage(this.BackgroundImage, new Rectangle(0, 0, tempbit.Width, tempbit.Height), new Rectangle(p.X, p.Y, tempbit.Width, tempbit.Height), GraphicsUnit.Pixel);
                    treeView1.BackgroundImage = tempbit;
                }
            }
        }

        private void ExMyExplorer_SizeChanged(object sender, EventArgs e)
        {
            treeView1.Width = this.Width;
            checkheight();
        }
        private void checkheight()
        {
            if (treeView1.Nodes.Count > 0)
            {
                int height = recursivegetheight(treeView1.Nodes[0]);
                treeView1.Height = height > this.Height - toolStrip1.Height ? this.Height - toolStrip1.Height : height;
            }
        }
        private int recursivegetheight(TreeNode tn)
        {
            MyTreeView.NodeState? ns = tn.Tag as MyTreeView.NodeState?;
            if (ns != null)
            {
                if ((ns & MyTreeView.NodeState.invisible) == MyTreeView.NodeState.invisible)
                {
                    return 0;
                }
            }
            if (tn.IsExpanded)
            {
                int sum = 0;
                for (int i = 0; i < tn.Nodes.Count; i++)
                {
                    sum += recursivegetheight(tn.Nodes[i]);
                }
                return treeView1.ItemHeight + sum;
            }
            else
            {
                return treeView1.ItemHeight;
            }
        }
        private void treeView1_AfterCollapse(object sender, TreeViewEventArgs e)
        {
            checkheight();
        }

        private void treeView1_AfterExpand(object sender, TreeViewEventArgs e)
        {
            checkheight();
        }

        private void 新しいドキュメントに開くToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (rightselectedfilenode != null)
            {
                string s = treeView1.GetFullPath(rightselectedfilenode);
                s = UserDirectory + s; //s.Substring(s.IndexOf("\\") + 1);
                fm1.OpenFileToNewDocument(s);
            }
        }

        private void toolStripMenuItem1_Click(object sender, EventArgs e)
        {
            //cut
            if (rightselectedfilenode != null)
            {
                if (cutnode != null)
                {
                    cutnode.Tag = null;
                    cutnode = null;
                }
                rightselectedfilenode.Tag = cutsigntagtext;
                cutnode = rightselectedfilenode;
                toolStripMenuItem3.Enabled = true;
                toolStripMenuItem5.Enabled = true;
                cutorcopyfilename = UserDirectory + treeView1.GetFullPath(rightselectedfilenode);
                treeView1.DrawandReflash();
            }
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            //copy
            if (rightselectedfilenode != null)
            {
                if (cutnode != null)
                {
                    cutnode.Tag = null;
                    cutnode = null;
                }
                toolStripMenuItem3.Enabled = true;
                toolStripMenuItem5.Enabled = true;
                cutorcopyfilename = UserDirectory + treeView1.GetFullPath(rightselectedfilenode);
                treeView1.DrawandReflash();
            }
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            if (rightselectedfilenode != null)
            {
                //paste
                if (cutnode != null)
                {
                    //paste cutnode
                    if (File.Exists(cutorcopyfilename))
                    {
                        try
                        {
                            string dir = Path.GetDirectoryName(UserDirectory + treeView1.GetFullPath(rightselectedfilenode));
                            string destname = dir + "\\" + Path.GetFileName(cutorcopyfilename);

                            if (FileUtil.IsSameFile(cutorcopyfilename, destname))
                            {
                                MessageBox.Show("同じディレクトリ間での操作です");
                                return;
                            }
                            string extension = Path.GetExtension(cutorcopyfilename);
                            int iter = 0;
                            while (File.Exists(destname))
                            {
                                iter++;
                                destname = dir + "\\" + Path.GetFileNameWithoutExtension(cutorcopyfilename) + "(" + iter + ")" + extension;
                            }
                            File.Copy(cutorcopyfilename, destname);
                            File.Delete(cutorcopyfilename);
                            UpdateAll();
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show("エラーが発生しました。\n" + ex.Message);
                        }
                    }
                }
                else
                {
                    //paste copynode
                    if (File.Exists(cutorcopyfilename))
                    {
                        try
                        {
                            string dir = Path.GetDirectoryName(UserDirectory + treeView1.GetFullPath(rightselectedfilenode));
                            string destname = dir + "\\" + Path.GetFileName(cutorcopyfilename);
                            string extension = Path.GetExtension(cutorcopyfilename);
                            int iter = 0;
                            while (File.Exists(destname))
                            {
                                iter++;
                                destname = dir + "\\" + Path.GetFileNameWithoutExtension(cutorcopyfilename) + "(" + iter + ")" + extension;
                            }
                            File.Copy(cutorcopyfilename, destname);
                            UpdateAll();
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show("エラーが発生しました。\n" + ex.Message);
                        }
                    }
                }
            }
        }
        private void toolStripMenuItem6_Click(object sender, EventArgs e)
        {
            //rename
            if (rightselectedfilenode != null)
            {
                Point p = treeView1.GetNodePoint(rightselectedfilenode);
                textBox1.Location = new Point(p.X - 2, p.Y);
                textBox1.Text = rightselectedfilenode.Text;
                textBox1.Width = treeView1.NodeTextWidth(rightselectedfilenode) + 10;
                textBox1.Visible = true;
                textBox1.Focus();
                textBox1.SelectAll();
                Renamemode = true;
            }
        }
        private void treeView1_Scrolled(object sender, ScrollEventArgs e)
        {
            CheckRenameMode();
        }
        private void textBox1_LostFocus(object sender, EventArgs e)
        {
            CheckRenameMode();
        }
        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter || e.KeyChar == (char)Keys.Escape)
            {
                e.Handled = true;
            }
        }
        private void textBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Return)
            {
                CheckRenameMode();
            }
        }
        private void CheckRenameMode()
        {
            if (Renamemode)
            {
                Renamemode = false;
                if (rightselectedfilenode != null)
                {
                    string filename = UserDirectory + treeView1.GetFullPath(rightselectedfilenode);
                    if (File.Exists(filename) && rightselectedfilenode.Text != textBox1.Text)
                    {
                        char[] invalidChars = System.IO.Path.GetInvalidFileNameChars();

                        if (textBox1.Text.IndexOfAny(invalidChars) < 0)
                        {
                            try
                            {
                                Microsoft.VisualBasic.FileIO.FileSystem.RenameFile(filename, this.textBox1.Text);
                                fm1.QueryAlreadyOpenFile(filename, this.textBox1.Text);
                                TreeNode DirectoryNode = rightselectedfilenode.Parent;
                                string directoryname = UserDirectory + treeView1.GetFullPath(DirectoryNode);
                                PartialUpdate(DirectoryNode, directoryname);
                                treeView1.DrawandReflash();
                            }
                            catch (Exception exc)
                            {
                                MessageBox.Show(exc.Message);
                            }
                        }
                        else
                        {
                            MessageBox.Show("ファイル名に使用できない文字が使われています。");
                        }
                    }
                }
                textBox1.Visible = false;
            }
        }
        private void toolStripMenuItem5_Click(object sender, EventArgs e)
        {
            if (rightselecteddirectorynode != null)
            {
                //paste to directory
                if (cutnode != null)
                {
                    cutnode.Tag = null;
                    cutnode = null;
                    toolStripMenuItem3.Enabled = false;
                    toolStripMenuItem5.Enabled = false;
                    //paste cutnode
                    if (File.Exists(cutorcopyfilename))
                    {
                        try
                        {
                            string dir = UserDirectory + treeView1.GetFullPath(rightselecteddirectorynode);
                            string destname = dir + "\\" + Path.GetFileName(cutorcopyfilename);
                            int iter = 1;
                            while (File.Exists(destname))
                            {
                                StringBuilder sb = new StringBuilder();
                                for (int i = 0; i < iter; i++)
                                {
                                    sb.Append("コピー ～ ");
                                }
                                destname = dir + "\\" + sb.ToString() + Path.GetFileName(cutorcopyfilename);
                                iter++;
                            }
                            File.Copy(cutorcopyfilename, destname);
                            File.Delete(cutorcopyfilename);
                            UpdateAll();
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show("エラーが発生しました。\n" + ex.Message);
                        }
                    }
                }
                else
                {
                    //paste copynode
                    if (File.Exists(cutorcopyfilename))
                    {
                        try
                        {
                            string dir = UserDirectory + treeView1.GetFullPath(rightselecteddirectorynode);
                            string destname = dir + "\\" + Path.GetFileName(cutorcopyfilename);
                            int iter = 1;
                            while (File.Exists(destname))
                            {
                                StringBuilder sb = new StringBuilder();
                                for (int i = 0; i < iter; i++)
                                {
                                    sb.Append("コピー ～ ");
                                }
                                destname = dir + "\\" + sb.ToString() + Path.GetFileName(cutorcopyfilename);
                                iter++;
                            }
                            File.Copy(cutorcopyfilename, destname);
                            UpdateAll();
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show("エラーが発生しました。\n" + ex.Message);
                        }
                    }
                }
            }
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            //delete
            if (rightselectedfilenode != null)
            {
                if (MessageBox.Show("削除してもよろしいですか？", "削除確認", MessageBoxButtons.YesNo) == DialogResult.Yes)
                {
                    string filename = UserDirectory + treeView1.GetFullPath(rightselectedfilenode);
                    try
                    {
                        if (File.Exists(filename))
                        {
                            File.Delete(filename);
                        }
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show("エラーが発生しました\n" + ex.Message);
                    }
                    TreeNode DirectoryNode = rightselectedfilenode.Parent;
                    string directoryname = UserDirectory + treeView1.GetFullPath(DirectoryNode);
                    PartialUpdate(DirectoryNode, directoryname);
                    checkheight();
                    treeView1.DrawandReflash();
                }
            }
        }
        private void PartialUpdate(TreeNode DirectoryNode, string directoryname)
        {
            try
            {
                //checkopenedonce
                if (DirectoryNode.Nodes.Count == 1 && DirectoryNode.Nodes[0].Text == notcheckednodetext) return;
                string[] dirs = Directory.GetDirectories(directoryname);
                ArrayList shouldremove = new ArrayList();
                string[] dirsfordelete = new string[dirs.Length];
                for (int i = 0; i < dirs.Length; i++)
                {
                    dirsfordelete[i] = Path.GetFileNameWithoutExtension(dirs[i]);
                }
                //checknoexistnodes
                foreach (TreeNode tempnode in DirectoryNode.Nodes)
                {
                    if (tempnode.ImageKey != directorynodekey) break;
                    if (Array.IndexOf(dirsfordelete, tempnode.Text) == -1)
                    {
                        shouldremove.Add(tempnode);
                    }
                }
                for (int i = 0; i < shouldremove.Count; i++)
                {
                    DirectoryNode.Nodes.Remove(shouldremove[i] as TreeNode);
                }
                for (int i = 0; i < dirs.Length; i++)
                {
                    string dirname = Path.GetFileNameWithoutExtension(dirs[i]);
                    TreeNode tempdirnode = null;
                    if (ContainDirectoryNode(DirectoryNode.Nodes, dirname, out tempdirnode))
                    {
                        PartialUpdate(tempdirnode, dirs[i]);
                        continue;
                    }
                    //new directory
                    TreeNode temp = CreateNormalNode(dirname);
                    DirectoryNode.Nodes.Add(temp);
                    temp.ImageKey = directorynodekey;
                    temp.SelectedImageKey = directorynodekey;
                    TreeNode karinode = CreateNormalNode(notcheckednodetext);
                    temp.Nodes.Add(karinode);
                }
                //checknoexistnodes
                string[] fns = Directory.GetFiles(directoryname);
                string[] fnsfordelete = new string[fns.Length];
                for (int i = 0; i < fns.Length; i++)
                {
                    fnsfordelete[i] = Path.GetFileName(fns[i]);
                }
                shouldremove.Clear();
                foreach (TreeNode tempnode in DirectoryNode.Nodes)
                {
                    if (tempnode.ImageKey != directorynodekey)
                    {
                        if (Array.IndexOf(fnsfordelete, tempnode.Text) == -1)
                        {
                            shouldremove.Add(tempnode);
                        }
                    }
                }
                for (int i = 0; i < shouldremove.Count; i++)
                {
                    DirectoryNode.Nodes.Remove(shouldremove[i] as TreeNode);
                }
                for (int i = 0; i < fns.Length; i++)
                {
                    string filename = Path.GetFileName(fns[i]);
                    if (ContainFileNode(DirectoryNode.Nodes, filename))
                    {
                        continue;
                    }
                    TreeNode temp = CreateNormalNode(filename);
                    DirectoryNode.Nodes.Add(temp);
                    string extension = Path.GetExtension(fns[i]);
                    if (!treeView1.ImageList.Images.ContainsKey(extension))
                    {
                        Icon icon = IconHandler.IconHandler.IconFromExtension(extension, IconHandler.IconSize.Small);
                        Bitmap bit = icon.ToBitmap();
                        treeView1.ImageList.Images.Add(extension, bit);

                    }
                    temp.ImageKey = extension;
                    temp.SelectedImageKey = extension;
                }
                //sort nodes
                TreeNode[] forsort = new TreeNode[DirectoryNode.Nodes.Count];
                DirectoryNode.Nodes.CopyTo(forsort, 0);
                NodeComparer comp = new NodeComparer();
                Array.Sort(forsort, comp);
                DirectoryNode.Nodes.Clear();
                DirectoryNode.Nodes.AddRange(forsort);
            }
            catch
            {
                MessageBox.Show("ファイルアクセスエラーです。 @ " + directoryname);
            }
        }
        private bool ContainDirectoryNode(TreeNodeCollection Nodes, string name, out TreeNode DirectoryNode)
        {
            DirectoryNode = null;
            foreach (TreeNode tn in Nodes)
            {
                if (tn.ImageKey == directorynodekey && tn.Text == name)
                {
                    DirectoryNode = tn;
                    return true;
                }
            }
            return false;
        }
        private bool ContainFileNode(TreeNodeCollection Nodes, string name)
        {
            foreach (TreeNode tn in Nodes)
            {
                if (tn.ImageKey != directorynodekey && tn.Text == name)
                {
                    return true;
                }
            }
            return false;
        }
        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            UpdateAll();
        }
        private void UpdateAll()
        {
            if (treeView1.Nodes.Count > 0)
            {
                TreeNode rootnode = treeView1.Nodes[0];
                PartialUpdate(rootnode, UserDirectory);
            }
            checkheight();
            treeView1.DrawandReflash();
        }
        private TreeNode CreateNormalNode(string text)
        {
            TreeNode ret = new TreeNode(text);
            ret.Tag = MyTreeView.NodeState.none;
            return ret;
        }

        private void toolStripTextBox1_TextChanged(object sender, EventArgs e)
        {
            System.Text.RegularExpressions.Regex reg = null;
            if (cb.Checked)
            {
                try
                {
                    reg = new System.Text.RegularExpressions.Regex(toolStripTextBox1.TextBox.Text);
                }
                catch (Exception ex)
                {
                    error.Visible = true;
                    return;
                }
            }
            error.Visible = false;
            CheckText(treeView1.Nodes[0], toolStripTextBox1.TextBox.Text, reg);
            checkheight();
            treeView1.DrawandReflash();
        }

        private void CheckText(TreeNode Node, string text, System.Text.RegularExpressions.Regex reg)
        {
            try
            {
                if (text == "")
                {
                    Node.Tag = Node.Tag = MyTreeView.NodeState.none;
                    foreach (TreeNode child in Node.Nodes)
                    {
                        CheckText(child, text, reg);
                    }
                    return;
                }
                if (Node.Nodes.Count == 0)
                {
                    bool b = false;
                    if (reg != null)
                    {
                        b = reg.Match(Node.Text).Success;
                    }
                    else
                    {
                        b = Node.Text.Contains(text);
                    }
                    if (b)
                    {
                        Node.Tag = MyTreeView.NodeState.none;
                    }
                    else
                    {
                        Node.Tag = MyTreeView.NodeState.invisible;
                    }
                    return;
                }
                if (Node.IsExpanded)
                {
                    foreach (TreeNode child in Node.Nodes)
                    {
                        CheckText(child, text, reg);
                    }
                }
                bool visible = false;
                if (Node.IsExpanded)
                {
                    foreach (TreeNode child in Node.Nodes)
                    {
                        MyTreeView.NodeState? ns = child.Tag as MyTreeView.NodeState?;
                        if (ns != null)
                        {
                            if ((ns & MyTreeView.NodeState.invisible) != MyTreeView.NodeState.invisible) visible = true;
                        }
                    }
                }
                if (visible)
                {
                    Node.Tag = MyTreeView.NodeState.none;
                }
                else
                {
                    Node.Tag = MyTreeView.NodeState.invisible;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
        public class NodeComparer : System.Collections.IComparer, System.Collections.Generic.IComparer<TreeNode>
        {
            public int Compare(TreeNode x, TreeNode y)
            {
                //nullが最も小さいとする
                if (x == null && y == null)
                    return 0;
                if (x == null)
                    return -1;
                if (y == null)
                    return 1;

                //比較する
                if (x.ImageKey == directorynodekey && y.ImageKey == directorynodekey)
                {
                    StringComparer sc = StringComparer.Create(System.Globalization.CultureInfo.CurrentCulture, false);
                    return sc.Compare(x.Text, y.Text);
                }
                else if (x.ImageKey == directorynodekey)
                {
                    return -1;
                }
                else if (y.ImageKey == directorynodekey)
                {
                    return 1;
                }
                else
                {
                    StringComparer sc = StringComparer.Create(System.Globalization.CultureInfo.CurrentCulture, false);
                    return sc.Compare(x.Text, y.Text);
                }
            }
            public int Compare(object x, object y)
            {
                //nullが最も小さいとする
                if (x == null && y == null)
                    return 0;
                if (x == null)
                    return -1;
                if (y == null)
                    return 1;

                //String型以外の比較はエラー
                if (!(x is TreeNode) || !(y is TreeNode))
                    throw new ArgumentException();
                CustomStringComparer csc = new CustomStringComparer();

                return csc.Compare((TreeNode)x, (TreeNode)y);
            }
        }

        private void ExMyExplorer_KeyDown(object sender, KeyEventArgs e)
        {
            treeView1.Selectednode = treeView1.Focusednode;
            if (e.Control)
            {
                if (e.KeyCode == Keys.F)
                {
                    this.toolStripTextBox1.Focus();
                }
                else if (e.KeyCode == Keys.R)
                {
                    this.toolStripButton1_Click(sender, e);
                }
                else if (e.KeyCode == Keys.Return)
                {
                    treeView1.RightClick();
                }
            }
            else
            {
                if (e.KeyCode == Keys.Down)
                {
                    treeView1.DownSelectedNode();
                    e.Handled = true;
                    treeView1.DrawandReflash();
                }
                else if (e.KeyCode == Keys.Up)
                {
                    treeView1.UpSelectedNode();
                    e.Handled = true;
                    treeView1.DrawandReflash();
                }
                else if (e.KeyCode == Keys.Return)
                {
                    if (treeView1.Selectednode != null && treeView1.Selectednode.ImageKey == directorynodekey)
                    {
                        treeView1.ToggleSelectedNode();
                        treeView1.DrawandReflash();
                    }
                }
            }
        }
    }
}
