﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using NotepadNeueExtension;

namespace NotepadNeue.Docks
{
    public partial class DefineLocationWindow : NotepadNeueExtension.ExDockContent
    {
        private AssistInformation[] assistInformations;

        public event Action<DefineLocation> DefineLocationChanged;

        public DefineLocationWindow()
        {
            InitializeComponent();
        }

        public void SetDefineLocations(AssistInformation[] assistInformations)
        {
            this.assistInformations = assistInformations.Where(a => a != null && a.DefineLocation != null &&
                a.DefineLocation.Editor != null && a.DefineLocation.Editor is ExAzukiControl).ToArray();
            dataGridView1.RowCount = 0;
            foreach (AssistInformation assistInforamtion in assistInformations)
            {
                ExAzukiControl editor = assistInforamtion.DefineLocation.Editor as ExAzukiControl;
                int lineIndex = 0, columnIndex = 0;
                try
                {
                    editor.GetLineColumnIndexFromCharIndex(assistInforamtion.DefineLocation.DefineIndex, out lineIndex, out columnIndex);
                }
                catch
                {
                }
                dataGridView1.Rows.Add(assistInforamtion.Image, assistInforamtion.Text, editor.FileName, lineIndex + 1, columnIndex + 1);
            }
        }

        private void dataGridView1_CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            if (assistInformations == null || e.RowIndex < 0 || e.RowIndex >= assistInformations.Length)
            {
                return;
            }

            DefineLocation defineLocation = assistInformations[e.RowIndex].DefineLocation;
            OnDefineLocationSelected(defineLocation);
        }

        private void OnDefineLocationSelected(DefineLocation defineLocation)
        {
            if (DefineLocationChanged != null)
            {
                DefineLocationChanged(defineLocation);
            }
        }
    }
}
