﻿using System;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Text;

namespace NotepadNeue
{
    public class CustomShortcut
    {
        public Keys modifiers = Keys.None;
        public Keys firstkey = Keys.None;
        public Keys secondkey = Keys.None;

        public bool IsPanelOperation
        {
            get;
            set;
        }

        public ToolStripMenuItem ToolStripMenuItem
        {
            get;
            set;
        }

        public CustomShortcut()
        {
            IsPanelOperation = false;
        }

        public bool IsEqual(CustomShortcut cs)
        {
            if (modifiers == cs.modifiers && firstkey == cs.firstkey && secondkey == cs.secondkey)
            {
                return true;
            }
            return false;
        }
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(modifiers.ToString());
            sb.Append(", ");
            sb.Append(firstkey.ToString());
            sb.Append(", ");
            sb.Append(secondkey.ToString());
            return sb.ToString();
        }
        public string displaystring()
        {
            StringBuilder sb = new StringBuilder();
            if ((modifiers & Keys.Control) == Keys.Control) sb.Append("Ctrl");
            if ((modifiers & Keys.Shift) == Keys.Shift)
            {
                if (sb.ToString() != "")
                {
                    sb.Append("+Shift");
                }
                else
                {
                    sb.Append("Shift");
                }
            }
            if ((modifiers & Keys.Alt) == Keys.Alt)
            {
                if (sb.ToString() != "")
                {
                    sb.Append("+Alt");
                }
                else
                {
                    sb.Append("Alt");
                }
            }
            if (firstkey != Keys.None)
            {
                if (sb.ToString() != "")
                {
                    sb.Append("+");
                }
                sb.Append(((Keys)firstkey).ToString());
                if (secondkey != Keys.None)
                {
                    sb.Append(" , ");
                    sb.Append(((Keys)secondkey).ToString());
                }
            }
            return sb.ToString();
        }
    }
    public class CustomshortcutComparer : System.Collections.IComparer, System.Collections.Generic.IComparer<CustomShortcut>
    {
        public int Compare(CustomShortcut x, CustomShortcut y)
        {
            //nullが最も小さいとする
            if (x == null && y == null)
                return 0;
            if (x == null)
                return -1;
            if (y == null)
                return 1;

            //比較する
            int xval = 0;
            int yval = 0;
            if ((x.modifiers & Keys.Control) == Keys.Control) xval += 100000;
            if ((x.modifiers & Keys.Shift) == Keys.Shift) xval += 200000;
            if ((x.modifiers & Keys.Alt) == Keys.Alt) xval += 500000;
            if (x.firstkey != Keys.None)
            {
                xval += (int)x.firstkey * 255;
                if (x.secondkey != Keys.None)
                {
                    xval += (int)x.secondkey;
                }
            }
            if ((y.modifiers & Keys.Control) == Keys.Control) yval += 100000;
            if ((y.modifiers & Keys.Shift) == Keys.Shift) yval += 200000;
            if ((y.modifiers & Keys.Alt) == Keys.Alt) yval += 500000;
            if (y.firstkey != Keys.None)
            {
                yval += (int)y.firstkey * 255;
                if (y.secondkey != Keys.None)
                {
                    yval += (int)y.secondkey;
                }
            }
            return xval - yval;
        }

        public int Compare(object x, object y)
        {
            //nullが最も小さいとする
            if (x == null && y == null)
                return 0;
            if (x == null)
                return -1;
            if (y == null)
                return 1;

            //String型以外の比較はエラー
            if (!(x is CustomShortcut) || !(y is CustomShortcut))
                throw new ArgumentException();
            CustomshortcutComparer csc = new CustomshortcutComparer();

            return csc.Compare((CustomShortcut)x, (CustomShortcut)y);
        }

    }
}
