﻿using System;
using System.Drawing;
using System.Text.RegularExpressions;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using NotepadNeueExtension;
using System.Linq;

namespace ConsoleExtension
{
    public class ConsoleExtension : CExtension
    {
        delegate void CustomCommand(Match match);

        const int maxpoolnum = 200;
        private Regex PathCheckRegex = new Regex("(?<path>[^\\>]*)\\>");
        private Regex HelpCheckRegex = new Regex(" *help ?(?<helptarget>[^\\s]*) *$");
        private Process p;
        private string currentdirectory;
        private List<string> pool = new List<string>(100);
        private int pooliter;
        bool ignorefirst = false;
        bool checkdir = false;
        int ticknum = 0;
        Timer ProcessStateChecker;
        private ToolStripContainer toolStripContainer1;
        private SplitContainer splitContainer1;
        private TextBox textBox1;
        private TextBox textBox2;
        private ToolStrip toolStrip1;
        private ToolStripButton toolStripButton1;
        private ToolStripButton toolStripButton2;
        private FolderBrowserDialog folderBrowserDialog1;
        string[] COMMAND = new string[]{
            "ASSOC","ATTRIB","BREAK","BCDEDIT","CACLS",
            "CALL","CD","CHCP","CHDIR","CHKDSK","CHKNTFS",
            "CLS","CMD","COLOR","COMP","COMPACT","CONVERT",
            "COPY","DATE","DEL","DIR","DISKCOMP","DISKCOPY",
            "DISKPART","DOSKEY","DRIVERQUERY","ECHO","ENDLOCAL",
            "ERASE","EXIT","FC","FIND","FINDSTR","FOR","FORMAT","FSUTIL",
            "FTYPE","GOTO","GPRESULT","GRAFTABL","HELP","ICACLS","IF",
            "LABEL","MD","MKDIR","MKLINK","MODE","MORE","MOVE","OPENFILES",
            "PATH","PAUSE","POPD","PRINT","PROMPT","PUSHD","RD","RECOVER",
            "REM","REN","RENAME","REPLACE","RMDIR","ROBOCOPY","SET","SETLOCAL",
            "SC","SCHTASKS","SHIFT","SHUTDOWN","SORT","START","SUBST","SYSTEMINFO",
            "TASKLIST","TASKKILL","TIME","TITLE","TREE","TYPE","VER","VERIFY",
            "VOL","XCOPY","WMIC"
        };

        string[] customs = new string[]{"n2_newdoc","n2_closedoc","n2_vsplit","n2_hsplit",
            "n2_savedoc","n2_opendoc","n2_opendocnew","n2_reload","n2_changemode","n2_exit","n2_compile",
            "n2_execute","n2_cexecute","n2_backup"
        };

        string[] customstext = new string[]{"新しいドキュメントタブを開きます","ドキュメントを閉じます","ドキュメントを垂直分割します","ドキュメントを水平分割します",
            "ドキュメントを保存します","ファイルを現在のドキュメントに開きます","ファイルを新しいドキュメントに開きます","ドキュメントを再読み込みします","ドキュメントのモードを変更します","NotepadNeueを終了します","ドキュメントをコンパイルします",
            "ドキュメントを実行します","ドキュメントをコンパイルし実行します","ドキュメントのバックアップをとります"
        };

        string[] customshelp = new string[]{@"n2_newdoc [vsplit/hsplit]
vsplit   ドキュメントを垂直タブで初期化します
hsplit   ドキュメントを水平タブで初期化します",
@"n2_closedoc [filename/all/without]
filename   対象のドキュメント
all        全てのドキュメント
without    現在のドキュメント以外のドキュメント",
@"n2_vsplit [filename]
filename   対象のドキュメント",
@"n2_hsplit [filename]
filename   対象のドキュメント",
@"n2_savedoc [filename/all/without]
filename   対象のドキュメント
all        全てのドキュメント
without    現在のドキュメント以外のドキュメント",
@"n2_opendoc [filename]
filename   対象のドキュメント",
@"n2_opendocnew [filename]
filename   対象のドキュメント",
@"n2_reload [filename/all/without]
filename   対象のドキュメント
all        全てのドキュメント
without    現在のドキュメント以外のドキュメント",
@"n2_changemode [filename/all/without]
filename   対象のドキュメント
all        全てのドキュメント
without    現在のドキュメント以外のドキュメント",
@"n2_exit",
@"n2_compile [filename/all/without]
filename   対象のドキュメント
all        全てのドキュメント
without    現在のドキュメント以外のドキュメント",
@"n2_execute [filename/all/without]
filename   対象のドキュメント
all        全てのドキュメント
without    現在のドキュメント以外のドキュメント",
@"n2_cexecute [filename/all/without]
filename   対象のドキュメント
all        全てのドキュメント
without    現在のドキュメント以外のドキュメント",
@"n2_backup [filename/all/without]
filename   対象のドキュメント
all        全てのドキュメント
without    現在のドキュメント以外のドキュメント",
        };


        SortedList<ExRegex, CustomCommand> CustomCommands;

        enum FileType
        {
            All = 0,
            Without = 1,
            Else = 2
        }


        public override string ExtensionName
        {
            get
            {
                return "コンソールウィンドウ";
            }
        }
        public IExtensionHost Host
        {
            get;
            set;
        }
        /*public ConsoleExtension()
        {
            /*InitializeComponent();
            InitializeCustomCommand();
            RestoreCache();
            ProcessStateChecker = new Timer();
            ProcessStateChecker.Interval = 1000;
            this.GotFocus += new EventHandler(TestExtension_GotFocus);
            currentdirectory = Path.GetDirectoryName(Application.ExecutablePath);
            ProcessInitialize();
        }*/

        void ProcessStateChecker_Tick(object sender, EventArgs e)
        {
            if (p != null)
            {
                checkdir = true;
                ProcessStateChecker.Tick -= new EventHandler(ProcessStateChecker_Tick);
                ticknum--;
                p.StandardInput.Write("\r\n");
                ProcessStateChecker.Stop();
            }
        }
        public override void Initialize(IExtensionHost Host)
        {
            InitializeComponent();
            this.Host = Host;
            InitializeCustomCommand();
            Host.MainFormClosed += new EventHandler(Host_MainFormClosed);
            RestoreCache();
            ProcessStateChecker = new Timer();
            ProcessStateChecker.Interval = 1000;
            this.GotFocus += new EventHandler(TestExtension_GotFocus);
            currentdirectory = Path.GetDirectoryName(Application.ExecutablePath);
            ProcessInitialize();
        }
        private void InitializeCustomCommand()
        {
            try
            {
                CustomCommands = new SortedList<ExRegex, CustomCommand>();
                ExRegex regex = new ExRegex(" *n2_newdoc *(?<split>[^\\s]*) *$");
                CustomCommand c = new CustomCommand(NewDoc);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_closedoc *(?<filetype>[^\\s]*) *$");
                c = new CustomCommand(CloseDoc);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_vsplit *(?<filetype>[^\\s]*) *$");
                c = new CustomCommand(VSplitDoc);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_hsplit *(?<filetype>[^\\s]*) *$");
                c = new CustomCommand(HSplitDoc);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_savedoc *(?<filetype>[^\\s]*) *$");
                c = new CustomCommand(SaveDoc);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_opendoc *(?<filetype>[^\\s]*) *$");
                c = new CustomCommand(OpenDoc);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_opendocnew *(?<filetype>[^\\s]*) *$");
                c = new CustomCommand(OpenDocNew);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_reload *(?<filetype>[^\\s]*) *$");
                c = new CustomCommand(ReloadDoc);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_changemode *(?<filetype>[^\\s]*) *(?<extension>[^\\s]*) *$");
                c = new CustomCommand(ChangeDocMode);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_exit *$");
                c = new CustomCommand(N2Exit);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_compile *$");
                c = new CustomCommand(Compile);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_execute *(?<filetype>[^\\s]*) *$");
                c = new CustomCommand(Execute);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_cexecute *(?<filetype>[^\\s]*) *$");
                c = new CustomCommand(CAndExecute);
                CustomCommands.Add(regex, c);
                regex = new ExRegex(" *n2_backup *(?<filetype>[^\\s]*) *$");
                c = new CustomCommand(BackupDoc);
                CustomCommands.Add(regex, c);
            }
            catch
            {
            }
        }
        private void NewDoc(Match match)
        {
            string split = match.Groups["split"].Value;
            Host.CreateNewDocument();
            if (split == "vsplit") Host.VerticalSplitDocument();
            else if (split == "hsplit") Host.HorizontalSplitDocument();
        }
        private void CloseDoc(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            FileType ft = GetFileTypeFromString(filetype);
            if (ft == FileType.All || ft == FileType.Without)
            {
                string[] all = Host.AllDocumentPath;
                string current = Host.DocumentPath;
                foreach (string allst in all)
                {
                    if (ft == FileType.Without)
                    {
                        if (allst != current) Host.CloseDocument(allst);
                    }
                    else Host.CloseDocument(allst);
                }
            }
            else
            {
                if (filetype == "") Host.CloseDocument();
                else Host.CloseDocument(GetWithoutQuotation(filetype));
            }
        }
        private void VSplitDoc(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            if (filetype == "") Host.VerticalSplitDocument();
            else Host.VerticalSplitDocument(GetWithoutQuotation(filetype));
        }
        private void HSplitDoc(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            if (filetype == "") Host.HorizontalSplitDocument();
            else Host.HorizontalSplitDocument(GetWithoutQuotation(filetype));
        }
        private void SaveDoc(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            FileType ft = GetFileTypeFromString(filetype);
            if (ft == FileType.All || ft == FileType.Without)
            {
                string[] all = Host.AllDocumentPath;
                string current = Host.DocumentPath;
                foreach (string allst in all)
                {
                    if (ft == FileType.Without)
                    {
                        if (allst != current) Host.SaveDocument(allst);
                    }
                    else Host.SaveDocument(allst);
                }
            }
            else
            {
                if (filetype == "") Host.SaveDocument();
                else Host.SaveDocument(GetWithoutQuotation(filetype));
            }
        }

        private void OpenDoc(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            filetype = GetWithoutQuotation(filetype);
            string abpath = GetAbsolutePath(filetype);
            if (File.Exists(abpath))
            {
                Host.OpenFile(abpath);
            }
            else
            {
                this.textBox1.AppendText("存在しないファイルです\r\n" + abpath + "\r\n");
            }
        }
        private string GetAbsolutePath(string expression)
        {
            string checkdir = currentdirectory;
            bool currentcame = false;
            bool charactercame = false;
            string[] spdata = expression.Split(new string[] { "\\", "/" }, StringSplitOptions.None);
            for (int i = 0; i < spdata.Length; i++)
            {
                if (spdata[i] == ".." && !charactercame)
                {
                    try
                    {
                        checkdir = Directory.GetParent(checkdir).FullName;
                    }
                    catch
                    {
                        return "";
                    }
                }
                else if (spdata[i] == "." && !currentcame)
                {
                    currentcame = true;
                }
                else if (!charactercame && IsDirive(spdata[i]))
                {
                    charactercame = true;
                    checkdir = spdata[i] + "\\";
                }
                else
                {
                    charactercame = true;
                    string temp = checkdir + "\\" + spdata[i];
                    if (Directory.Exists(temp))
                    {
                        checkdir = temp;
                    }
                    else
                    {
                        if (i == spdata.Length - 1 && File.Exists(temp)) return temp;
                        return "";
                    }
                }
            }
            return checkdir;
        }
        private void OpenDocNew(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            filetype = GetWithoutQuotation(filetype);
            string abpath = GetAbsolutePath(filetype);
            if (File.Exists(abpath))
            {
                Host.OpenFileToNewDocument(abpath);
            }
            else
            {
                this.textBox1.AppendText("存在しないファイルです\r\n" + abpath + "\r\n");
            }
        }

        private void ReloadDoc(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            FileType ft = GetFileTypeFromString(filetype);
            if (ft == FileType.All || ft == FileType.Without)
            {
                string[] all = Host.AllDocumentPath;
                string current = Host.DocumentPath;
                foreach (string allst in all)
                {
                    if (ft == FileType.Without)
                    {
                        if (allst != current) Host.ReloadDocument(allst);
                    }
                    else Host.ReloadDocument(allst);
                }
            }
            else
            {
                if (filetype == "") Host.ReloadDocument();
                else Host.ReloadDocument(GetWithoutQuotation(filetype));
            }
        }
        private void ChangeDocMode(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            string extension = match.Groups["extension"].Value;
            if (extension == "")
            {
                extension = filetype;
                Host.ChangeDocumentMode(extension);
            }
            else
            {
                FileType ft = GetFileTypeFromString(filetype);
                if (ft == FileType.All || ft == FileType.Without)
                {
                    string[] all = Host.AllDocumentPath;
                    string current = Host.DocumentPath;
                    foreach (string allst in all)
                    {
                        if (ft == FileType.Without)
                        {
                            if (current != allst) Host.ChangeDocumentMode(extension, allst);
                        }
                        else Host.ChangeDocumentMode(extension, allst);
                    }
                }
                else
                {
                    Host.ChangeDocumentMode(extension, GetWithoutQuotation(filetype));
                }
            }
        }

        private void N2Exit(Match match)
        {
            Host.Exit();
        }

        private void Compile(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            FileType ft = GetFileTypeFromString(filetype);
            if (ft == FileType.All || ft == FileType.Without)
            {
                string[] all = Host.AllDocumentPath;
                string current = Host.DocumentPath;
                foreach (string allst in all)
                {
                    if (ft == FileType.Without)
                    {
                        if (allst != current) Host.Compile(allst);
                    }
                    else Host.Compile(allst);
                }
            }
            else
            {
                if (filetype == "") Host.Compile();
                else Host.Compile(GetWithoutQuotation(filetype));
            }
        }
        private void Execute(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            FileType ft = GetFileTypeFromString(filetype);
            if (ft == FileType.All || ft == FileType.Without)
            {
                string[] all = Host.AllDocumentPath;
                string current = Host.DocumentPath;
                foreach (string allst in all)
                {
                    if (ft == FileType.Without)
                    {
                        if (allst != current) Host.Execute(allst);
                    }
                    else Host.Execute(allst);
                }
            }
            else
            {
                if (filetype == "") Host.Execute();
                else Host.Execute(GetWithoutQuotation(filetype));
            }
        }
        private void CAndExecute(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            FileType ft = GetFileTypeFromString(filetype);
            if (ft == FileType.All || ft == FileType.Without)
            {
                string[] all = Host.AllDocumentPath;
                string current = Host.DocumentPath;
                foreach (string allst in all)
                {
                    if (ft == FileType.Without)
                    {
                        if (allst != current) Host.CompileAndExecute(allst);
                    }
                    else Host.CompileAndExecute(allst);
                }
            }
            else
            {
                if (filetype == "") Host.CompileAndExecute();
                else Host.CompileAndExecute(GetWithoutQuotation(filetype));
            }
        }
        private void BackupDoc(Match match)
        {
            string filetype = match.Groups["filetype"].Value;
            FileType ft = GetFileTypeFromString(filetype);
            if (ft == FileType.All || ft == FileType.Without)
            {
                string[] all = Host.AllDocumentPath;
                string current = Host.DocumentPath;
                foreach (string allst in all)
                {
                    if (ft == FileType.Without)
                    {
                        if (allst != current) Host.BackUpFile(allst);
                    }
                    else Host.BackUpFile(allst);
                }
            }
            else
            {
                if (filetype == "") Host.BackUpFile();
                else Host.BackUpFile(GetWithoutQuotation(filetype));
            }
        }
        FileType GetFileTypeFromString(string st)
        {
            string lower = st.ToLower();
            if (lower == "all") return FileType.All;
            if (lower == "without") return FileType.Without;
            return FileType.Else;
        }
        string GetWithoutQuotation(string st)
        {
            st = st.Replace("\"", "");
            st = st.Replace("'", "");
            return st;
        }
        void Host_MainFormClosed(object sender, EventArgs e)
        {
            SaveCache();
        }
        void SaveCache()
        {
            Host.SetSetting("ConsoleExtension", "Cache", pool.Aggregate("", (s, p) => String.Format("{0}\n{1}", s, p)));
        }
        void RestoreCache()
        {
            string setting = Host.GetSetting("ConsoleExtension", "Cache");
            if (setting == null)
            {
                return;
            }
            pool.AddRange(setting.Split('\n'));
            pooliter = pool.Count;
        }
        void TestExtension_GotFocus(object sender, EventArgs e)
        {
            textBox2.Focus();
        }
        void ProcessInitialize()
        {
            ProcessStartInfo psi = new ProcessStartInfo();
            psi.WorkingDirectory = currentdirectory;
            psi.RedirectStandardOutput = true;
            psi.RedirectStandardInput = true;
            psi.RedirectStandardError = true;
            psi.CreateNoWindow = true;
            psi.UseShellExecute = false;
            psi.FileName = System.Environment.GetEnvironmentVariable("comspec");
            p = new Process();
            p.StartInfo = psi;
            p.EnableRaisingEvents = true;
            p.Exited += new EventHandler(p_Exited);
            p.OutputDataReceived += new DataReceivedEventHandler(p_OutputDataReceived);
            p.ErrorDataReceived += new DataReceivedEventHandler(p_ErrorDataReceived);
            p.Start();
            p.BeginErrorReadLine();
            p.BeginOutputReadLine();
            p.StandardInput.Write("\r\n");
            //this.textBox1.AppendText(currentdirectory + ">");
        }

        void p_Exited(object sender, EventArgs e)
        {
            this.textBox1.AppendText("\r\nProcess was exited\r\n");
            ProcessInitialize();
        }
        void p_ErrorDataReceived(object sender, DataReceivedEventArgs e)
        {
            if (textBox1.InvokeRequired)
            {
                textBox1.Invoke(new AppendString(SetToTextBox), new object[] { e.Data });
            }
        }

        void p_OutputDataReceived(object sender, DataReceivedEventArgs e)
        {
            if (textBox1.InvokeRequired)
            {
                textBox1.Invoke(new AppendString(SetToTextBox), new object[] { e.Data });
            }
        }

        private delegate void AppendString(string str);
        private void SetToTextBox(string str)
        {
            ProcessStateChecker.Stop();
            if (checkdir)
            {
                CheckCurrentDirectory(str);
                checkdir = false;
            }
            if (!ignorefirst)
            {
                this.textBox1.AppendText("\r\n");
                this.textBox1.AppendText(str);
                ProcessStateChecker.Start();
            }
            else
            {
                ignorefirst = false;
            }
            //this.textBox1.AppendText(p.StartInfo.WorkingDirectory + " > ");
        }
        private void CheckCurrentDirectory(string str)
        {
            Match m = PathCheckRegex.Match(str);
            if (m.Success)
            {
                if (m.Groups["path"].Value != null || m.Groups["path"].Value != "")
                {
                    if (Directory.Exists(currentdirectory))
                    {
                        currentdirectory = m.Groups["path"].Value;
                    }
                }
            }
        }
        private void InitializeComponent()
        {
            this.toolStripContainer1 = new System.Windows.Forms.ToolStripContainer();
            this.splitContainer1 = new System.Windows.Forms.SplitContainer();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.textBox2 = new System.Windows.Forms.TextBox();
            this.toolStrip1 = new System.Windows.Forms.ToolStrip();
            this.toolStripButton1 = new System.Windows.Forms.ToolStripButton();
            this.toolStripButton2 = new System.Windows.Forms.ToolStripButton();
            this.folderBrowserDialog1 = new System.Windows.Forms.FolderBrowserDialog();
            this.toolStripContainer1.ContentPanel.SuspendLayout();
            this.toolStripContainer1.LeftToolStripPanel.SuspendLayout();
            this.toolStripContainer1.SuspendLayout();
            this.splitContainer1.Panel1.SuspendLayout();
            this.splitContainer1.Panel2.SuspendLayout();
            this.splitContainer1.SuspendLayout();
            this.toolStrip1.SuspendLayout();
            this.SuspendLayout();
            // 
            // toolStripContainer1
            // 
            // 
            // toolStripContainer1.ContentPanel
            // 
            this.toolStripContainer1.ContentPanel.Controls.Add(this.splitContainer1);
            this.toolStripContainer1.ContentPanel.Size = new System.Drawing.Size(268, 252);
            this.toolStripContainer1.Dock = System.Windows.Forms.DockStyle.Fill;
            // 
            // toolStripContainer1.LeftToolStripPanel
            // 
            this.toolStripContainer1.LeftToolStripPanel.BackColor = System.Drawing.SystemColors.Control;
            this.toolStripContainer1.LeftToolStripPanel.Controls.Add(this.toolStrip1);
            this.toolStripContainer1.Location = new System.Drawing.Point(0, 0);
            this.toolStripContainer1.Name = "toolStripContainer1";
            this.toolStripContainer1.Size = new System.Drawing.Size(292, 277);
            this.toolStripContainer1.TabIndex = 0;
            this.toolStripContainer1.Text = "toolStripContainer1";
            // 
            // splitContainer1
            // 
            this.splitContainer1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.splitContainer1.Location = new System.Drawing.Point(0, 0);
            this.splitContainer1.Margin = new System.Windows.Forms.Padding(0);
            this.splitContainer1.Name = "splitContainer1";
            this.splitContainer1.Orientation = System.Windows.Forms.Orientation.Horizontal;
            // 
            // splitContainer1.Panel1
            // 
            this.splitContainer1.Panel1.Controls.Add(this.textBox1);
            // 
            // splitContainer1.Panel2
            // 
            this.splitContainer1.Panel2.Controls.Add(this.textBox2);
            this.splitContainer1.Panel2MinSize = 20;
            this.splitContainer1.Size = new System.Drawing.Size(268, 252);
            this.splitContainer1.SplitterDistance = 226;
            this.splitContainer1.SplitterWidth = 1;
            this.splitContainer1.TabIndex = 2;
            this.splitContainer1.TabStop = false;
            // 
            // textBox1
            // 
            this.textBox1.BackColor = System.Drawing.SystemColors.ControlLightLight;
            this.textBox1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.textBox1.Location = new System.Drawing.Point(0, 0);
            this.textBox1.Multiline = true;
            this.textBox1.Name = "textBox1";
            this.textBox1.ReadOnly = true;
            this.textBox1.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.textBox1.Size = new System.Drawing.Size(268, 226);
            this.textBox1.TabIndex = 1;
            this.textBox1.TabStop = false;
            // 
            // textBox2
            // 
            this.textBox2.Dock = System.Windows.Forms.DockStyle.Fill;
            this.textBox2.Location = new System.Drawing.Point(0, 0);
            this.textBox2.Margin = new System.Windows.Forms.Padding(0);
            this.textBox2.Multiline = true;
            this.textBox2.Name = "textBox2";
            this.textBox2.Size = new System.Drawing.Size(268, 25);
            this.textBox2.TabIndex = 0;
            this.textBox2.TabStop = false;
            this.textBox2.KeyDown += new System.Windows.Forms.KeyEventHandler(this.textBox2_KeyDown);
            this.textBox2.KeyUp += new System.Windows.Forms.KeyEventHandler(this.textBox2_KeyUp);
            this.textBox2.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.textBox2_KeyPress);
            // 
            // toolStrip1
            // 
            this.toolStrip1.BackColor = System.Drawing.Color.Transparent;
            this.toolStrip1.Dock = System.Windows.Forms.DockStyle.None;
            this.toolStrip1.GripStyle = System.Windows.Forms.ToolStripGripStyle.Hidden;
            this.toolStrip1.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripButton1,
            this.toolStripButton2});
            this.toolStrip1.Location = new System.Drawing.Point(0, 0);
            this.toolStrip1.Name = "toolStrip1";
            this.toolStrip1.RenderMode = System.Windows.Forms.ToolStripRenderMode.Professional;
            this.toolStrip1.Size = new System.Drawing.Size(24, 252);
            this.toolStrip1.Stretch = true;
            this.toolStrip1.TabIndex = 0;
            // 
            // toolStripButton1
            // 
            this.toolStripButton1.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButton1.Image = global::ConsoleExtension.Properties.Resources.console;
            this.toolStripButton1.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.toolStripButton1.Name = "toolStripButton1";
            this.toolStripButton1.Size = new System.Drawing.Size(22, 20);
            this.toolStripButton1.Text = "コンソールを起動する";
            this.toolStripButton1.Click += new System.EventHandler(this.toolStripButton1_Click);
            // 
            // toolStripButton2
            // 
            this.toolStripButton2.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButton2.Image = global::ConsoleExtension.Properties.Resources.folder;
            this.toolStripButton2.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.toolStripButton2.Name = "toolStripButton2";
            this.toolStripButton2.Size = new System.Drawing.Size(22, 20);
            this.toolStripButton2.Text = "カレントディレクトリを変更";
            this.toolStripButton2.Click += new System.EventHandler(this.toolStripButton2_Click);
            // 
            // ConsoleExtension
            // 
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 12F);
            this.ClientSize = new System.Drawing.Size(292, 277);
            this.Controls.Add(this.toolStripContainer1);
            this.KeyPreview = true;
            this.Name = "ConsoleExtension";
            this.SizeChanged += new System.EventHandler(this.TestExtension_SizeChanged);
            this.BackgroundImageChanged += new System.EventHandler(this.ConsoleExtension_BackgroundImageChanged);
            this.toolStripContainer1.ContentPanel.ResumeLayout(false);
            this.toolStripContainer1.LeftToolStripPanel.ResumeLayout(false);
            this.toolStripContainer1.LeftToolStripPanel.PerformLayout();
            this.toolStripContainer1.ResumeLayout(false);
            this.toolStripContainer1.PerformLayout();
            this.splitContainer1.Panel1.ResumeLayout(false);
            this.splitContainer1.Panel1.PerformLayout();
            this.splitContainer1.Panel2.ResumeLayout(false);
            this.splitContainer1.Panel2.PerformLayout();
            this.splitContainer1.ResumeLayout(false);
            this.toolStrip1.ResumeLayout(false);
            this.toolStrip1.PerformLayout();
            this.ResumeLayout(false);

        }

        private void TestExtension_SizeChanged(object sender, EventArgs e)
        {
            //splitContainer1.SplitterDistance = splitContainer1.Height - splitContainer1.Panel2MinSize - splitContainer1.SplitterWidth;
        }
        private void textBox2_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                if (this.textBox2.Text != "")
                {
                    if (pool.Contains(this.textBox2.Text))
                    {
                        int index = pool.IndexOf(this.textBox2.Text);
                        if (index != -1) pool.RemoveAt(index);
                    }
                    pool.Add(this.textBox2.Text);
                    while (pool.Count > maxpoolnum)
                    {
                        pool.RemoveRange(0, 1);
                    }
                    pooliter = pool.Count;
                }
                e.Handled = true;
                ignorefirst = true;
                if (this.textBox2.Text == "")
                {
                    this.textBox1.AppendText("\r\n");
                    this.textBox1.AppendText(currentdirectory + ">");
                }
                this.textBox1.AppendText(this.textBox2.Text);
                if (ticknum == 0)
                {
                    ProcessStateChecker.Tick += new EventHandler(ProcessStateChecker_Tick);
                    ticknum++;
                }
                if (!CheckHelp(this.textBox2.Text) && !CheckCustomCommands(this.textBox2.Text))
                {
                    p.StandardInput.Write(this.textBox2.Text);
                }
                else
                {
                    this.textBox1.AppendText("\r\n");
                    this.textBox1.AppendText(currentdirectory + ">");
                }
                p.StandardInput.Write("\r\n");
                p.StandardInput.Flush();
                this.textBox2.Text = "";
            }
            if (e.KeyChar == 3)
            {
                e.Handled = true;
                p.Close();
                this.textBox1.AppendText("\r\nProcess was killed\r\n");
                ProcessInitialize();
            }
            if (e.KeyChar == 1)
            {
                e.Handled = true;
                this.textBox2.SelectAll();
            }
        }
        private bool CheckHelp(string expression)
        {
            Match m = HelpCheckRegex.Match(expression);
            if (m.Success)
            {
                string target = m.Groups["helptarget"].Value;
                if (target == "")
                {
                    this.textBox1.AppendText("\r\n");
                    for (int i = 0; i < customs.Length; i++)
                    {
                        this.textBox1.AppendText(customs[i]);
                        this.textBox1.AppendText("         ");
                        this.textBox1.AppendText(customstext[i]);
                        this.textBox1.AppendText("\r\n");
                    }
                    this.textBox1.AppendText("==========================================================\r\n");
                    return false;
                }
                else
                {
                    int index = Array.IndexOf(customs, target);
                    if (index == -1) return false;
                    this.textBox1.AppendText("\r\n");
                    this.textBox1.AppendText(customstext[index]);
                    this.textBox1.AppendText("\r\n");
                    this.textBox1.AppendText(customshelp[index]);
                    return true;
                }
            }
            return false;
        }
        private bool CheckCustomCommands(string expression)
        {
            foreach (KeyValuePair<ExRegex, CustomCommand> kap in CustomCommands)
            {
                Match m = kap.Key.Match(expression);
                if (m.Success)
                {
                    kap.Value.Invoke(m);
                    return true;
                }
            }
            return false;
        }
        private void textBox2_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Tab)
            {
                /*e.Handled = true;
                AutoComp();*/
            }
        }
        private void AutoComp()
        {
            string st = this.textBox2.Text;
            string before = st.Substring(0, this.textBox2.SelectionStart);
            string before2 = st.Substring(0, this.textBox2.SelectionStart + this.textBox2.SelectionLength);
            int start = this.textBox2.SelectionStart;
            if (st != "")
            {
                string filename = "";
                string filename2 = "";
                string target = GetDirectory(before, out filename);
                string target2 = GetDirectory(before2, out filename2);
                string[] all = GetFilenameAndDirectory(target, filename);
                if (target == "")
                {
                    List<string> temppool = new List<string>();
                    foreach (string com in customs)
                    {
                        if (com.StartsWith(filename)) temppool.Add(com);
                    }
                    foreach (string com in all)
                    {
                        if (Array.IndexOf(customs, com) == -1) temppool.Add(com);
                    }
                    all = temppool.ToArray();
                }
                if (all.Length > 0)
                {
                    int index = Array.IndexOf(all, filename2.ToLower());
                    if (index < 0)
                    {
                        foreach (string fndir in all)
                        {
                            if (fndir.StartsWith(filename.ToLower()))
                            {
                                string after = st.Substring(this.textBox2.SelectionStart + this.textBox2.SelectionLength);
                                int filenameindex = before.LastIndexOf(filename);
                                string result = "";
                                if (filename == "")
                                {
                                    filenameindex = filenameindex + 1;
                                    result = before + fndir + after;
                                }
                                else
                                {
                                    result = before.Substring(0, filenameindex) + fndir + after;
                                }
                                this.textBox2.Text = result;
                                this.textBox2.SelectionStart = filenameindex + filename.Length;
                                this.textBox2.SelectionLength = fndir.Length - filename.Length;
                                break;
                            }
                        }
                    }
                    else
                    {
                        string fndir = index >= all.Length - 1 ? all[0] : all[index + 1];
                        string after = st.Substring(this.textBox2.SelectionStart + this.textBox2.SelectionLength);
                        int filenameindex = before.LastIndexOf(filename); string result = "";
                        if (filename == "")
                        {
                            filenameindex = filenameindex + 1;
                            result = before + fndir + after;
                        }
                        else
                        {
                            result = before.Substring(0, filenameindex) + fndir + after;
                        }
                        this.textBox2.Text = result;
                        this.textBox2.SelectionStart = filenameindex + filename.Length;
                        this.textBox2.SelectionLength = fndir.Length - filename.Length;
                    }
                }
            }
        }
        private string GetDirectory(string expression, out string filename)
        {
            string ret = "";
            filename = "";
            int start = -1, end = -1, spaceindex = -1;
            Char[] data = expression.ToCharArray();
            for (int i = data.Length - 1; i >= 0; i--)
            {
                bool issep = IsSeparateChar(data[i]);
                if (end == -1 && issep)
                {
                    end = i;
                }
                if (issep) spaceindex = -1;
                if (data[i] == '"' || data[i] == '\'')
                {
                    start = i + 1;
                    if (start >= data.Length) return "";
                    break;
                }
                if (data[i] == ' ' && spaceindex == -1) spaceindex = i;
            }
            if (end == -1)
            {
                ret = "";
                if (spaceindex != -1)
                {
                    filename = spaceindex + 1 < expression.Length ? expression.Substring(spaceindex + 1) : "";
                }
                else
                {
                    if (start != -1)
                    {
                        filename = expression.Substring(start);
                    }
                    else
                    {
                        filename = expression;
                    }
                }
                return ret;
            }
            else
            {
                filename = end + 1 < expression.Length ? expression.Substring(end + 1) : "";
            }
            if (start == -1)
            {
                filename = end + 1 < expression.Length ? expression.Substring(end + 1) : "";
                if (spaceindex != -1)
                {
                    start = spaceindex + 1;
                }
                else
                {
                    start = 0;
                }
            }
            ret = expression.Substring(start, end - start);
            return ret;
        }
        private string[] GetFilenameAndDirectory(string expression, string startfillter)
        {
            string checkdir = currentdirectory;
            bool currentcame = false;
            bool charactercame = false;
            string[] ret = new string[0];
            string[] spdata = expression.Split(new string[] { "\\", "/" }, StringSplitOptions.None);
            for (int i = 0; i < spdata.Length; i++)
            {
                if (spdata[i] == ".." && !charactercame)
                {
                    try
                    {
                        checkdir = Directory.GetParent(checkdir).FullName;
                    }
                    catch
                    {
                        return ret;
                    }
                }
                else if (spdata[i] == "." && !currentcame)
                {
                    currentcame = true;
                }
                else if (!charactercame && IsDirive(spdata[i]))
                {
                    charactercame = true;
                    checkdir = spdata[i] + "\\";
                }
                else
                {
                    charactercame = true;
                    string temp = checkdir + "\\" + spdata[i];
                    if (Directory.Exists(temp))
                    {
                        checkdir = temp;
                    }
                    else
                    {
                        return ret;
                    }
                }
            }
            string[] fns = Directory.GetFiles(checkdir);
            string[] dirs = Directory.GetDirectories(checkdir);
            List<string> templist = new List<string>(10);
            foreach (string fn in fns)
            {
                string tempst = Path.GetFileName(fn).ToLower();
                if (tempst.StartsWith(startfillter.ToLower()))
                {
                    templist.Add(tempst);
                }
            }
            foreach (string dir in dirs)
            {
                string tempst = Path.GetFileName(dir).ToLower();
                if (tempst.StartsWith(startfillter.ToLower()))
                {
                    templist.Add(tempst);
                }
            }
            ret = templist.ToArray();
            return ret;
        }
        private bool IsDirive(string str)
        {
            if (str.Length != 2) return false;
            if (str[1] != ':') return false;
            if (('A' <= str[0] && str[0] <= 'Z') || ('a' <= str[0] && str[0] <= 'z')) return true;
            return true;
        }
        private bool IsSeparateChar(Char c)
        {
            return c == '/' || c == '\\';
        }
        private string this[int n]
        {
            get
            {
                if (n < 0 || n >= pool.Count) return "";
                return pool[n];
            }
        }

        private void textBox2_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Up)
            {
                e.Handled = true;
                if (pool.Count >= 1 && pooliter > 0)
                {
                    pooliter--;
                    this.textBox2.Text = this[pooliter];
                    if (this.textBox2.Text.Length > 0)
                    {
                        this.textBox2.Select(this.textBox2.Text.Length, 0);
                    }
                    if (pooliter < 0) pooliter = 0;
                    if (pooliter >= pool.Count) pooliter = pool.Count;
                }
            }
            else if (e.KeyCode == Keys.Down)
            {
                e.Handled = true;
                if (pool.Count >= 1 && pooliter >= 0)
                {
                    pooliter++;
                    this.textBox2.Text = this[pooliter];
                    if (this.textBox2.Text.Length > 0)
                    {
                        this.textBox2.Select(this.textBox2.Text.Length, 0);
                    }
                    if (pooliter < 0) pooliter = 0;
                    if (pooliter >= pool.Count) pooliter = pool.Count;
                }
            }
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            ProcessStartInfo psi = new ProcessStartInfo();
            psi.WorkingDirectory = currentdirectory;
            psi.CreateNoWindow = false;
            psi.FileName = System.Environment.GetEnvironmentVariable("comspec");
            Process process = new Process();
            process.StartInfo = psi;
            process.Start();
        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1.SelectedPath = currentdirectory;
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                currentdirectory = folderBrowserDialog1.SelectedPath + "\\";
                p.Close();
                this.textBox1.AppendText("\r\nProcess was killed\r\n");
                ProcessInitialize();
            }
        }

        private void ConsoleExtension_BackgroundImageChanged(object sender, EventArgs e)
        {
            if (toolStrip1.Width > 0 && toolStrip1.Height > 0)
            {
                Bitmap tempbit = new Bitmap(toolStrip1.Width, toolStrip1.Height);
                Graphics g = Graphics.FromImage(tempbit);
                if (this.BackgroundImage == null)
                {
                    SolidBrush sb = new SolidBrush(this.BackColor);
                    g.FillRectangle(sb, new Rectangle(0, 0, tempbit.Width, tempbit.Height));
                    toolStrip1.BackgroundImage = tempbit;
                    sb.Dispose();
                }
                else
                {
                    g.DrawImage(this.BackgroundImage, new Rectangle(0, 0, tempbit.Width, tempbit.Height), new Rectangle(0, 0, tempbit.Width, tempbit.Height), GraphicsUnit.Pixel);
                    toolStrip1.BackgroundImage = tempbit;
                }
            }
        }
        protected override bool ProcessDialogKey(Keys keyData)
        {
            if ((keyData & Keys.KeyCode) == Keys.Tab)
            {
                AutoComp();
                return true;
            }
            return base.ProcessDialogKey(keyData);
        }
    }

    class ExRegex : Regex, IComparable<ExRegex>
    {
        public ExRegex(string pattern)
            : base(pattern)
        {
        }

        public int CompareTo(ExRegex other)
        {
            StringComparer sc = StringComparer.Create(System.Globalization.CultureInfo.CurrentCulture, false);
            return sc.Compare(this.pattern, other.pattern);
        }
    }
}
