[FORMAT "WCOFF"]
[INSTRSET "i486p"]
[BITS 32]

[FILE "funcs.nas"]

	global	_io_hlt
	global	_io_cli
	global	_io_sti
	global	_io_stihlt
	global	_io_load_eflags
	global	_io_store_eflags
	global	_load_cr0
	global	_store_cr0
	global	_load_gdtr
	global	_load_idtr
	global	_io_in8
	global	_io_in16
	global	_io_in32
	global	_io_out8
	global	_io_out16
	global	_io_out32
	global	_load_tr
	global	_farjmp
	global	_load_dr0
	global	_load_dr1
	global	_load_dr2
	global	_load_dr3
	global	_load_dr6
	global	_load_dr7
	global	_store_dr0
	global	_store_dr1
	global	_store_dr2
	global	_store_dr3
	global	_store_dr6
	global	_store_dr7
	global	_load_cs
	global	_load_eip
	global	_asm_inthandler01
	global	_asm_inthandler0d
	global	_asm_inthandler20
	global	_asm_inthandler21
	global	_asm_inthandler2c
	extern	_inthandler01
	extern	_inthandler0d
	extern	_inthandler20
	extern	_inthandler21
	extern	_inthandler2c


[SECTION .text]
_io_hlt:
	hlt
	ret

_io_cli:
	cli
	ret

_io_sti:
	sti
	ret

_io_stihlt:
	sti
	hlt
	ret

_io_load_eflags:	; uint32_t io_load_eflags(void);
	pushfd		; eflags -> stack
	pop	eax
	ret

_io_store_eflags:	; void io_store_eflags(uint32_t eflags)
	mov	eax, [esp + 4]
	push	eax
	popfd		; stack -> eflags
	ret

_load_cr0:
	mov	eax, cr0
	ret

_store_cr0:
	mov	eax, [esp + 4]
	mov	cr0, eax
	ret

_load_gdtr:		; void load_gdtr(uint32_t limit, uint32_t addr)
	mov	ax, [esp + 4]
	mov	[esp + 6], ax
	lgdt	[esp + 6]
	ret

_load_idtr:		; void load_idtr(uint32_t limit, uint32_t addr)
	mov	ax, [esp + 4]
	mov	[esp + 6], ax
	lidt	[esp + 6]
	ret

_io_in8:		; uint32_t io_int8(uint32_t port)
	mov	edx, [esp + 4]
	mov	eax, 0
	in	al, dx
	ret

_io_in16:		; uint32_t io_int16(uint32_t port)
	mov	edx, [esp + 4]
	mov	eax, 0
	in	ax, dx
	ret

_io_in32:		; uint32_t io_int32(uint32_t port)
	mov	edx, [esp + 4]
	in	eax, dx
	ret

_io_out8:		; void io_out8(uint32_t port, uint32_t data)
	mov	edx, [esp + 4]
	mov	al, [esp + 8]
	out	dx, al
	ret

_io_out16:		; void io_out16(uint32_t port, uint32_t data)
	mov	edx, [esp + 4]
	mov	ax, [esp + 8]
	out	dx, ax
	ret

_io_out32:		; void io_out32(uint32_t port, uint32_t data)
	mov	edx, [esp + 4]
	mov	eax, [esp + 8]
	out	dx, eax
	ret

_load_tr:		; void load_tr(uint32_t tr)
	ltr	[esp + 4]
	ret

_farjmp:		; void farjmp(uint32_t eip, uint32_t cs)
	jmp	far [esp + 4]
	ret

_load_dr0:	; uint32_t load_dr0()
	mov	eax, dr0
	ret

_load_dr1:	; uint32_t load_dr1()
	mov	eax, dr1
	ret

_load_dr2:	; uint32_t load_dr2()
	mov	eax, dr2
	ret

_load_dr3:	; uint32_t load_dr3()
	mov	eax, dr3
	ret

_load_dr6:	; uint32_t load_dr6()
	mov	eax, dr6
	ret

_load_dr7:	; uint32_t load_dr7()
	mov	eax, dr7
	ret

_store_dr0:	; void store_dr0(uint32_t dr0)
	mov	eax, [esp + 4]
	mov	dr0, eax
	ret

_store_dr1:	; void store_dr1(uint32_t dr1)
	mov	eax, [esp + 4]
	mov	dr1, eax
	ret

_store_dr2:	; void store_dr2(uint32_t dr2)
	mov	eax, [esp + 4]
	mov	dr2, eax
	ret

_store_dr3:	; void store_dr3(uint32_t dr3)
	mov	eax, [esp + 4]
	mov	dr3, eax
	ret

_store_dr6:	; void store_dr6(uint32_t dr6)
	mov	eax, [esp + 4]
	mov	dr6, eax
	ret

_store_dr7:	; void store_dr7(uint32_t dr7)
	mov	eax, [esp + 4]
	mov	dr7, eax
	ret

_load_cs:	; uint32_t load_cs()
	mov	eax, 0
	mov	ax, cs
	ret

_load_eip:	; uint32_t load_eip()
	mov	eax, [esp]
	ret

_asm_inthandler01:	; asm_inthandler01()
	push	es
	push	ds
	pushad
	mov	eax, esp
	push	eax
	mov	ax, ss
	mov	ds, ax
	mov	es, ax
	call	_inthandler01
	pop	eax
	popad
	pop	ds
	pop	es
	iretd

_asm_inthandler0d:	; asm_inthandler0d()
	push	es
	push	ds
	pushad
	mov	eax, esp
	push	eax
	mov	ax, ss
	mov	ds, ax
	mov	es, ax
	call	_inthandler0d
	pop	eax
	popad
	pop	ds
	pop	es
	iretd

_asm_inthandler20:	; asm_inthandler20()
	push	es
	push	ds
	pushad
	mov	eax, esp
	push	eax
	mov	ax, ss
	mov	ds, ax
	mov	es, ax
	call	_inthandler20
	pop	eax
	popad
	pop	ds
	pop	es
	iretd

_asm_inthandler21:	; asm_inthandler21()
	push	es
	push	ds
	pushad
	mov	eax, esp
	push	eax
	mov	ax, ss
	mov	ds, ax
	mov	es, ax
	call	_inthandler21
	pop	eax
	popad
	pop	ds
	pop	es
	iretd

_asm_inthandler2c:	; asm_inthandler2c()
	push	es
	push	ds
	pushad
	mov	eax, esp
	push	eax
	mov	ax, ss
	mov	ds, ax
	mov	es, ax
	call	_inthandler2c
	pop	eax
	popad
	pop	ds
	pop	es
	iretd
