using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using pcmp.Setting;

namespace pcmp
{
    public class ThreadGetIndexText
    {
        AutoResetEvent[] autoEvents;

        public string GetIndexTextResult(YpSetting[] yparray)
        {
            if (yparray == null || yparray.Length == 0) return string.Empty;

            autoEvents = new AutoResetEvent[yparray.Length];
            for (int i = 0; i < autoEvents.Length; i++)
                autoEvents[i] = new AutoResetEvent(false);

            for (int i = 0; i < yparray.Length; i++)
            {
                Object[] info = { yparray[i], i };
                ThreadPool.QueueUserWorkItem(new WaitCallback(GetChannel), info);
            }

            WaitHandle.WaitAll(autoEvents);

            string msg = string.Empty;
            foreach (YpSetting yp in yparray)
            {
                if (!yp.GetError)
                {
                    msg += string.Format("{0}({1})", yp.YpName, yp.GetFromPCRaw ? "PCRAW" : "HTTP");
                }
                else
                {
                    msg += yp.YpName + "(G[)";
                }

                msg += "\r\n";
            }

            return msg;
        }

        void GetChannel(Object startInfo)
        {
            Object[] info = startInfo as Object[];
            YpSetting Yp = info[0] as YpSetting;
            int index = (int)info[1];

            if (!Yp.EnableYP)
            {
                autoEvents[index].Set();
                return;
            }

            Yp.GetIndexText();

            autoEvents[index].Set();
        }
    }
}
