using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;
using System.Runtime.Serialization;

namespace pcmp.Setting
{
    [Serializable()]
    public class NetworkSetting : SerializableSetting
    {
        public NetworkSetting() { }

        public NetworkSetting(SerializationInfo info, StreamingContext context)
        {
            Serializer.Deserialize(this, info);
        }

        public string HostAddr = "localhost:7144";
        public int TimeOut = 30000;
        public int HttpProtocol = 0;
        public bool UseProxy = false;
        public bool UseIEProxy = false;
        public string ProxyAddr = "localhost:8080";
    }

    [Serializable()]
    public class GeneralSetting : SerializableSetting, ICloneable
    {
        const string fileName = "GeneralSetting.xml";

        public GeneralSetting() { }

        public GeneralSetting(SerializationInfo info, StreamingContext context)
        {
            Serializer.Deserialize(this, info);
        }

        public void Save()
        {
            Serializer.Serialize(fileName, this, true);
        }

        public static GeneralSetting Load()
        {
            return Serializer.Deserialize(fileName, typeof(GeneralSetting)) as GeneralSetting;
        }

        #region ICloneable o

        public object Clone()
        {
            return MemberwiseClone();
        }

        #endregion

        public string PeerCastPath = @"C:\Program Files\PeerCast\PeerCast.exe";
        public bool UseOtherBrowser = false;
        public string BrowserPath = string.Empty;
        public bool RunAsMinimize = false;
        public bool RunPeerCastOnStartup = false;
        public bool ShowGridLine = false;
        public bool ShowYpBalloon = true;
        public bool UseMultiOption = false;
        public string TemplatePath = string.Empty;
        public bool ShowNewBalloon = true;
        public bool ShowFavoriteBalloon = true;
        public bool ShowListViewTooltip = true;
        public bool ShowExitDialog = true;
        public Color ListViewBack = Color.FromKnownColor(KnownColor.Window);
        public Color ListViewGrid = Color.FromKnownColor(KnownColor.ControlDark);
        public bool ClosePeerCastOnExit = false;
        public bool UseBrowser2ch = false;
        public string Browser2chPath = string.Empty;
        public bool HideOnMinimize = true;
        public bool SingleClickToReturn = false;
        public string Regex2chUrl = "2ch\\.net";
        public bool GetYpOnStartup = false;
        public bool FrozenAtChannelName = true;
        public int ProcessPriority = 2; // Normal
        public NetworkSetting NetworkSetting = new NetworkSetting();
        public bool ChangeProcessPriority;
        public bool DoNotShowErrorChannel;

        [NonSerialized]
        public string TemplateHtmlPath = string.Empty;
    }

    [Serializable()]
    public class ApplicationSetting : SerializableSetting
    {
        const string fileName = "Application.xml";

        public ApplicationSetting() { }

        public ApplicationSetting(SerializationInfo info, StreamingContext context)
        {
            Serializer.Deserialize(this, info);
        }

        public void Save()
        {
            Serializer.Serialize(fileName, this, true);
        }

        public static ApplicationSetting Load()
        {
            return (ApplicationSetting)Serializer.Deserialize("Application.xml", typeof(ApplicationSetting));
        }

        public int WindowPosX;
        public int WindowPosY;
        public int WindowHeight;
        public int WindowWidth;
        public FormWindowState WindowState;
        public DockState DockState = DockState.DockBottom;
        public double DockTopPortion = 0.25;
        public double DockBottomPortion = 0.25;
        public double DockRightPortion = 0.25;
        public double DockLeftPortion = 0.25;
        public ColumnSetting[] Columns;
    }

    [Serializable]
    public class ColumnSetting : SerializableSetting
    {
        public ColumnSetting() { }

        public ColumnSetting(SerializationInfo info, StreamingContext context)
        {
            Serializer.Deserialize(this, info);
        }

        public int Width;
        public bool Visible;
        public string DisplayText;
        public int DisplayIndex;
    }
}
