using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Xml.Serialization;
using System.Runtime.Serialization;

namespace pcmp.Setting
{
    [Serializable()]
    public class FavSetting : SerializableSetting, ICloneable
    {
        const string fileName = "Favorites.xml";

        public FavSetting() { }
        public FavSetting(SerializationInfo info, StreamingContext context)
        {
            Serializer.Deserialize(this, info);
        }

        public static void Save(FavSetting[] target)
        {
            Serializer.Serialize(fileName, target, true);
        }

        public static FavSetting[] Load()
        {
            FavSetting[] obj =
                Serializer.Deserialize(fileName, typeof(FavSetting[])) as FavSetting[];
            return obj;
        }

        #region ICloneable o

        public object Clone()
        {
            return MemberwiseClone();
        }

        #endregion

        public bool Enable = true;
        public bool ShowBalloon = true;
        public string Name = string.Empty;
        public string SearchString = string.Empty;
        public bool SearchChannelName = true;
        public bool SearchDetail /* = false*/;
        public bool SearchContactUrl /* = false*/;
        public bool SearchYelloPageUrl /* = false*/;
        public bool SearchComment /* = false*/;
        public bool SerachAfterConcat /* = false*/;
        public bool UseRegex /* = false*/;
        public Color TextColor;
        public Color BackColor;
        public Font Font;
        public string SoundPath = string.Empty;
        public bool UseColorSetting;
    }

    [Serializable()]
    public class NGSetting : ICloneable
    {
        const string fileName = "NG.xml";

        public static void Save(NGSetting[] target)
        {
            Serializer.Serialize(fileName, target, true);
        }

        public static NGSetting[] Load()
        {
            NGSetting[] obj =
                Serializer.Deserialize(fileName, typeof(NGSetting[])) as NGSetting[];
            return obj;
        }

        #region ICloneable o

        public object Clone()
        {
            return MemberwiseClone();
        }

        #endregion

        public bool Enable = true;
        public string Name = string.Empty;
        public string SearchString = string.Empty;
        public bool SearchChannelName = true;
        public bool SearchDetail /* = false*/;
        public bool SearchContactUrl /* = false*/;
        public bool SearchYelloPageUrl /* = false*/;
        public bool SearchComment /* = false*/;
        public bool SerachAfterConcat /* = false*/;
        public bool UseRegex;
    }

    public enum MatchStatus
    {
        Favorite,
        NG,
        None
    }
}
