using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using pcmp.Setting;
using System.Windows.Forms.ColorPicker;

namespace pcmp.Forms
{
    public partial class FormYpSetting : Form
    {
        List<YpSetting> yplist = new List<YpSetting>();
        int selectedIndex = 0;
        ColorPicker picker = null;
        int clickedSetColorButton;

        public FormYpSetting()
        {
            InitializeComponent();

            if (Settings.YpSettings != null)
            {
                yplist = new List<YpSetting>(Settings.YpSettings);
            }
            picker = new ColorPicker();
            picker.ColorSelected += new ColorSelectedEventHandler(picker_ColorSelected);
            ListYelloPages();
            SetValueToGUI(yplist[0]);
            listBoxPageList.SelectedIndex = 0;
        }

        void picker_ColorSelected(object sender, ColorSelectedEventArgs e)
        {
            switch (clickedSetColorButton)
            {
                case 1:
                    for (int i = 0; i < listView1.Items.Count; i++)
                    {
                        for (int j = 0; j < listView1.Items[i].SubItems.Count; j++)
                        {
                            listView1.Items[i].SubItems[j].ForeColor = e.ColorSelected;
                        }
                    }
                    break;
                case 2:
                    for (int i = 0; i < listView1.Items.Count; i++)
                    {
                        for (int j = 0; j < listView1.Items[i].SubItems.Count; j++)
                        {
                            listView1.Items[i].SubItems[j].BackColor = e.ColorSelected;
                        }
                    }
                    break;
                case 3:
                    listView1.Items[1].SubItems[2].ForeColor = e.ColorSelected;
                    break;
                case 4:
                    listView1.Items[2].SubItems[3].ForeColor = e.ColorSelected;
                    break;
            }
        }

        private void ListYelloPages()
        {
            if (yplist.Count == 0)
            {
                YpSetting yps = new YpSetting();
                yps.YpName = "YP";
                yps.YpAddr = "http://yp.peercast.org/";
                yplist.Add(yps);
                listBoxPageList.Items.Add(yps.YpName);
            }
            else
            {
                foreach (YpSetting yps in yplist)
                {
                    listBoxPageList.Items.Add(yps.YpName);
                }
            }
        }

        private void SetValueToSetting(int index)
        {
            if (yplist.Count == 0) return;
            yplist[index].EnableYP = checkBoxEnableYp.Checked;
            yplist[index].YpName = textBoxYelloPageName.Text;
            yplist[index].YpAddr = textBoxYelloPageAddr.Text;
            yplist[index].TextColor = listView1.Items[0].ForeColor;
            yplist[index].BackColor = listView1.Items[0].BackColor;
            yplist[index].Font = listView1.Items[0].Font;
            yplist[index].ContactColor = listView1.Items[1].SubItems[2].ForeColor;
            yplist[index].ContactFontStyle = listView1.Items[1].SubItems[2].Font.Style;
            yplist[index].DirectColor = listView1.Items[2].SubItems[3].ForeColor;
            yplist[index].DirectFontStyle = listView1.Items[2].SubItems[3].Font.Style;
            yplist[index].ShowNewBalloon = checkBoxShowBalloon.Checked;
            yplist[index].UseEncoding = checkBoxSpecifyEncoding.Checked;
            yplist[index].Encoding = comboBoxEncoding.Text;
            yplist[index].YpNamespace = textBoxNamespace.Text;
            yplist[index].UseBandwidthTool = checkBox1.Checked;
            yplist[index].BandwidthToolArg = textBoxArg.Text;
            yplist[index].BandwidthToolPath = textBoxCheckBandwidth.Text;
            yplist[index].UseScript = checkBoxUseScript.Checked;
            yplist[index].ScriptPath = textBoxScriptPath.Text;
        }

        private void SetValueToGUI(YpSetting yps)
        {
            checkBoxEnableYp.Checked = yps.EnableYP;
            textBoxYelloPageName.Text = yps.YpName;
            textBoxYelloPageAddr.Text = yps.YpAddr;
            textBoxNamespace.Text = yps.YpNamespace;

            checkBoxContactBold.Checked = ((yps.ContactFontStyle & FontStyle.Bold) == FontStyle.Bold);
            checkBoxContactItalic.Checked = ((yps.ContactFontStyle & FontStyle.Italic) == FontStyle.Italic);
            checkBoxContactStrike.Checked = ((yps.ContactFontStyle & FontStyle.Strikeout) == FontStyle.Strikeout);
            checkBoxContactULine.Checked = ((yps.ContactFontStyle & FontStyle.Underline) == FontStyle.Underline);
            checkBoxDirectBold.Checked = ((yps.DirectFontStyle & FontStyle.Bold) == FontStyle.Bold);
            checkBoxDirectItalic.Checked = ((yps.DirectFontStyle & FontStyle.Italic) == FontStyle.Italic);
            checkBoxDirectStrike.Checked = ((yps.DirectFontStyle & FontStyle.Strikeout) == FontStyle.Strikeout);
            checkBoxDirectULine.Checked = ((yps.DirectFontStyle & FontStyle.Underline) == FontStyle.Underline);
            checkBoxShowBalloon.Checked = yps.ShowNewBalloon;
            checkBoxSpecifyEncoding.Checked = yps.UseEncoding;
            comboBoxEncoding.Text = yps.Encoding;
            for (int i = 0; i < listView1.Items.Count; i++)
            {
                listView1.Items[i].Font = yps.Font;
                for (int j = 0; j < listView1.Items[i].SubItems.Count; j++)
                {
                    listView1.Items[i].SubItems[j].ForeColor = yps.TextColor;
                    listView1.Items[i].SubItems[j].BackColor = yps.BackColor;
                }
            }
            if (yps.Font != null)
            {
                listView1.Items[1].SubItems[2].Font =
                    new Font(yps.Font, yps.ContactFontStyle);
                listView1.Items[2].SubItems[3].Font =
                    new Font(yps.Font, yps.DirectFontStyle);
            }
            listView1.Items[1].SubItems[2].ForeColor = yps.ContactColor;
            listView1.Items[2].SubItems[3].ForeColor = yps.DirectColor;
            textBoxScriptPath.Text = yps.ScriptPath;
            checkBoxUseScript.Checked = yps.UseScript;
        }

        private void listBoxPageList_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listBoxPageList.SelectedIndex == -1) return;
            SetValueToSetting(selectedIndex);
            YpSetting yps = yplist[listBoxPageList.SelectedIndex];
            SetValueToGUI(yps);
            selectedIndex = listBoxPageList.SelectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == 0) buttonYpUp.Enabled = false;
            else buttonYpUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == yplist.Count - 1) buttonYpDown.Enabled = false;
            else buttonYpDown.Enabled = true;
        }

        private void buttonAddYP_Click(object sender, EventArgs e)
        {
            YpSetting yps = new YpSetting();
            yps.YpName = "VKYP";
            yplist.Add(yps);
            listBoxPageList.Items.Add(yps.YpName);
            if (listBoxPageList.Items.Count == 1)
            {
                SetValueToGUI(yps);
                listBoxPageList.SelectedIndex = 0;
            }
            else
            {
                listBoxPageList.SelectedIndex = listBoxPageList.Items.Count - 1;
            }
            buttonRemoveYP.Enabled = true;
        }

        private void buttonRemoveYP_Click(object sender, EventArgs e)
        {
            if (listBoxPageList.SelectedIndex != -1)
            {
                yplist.RemoveAt(listBoxPageList.SelectedIndex);
                listBoxPageList.Items.RemoveAt(listBoxPageList.SelectedIndex);
                if (selectedIndex == 0)
                {
                    if (listBoxPageList.Items.Count != 0)
                    {
                        SetValueToGUI(yplist[0]);
                        selectedIndex = 0;
                        listBoxPageList.SelectedIndex = 0;
                    }
                }
                else if (listBoxPageList.Items.Count != 0)
                {
                    SetValueToGUI(yplist[selectedIndex - 1]);
                    selectedIndex -= 1;
                    listBoxPageList.SelectedIndex = selectedIndex;
                }

                if (listBoxPageList.Items.Count == 0)
                {
                    buttonRemoveYP.Enabled = false;
                }
            }
        }

        private void buttonYpUp_Click(object sender, EventArgs e)
        {
            listBoxPageList.SelectedIndexChanged -= new EventHandler(listBoxPageList_SelectedIndexChanged);
            // ݂̒lۑ
            SetValueToSetting(selectedIndex);
            // ɂACeޔ
            YpSetting ypPrev = (YpSetting)yplist[selectedIndex - 1].Clone();
            //@̃CfbNXɑ
            yplist[selectedIndex - 1] = (YpSetting)yplist[selectedIndex].Clone();
            listBoxPageList.Items[selectedIndex - 1] = yplist[selectedIndex - 1].YpName;
            yplist[selectedIndex] = ypPrev;
            listBoxPageList.Items[selectedIndex] = yplist[selectedIndex].YpName;
            selectedIndex--;
            // ListBox̃CfbNX
            listBoxPageList.SelectedIndex = selectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == 0) buttonYpUp.Enabled = false;
            else buttonYpUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == yplist.Count - 1) buttonYpDown.Enabled = false;
            else buttonYpDown.Enabled = true;

            listBoxPageList.SelectedIndexChanged += new EventHandler(listBoxPageList_SelectedIndexChanged);
        }

        private void buttonYpDown_Click(object sender, EventArgs e)
        {
            listBoxPageList.SelectedIndexChanged -= new EventHandler(listBoxPageList_SelectedIndexChanged);

            // ݂̒lۑ
            SetValueToSetting(selectedIndex);
            // ɂACeޔ
            YpSetting ypPrev = (YpSetting)yplist[selectedIndex + 1].Clone();
            //@̃CfbNXɑ
            yplist[selectedIndex + 1] = (YpSetting)yplist[selectedIndex].Clone();
            listBoxPageList.Items[selectedIndex + 1] = yplist[selectedIndex + 1].YpName;
            yplist[selectedIndex] = ypPrev;
            listBoxPageList.Items[selectedIndex] = yplist[selectedIndex].YpName;
            selectedIndex++;
            // ListBox̃CfbNXグ
            listBoxPageList.SelectedIndex = selectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == 0) buttonYpUp.Enabled = false;
            else buttonYpUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxPageList.SelectedIndex == yplist.Count - 1) buttonYpDown.Enabled = false;
            else buttonYpDown.Enabled = true;

            listBoxPageList.SelectedIndexChanged += new EventHandler(listBoxPageList_SelectedIndexChanged);
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            Save();
            DialogResult = DialogResult.OK;
            Close();
        }

        private void Save()
        {
            SetValueToSetting(listBoxPageList.SelectedIndex);
            YpSetting.Save(yplist.ToArray());
            Settings.YpSettings = yplist.ToArray();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void buttonPCYPTextColor_Click(object sender, EventArgs e)
        {
            Button btn_sender = (Button)sender;
            picker.Color = listView1.Items[0].SubItems[0].ForeColor;
            picker.Location = btn_sender.Parent.PointToScreen(new Point(btn_sender.Right, btn_sender.Top));
            clickedSetColorButton = 1;
            if (!picker.Visible)
                picker.Show();
        }

        private void buttonPCYPBackColor_Click(object sender, EventArgs e)
        {
            Button btn_sender = (Button)sender;
            picker.Color = listView1.Items[0].SubItems[0].BackColor;
            picker.Location = btn_sender.Parent.PointToScreen(new Point(btn_sender.Right, btn_sender.Top));
            clickedSetColorButton = 2;
            if (!picker.Visible)
                picker.Show();
        }

        private void buttonPCYPFont_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = yplist[selectedIndex].Font;
            if (fontDialog1.ShowDialog() == DialogResult.OK)
            {
                for (int i = 0; i < listView1.Items.Count; i++)
                {
                    listView1.Items[i].Font = fontDialog1.Font;
                }

                SetValueToSetting(listBoxPageList.SelectedIndex);
            }
        }

        private void buttonContactColor_Click(object sender, EventArgs e)
        {
            Button btn_sender = (Button)sender;
            picker.Color = listView1.Items[1].SubItems[2].ForeColor;
            picker.Location = btn_sender.Parent.PointToScreen(new Point(btn_sender.Right, btn_sender.Top));
            clickedSetColorButton = 3;
            if (!picker.Visible)
                picker.Show();
        }

        private void buttonDirectColor_Click(object sender, EventArgs e)
        {
            Button btn_sender = (Button)sender;
            picker.Color = listView1.Items[2].SubItems[3].ForeColor;
            picker.Location = btn_sender.Parent.PointToScreen(new Point(btn_sender.Right, btn_sender.Top));
            clickedSetColorButton = 4;
            if (!picker.Visible)
                picker.Show();
        }

        private void checkBoxContactBold_CheckedChanged(object sender, EventArgs e)
        {
            int fontStyleContact = 0;
            if (checkBoxContactBold.Checked) fontStyleContact += 1;
            if (checkBoxContactItalic.Checked) fontStyleContact += 2;
            if (checkBoxContactStrike.Checked) fontStyleContact += 8;
            if (checkBoxContactULine.Checked) fontStyleContact += 4;

            listView1.Items[1].SubItems[2].Font =
                new Font(listView1.Items[1].Font, (FontStyle)fontStyleContact);
            listView1.Refresh();
        }

        private void checkBoxDirectBold_CheckedChanged(object sender, EventArgs e)
        {
            int fontStyleDirect = 0;
            if (checkBoxDirectBold.Checked) fontStyleDirect += 1;
            if (checkBoxDirectItalic.Checked) fontStyleDirect += 2;
            if (checkBoxDirectStrike.Checked) fontStyleDirect += 8;
            if (checkBoxDirectULine.Checked) fontStyleDirect += 4;

            listView1.Items[2].SubItems[3].Font =
                new Font(listView1.Items[2].Font, (FontStyle)fontStyleDirect);
        }

        private void checkBoxSpecifyEncoding_CheckedChanged(object sender, EventArgs e)
        {
            comboBoxEncoding.Enabled = checkBoxSpecifyEncoding.Checked;
        }

        private void textBoxYelloPageName_KeyUp(object sender, KeyEventArgs e)
        {
            if (listBoxPageList.Items.Count == 0) return;
            listBoxPageList.Items[listBoxPageList.SelectedIndex]
                = textBoxYelloPageName.Text;
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            textBoxCheckBandwidth.Enabled = textBoxArg.Enabled = buttonRefFile.Enabled = checkBox1.Checked;
        }

        private void buttonRefFile_Click(object sender, EventArgs e)
        {
            var openfiledlg = new OpenFileDialog();
            openfiledlg.Title = "t@CJ";
            openfiledlg.DefaultExt = "*.exe";
            openfiledlg.Filter = "s\t@C (*.exe)|*.exe|ׂẴt@C (*.*)|*.*";
            if (textBoxCheckBandwidth.Text.Length != 0)
                openfiledlg.InitialDirectory = textBoxCheckBandwidth.Text;
            else openfiledlg.InitialDirectory = Application.StartupPath;

            if (openfiledlg.ShowDialog() == DialogResult.OK)
            {
                textBoxCheckBandwidth.Text = openfiledlg.FileName;
            }

            openfiledlg.Dispose();
        }

        private void checkBoxUseScript_CheckedChanged(object sender, EventArgs e)
        {
            textBoxScriptPath.Enabled = buttonRefScript.Enabled = checkBoxUseScript.Checked;
        }

        private void buttonRefScript_Click(object sender, EventArgs e)
        {
            OpenFileDialog opd = new OpenFileDialog() { DefaultExt = "*.py", Filter = "Python Script(*.py)|*.py|ׂẴt@C(*.*)|*.*", Title = "t@CJ" };
            if (opd.ShowDialog() == DialogResult.OK)
            {
                textBoxScriptPath.Text = opd.FileName;
            }
            opd.Dispose();
        }
    }
}