using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;
using pcmp.Setting;
using GrayIris.Utilities.UI.Controls;
using System.Threading;

namespace pcmp.Forms
{
    public partial class FormYpInfo : DockContent
    {
        Thread checkPCRawThread = null;
        bool stopthread = false;
        public event EventHandler RefreshIndexTxtStream;

        public FormYpInfo()
        {
            Application.Idle += new EventHandler(Application_Idle);
            // InitializeComponent();
            this.Text = "YP";
        }

        void Application_Idle(object sender, EventArgs e)
        {
            Application.Idle -= new EventHandler(Application_Idle);

            InitializeComponent();
            RefreshYpTabs();
            CreateCheckPCRawThread();
        }

        public void RefreshYpTabs()
        {
            tabControl.Controls.Clear();
            if (Settings.YpSettings == null) return;

            for (int i = 0; i < Settings.YpSettings.Length; i++)
            {
                YpSetting yps = Settings.YpSettings[i];
                YaTabPage tp = new YaTabPage();
                tp.Text = yps.YpName;
                tabControl.Controls.Add(tp);
            }

            tabControl.SelectedIndex = 0;
        }

        public void RefreshDisplayValue()
        {
            YpSetting yps = Settings.YpSettings[tabControl.SelectedIndex];
            textBoxName.Text = yps.YpName;
            textBoxEnable.Text = yps.EnableYP ? "L" : "";
            textBoxAddr.Text = yps.YpAddr;
            textBoxNamespace.Text = yps.YpNamespace;
            textBoxEncoding.Text = string.IsNullOrEmpty(yps.Encoding) ? "UTF-8" : yps.Encoding;
            if (yps.LastHttpStatus != null)
            {
                textBoxHttpCode.Text = yps.LastHttpStatus.StatusCode;
                textBoxHttpStatus.Text = yps.LastHttpStatus.StatusDesc;
            }
            DateTime t = PCRaw.t_timeToDateTime(yps.LastUpdate);
            textBoxLastupdate.Text = yps.LastUpdate == 0 ?
                "-" :
                PCRaw.t_timeToDateTime(yps.LastUpdate).ToLocalTime().ToString("HH:mm:ss");
            textBoxEnableIndexTextStream.Text = yps.HaveIndexTextStream ? "L" : "";
            textBoxIndexTextChannelName.Text = yps.IndexTextChannelName;
            textBoxIndexTextStreamAddr.Text = yps.IndexTextStreamUrl;
            textBoxIndexTextStreamUpdateTime.Text = yps.PCRawLastUpdate == 0 ?
                "-" :
                PCRaw.t_timeToDateTime(yps.PCRawLastUpdate).ToLocalTime().ToString("HH:mm:ss");
            if (yps.HaveIndexTextStream)
            {
                if (yps.GetIndexTextNextStreamRef)
                    buttonAutoRefIndexTxt.Enabled = false;
                else
                    buttonAutoRefIndexTxt.Enabled = true;
            }
            else buttonAutoRefIndexTxt.Enabled = false;
        }

        private void tabControl_TabChanged(object sender, EventArgs e)
        {
            RefreshDisplayValue();
        }

        private void FormYpInfo_Load(object sender, EventArgs e)
        {
            // RefreshYpTabs();
        }

        private void CompleteCheckPCRaw()
        {
            RefreshDisplayValue();
        }

        public void CreateCheckPCRawThread()
        {
            stopthread = false;
            checkPCRawThread = new Thread(CheckPCRaw);
            checkPCRawThread.IsBackground = true;
            checkPCRawThread.Start();
        }

        public void StopCheckPCRawThread()
        {
            stopthread = true;
            checkPCRawThread.Abort();
            checkPCRawThread = null;
            Settings.YpSettings[tabControl.SelectedIndex].GetIndexTextNextStreamRef = false;
            buttonAutoRefIndexTxt.Enabled = true;
        }

        private void CheckPCRaw()
        {
            List<YpSetting> yps = new List<YpSetting>();
            while (!stopthread)
            {
                yps.Clear();
                try
                {
                    for (int i = 0; i < Settings.YpSettings.Length; i++)
                    {
                        YpSetting yp = Settings.YpSettings[i];
                        if (!yp.HaveIndexTextStream) continue;
                        if (yp.CheckIndexTextStream() && yp.GetIndexTextNextStreamRef)
                        {
                            yp.GetIndexTextNextStreamRef = false;
                            yp.Source = IndexTextSource.PCRaw;
                            yps.Add(yp);
                        }
                    }
                }
                catch { }
                if (yps.Count > 0)
                {
                    RefreshIndexTxtStream(yps.ToArray(), null);
                    this.Invoke(new MethodInvoker(CompleteCheckPCRaw));
                }

                Thread.Sleep(5000);
            }
        }

        private void FormYpInfo_FormClosing(object sender, FormClosingEventArgs e)
        {
            stopthread = true;
            checkPCRawThread.Abort();
        }

        private void buttonAutoRefIndexTxt_Click(object sender, EventArgs e)
        {
            Settings.YpSettings[tabControl.SelectedIndex].GetIndexTextNextStreamRef = true;
            buttonAutoRefIndexTxt.Enabled = false;
        }

        internal void ApplySetting()
        {
            RefreshYpTabs();
        }
    }
}