using System;
using System.Collections.Generic;
using System.Windows.Forms;
using pcmp.Setting;

namespace pcmp.Forms
{
    public partial class FormToolSetting : Form
    {
        List<ToolSetting> toolList;
        int prevIndex = 0;
        string[] typelist = { "s\t@C", "PythonXNvg" };

        public FormToolSetting()
        {
            InitializeComponent();

            ToolSetting[] toolItems = ToolSetting.Load();
            if (toolItems != null) toolList = new List<ToolSetting>(toolItems);
            ListTools();
        }

        #region \bh

        private void ListTools()
        {
            if (toolList == null) return;

            listViewTools.Items.Clear();
            foreach (ToolSetting tool in toolList)
            {
                ListViewItem item = CreateListViewItem(tool);
                listViewTools.Items.Add(item);
            }
        }

        private void Save()
        {
            toolList = new List<ToolSetting>();
            foreach (ListViewItem item in listViewTools.Items)
            {
                ToolSetting ts = new ToolSetting();
                ts.Name = item.SubItems[1].Text;
                ts.Path = item.SubItems[2].Text;
                ts.Argument = item.SubItems[3].Text;
                switch (item.SubItems[4].Text)
                {
                    case "s\t@C": ts.Type = 0; break;
                    case "PythonXNvg": ts.Type = 1; break;
                }
                toolList.Add(ts);
            }

            ToolSetting.Save(toolList.ToArray());
        }

        private ListViewItem CreateListViewItem(ToolSetting ts)
        {
            ListViewItem item = new ListViewItem();
            item.SubItems.Add(ts.Name);
            item.SubItems.Add(ts.Path);
            item.SubItems.Add(ts.Argument);
            item.SubItems.Add(typelist[ts.Type]);
            return item;
        }
        #endregion

        #region Cxg

        private void buttonOK_Click(object sender, EventArgs e)
        {
            Save();
            DialogResult = DialogResult.OK;
            Close();
        }

        private void buttonAddType_Click(object sender, EventArgs e)
        {
            ToolSetting ts = new ToolSetting();
            ts.Name = "VKc[";
            listViewTools.Items.Add(CreateListViewItem(ts));
        }

        private void buttonRemoveType_Click(object sender, EventArgs e)
        {
            if (listViewTools.SelectedItems != null)
                listViewTools.Items.RemoveAt(listViewTools.SelectedIndices[0]);
            buttonApply.Enabled = false;
        }

        private void listViewTools_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listViewTools.SelectedItems == null || listViewTools.SelectedItems.Count == 0)
                return;

            ListViewItem item = listViewTools.SelectedItems[0];
            buttonRemoveType.Enabled = true;
            textBoxName.Text = item.SubItems[1].Text;
            textBoxToolPath.Text = item.SubItems[2].Text;
            comboBoxArg.Text = item.SubItems[3].Text;
            comboBoxType.Text = item.SubItems[4].Text;
            buttonApply.Enabled = true;

            prevIndex = listViewTools.SelectedIndices[0];
        }

        private void buttonApply_Click(object sender, EventArgs e)
        {
            if (listViewTools.SelectedItems == null || listViewTools.SelectedItems.Count == 0)
                return;

            listViewTools.SelectedItems[0].SubItems[1].Text = textBoxName.Text;
            listViewTools.SelectedItems[0].SubItems[2].Text = textBoxToolPath.Text;
            listViewTools.SelectedItems[0].SubItems[3].Text = comboBoxArg.Text;
            listViewTools.SelectedItems[0].SubItems[4].Text = comboBoxType.Text;
        }

        private void buttonFileRef_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBoxToolPath.Text = openFileDialog1.FileName;
            }
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            Close();
        }

        #endregion

        private void comboBoxType_SelectedIndexChanged(object sender, EventArgs e)
        {
            comboBoxArg.Enabled = comboBoxType.SelectedIndex == 0;
        }
    }
}