using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using pcmp.Setting;

namespace pcmp.Forms
{
    public partial class FormTabSetting : Form
    {
        List<TabSetting> fsList = new List<TabSetting>();
        int selectedIndex = 0;

        public FormTabSetting()
        {
            InitializeComponent();
        }

        private void SetValueToUI(TabSetting tabSetting)
        {
            textBoxName.Text = tabSetting.Name;
            textBoxCondition.Text = tabSetting.Condition;

            checkBoxChannelName.Checked = tabSetting.CheckChannel;
            checkBoxComment.Checked = tabSetting.CheckComment;
            checkBoxContactUrl.Checked = tabSetting.CheckContact;
            checkBoxEnable.Checked = tabSetting.Enable;
            checkBoxGenre.Checked = tabSetting.CheckGenre;
            checkBoxPlaying.Checked = tabSetting.CheckPlaying;
            checkBoxType.Checked = tabSetting.CheckType;

            checkBoxUseRegEx.Checked = tabSetting.UseRegex;
            checkBoxIgnoreCase.Checked = tabSetting.IgnoreCase;
            checkBoxConcatString.Checked = tabSetting.ConcatAllStrings;

            comboBoxChannelType.SelectedIndex = tabSetting.ChannelType;
            textBoxBitrate.Text = tabSetting.Bitrate;

            listViewSelectYP.Items.Clear();
            if (Settings.YpSettings != null)
            {
                foreach (YpSetting yp in Settings.YpSettings)
                {
                    ListViewItem i = new ListViewItem(yp.YpName);
                    i.Checked = true;
                    foreach (TargetYPSetting ty in tabSetting.TargetYpList)
                    {
                        if (ty.YPName == yp.YpName)
                        {
                            i.Checked = ty.IsTargetYP;
                            break;
                        }
                    }
                    listViewSelectYP.Items.Add(i);
                }
            }
            
        }

        private void SetValueToSetting(int index)
        {
            if (fsList.Count != 0)
            {
                fsList[index].Name = textBoxName.Text;
                fsList[index].Condition = textBoxCondition.Text;

                fsList[index].CheckChannel = checkBoxChannelName.Checked;
                fsList[index].CheckComment = checkBoxComment.Checked;
                fsList[index].CheckContact = checkBoxContactUrl.Checked;
                fsList[index].Enable = checkBoxEnable.Checked;
                fsList[index].CheckGenre = checkBoxGenre.Checked;
                fsList[index].CheckPlaying = checkBoxPlaying.Checked;
                fsList[index].CheckType = checkBoxType.Checked;
                
                fsList[index].UseRegex = checkBoxUseRegEx.Checked;
                fsList[index].IgnoreCase = checkBoxIgnoreCase.Checked;
                fsList[index].ConcatAllStrings = checkBoxConcatString.Checked;

                fsList[index].ChannelType = comboBoxChannelType.SelectedIndex;
                fsList[index].Bitrate = textBoxBitrate.Text;

                List<TargetYPSetting> typList = new List<TargetYPSetting>();
                foreach (ListViewItem i in listViewSelectYP.Items)
                {
                    TargetYPSetting typ = new TargetYPSetting(i.Text, i.Checked);
                    typList.Add(typ);
                }

                fsList[index].TargetYpList = typList.ToArray();
            }
        }

        private void buttonAdd_Click(object sender, EventArgs e)
        {
            TabSetting fs = new TabSetting();
            fsList.Add(fs);
            listBoxFilters.Items.Add(fs.Name);
            if (listBoxFilters.Items.Count == 1)
            {
                SetValueToUI(fs);
                listBoxFilters.SelectedIndex = 0;
            }
            else
            {
                listBoxFilters.SelectedIndex = listBoxFilters.Items.Count - 1;
            }
            buttonRemove.Enabled = true;
        }

        private void buttonRemove_Click(object sender, EventArgs e)
        {
            if (listBoxFilters.SelectedIndex == -1) return;
            fsList.RemoveAt(listBoxFilters.SelectedIndex);
            listBoxFilters.Items.RemoveAt(listBoxFilters.SelectedIndex);
            if (selectedIndex == 0)
            {
                if (listBoxFilters.Items.Count != 0)
                {
                    SetValueToUI(fsList[0]);
                    selectedIndex = 0;
                    listBoxFilters.SelectedIndex = 0;
                }
            }
            else if (listBoxFilters.Items.Count != 0)
            {
                selectedIndex--;
                SetValueToUI(fsList[selectedIndex]);
                listBoxFilters.SelectedIndex = selectedIndex;
            }

            if (listBoxFilters.Items.Count == 0)
            {
                buttonRemove.Enabled = false;
            }
        }

        private void buttonUp_Click(object sender, EventArgs e)
        {
            listBoxFilters.SelectedIndexChanged -= new EventHandler(listBoxFilters_SelectedIndexChanged);

            // ݂̒lۑ
            SetValueToSetting(selectedIndex);
            selectedIndex--;
            // ɂACeޔ
            TabSetting fsPrev = (TabSetting)fsList[selectedIndex].Clone();
            //@̃CfbNXɑ
            fsList[selectedIndex] = (TabSetting)fsList[selectedIndex + 1].Clone();
            listBoxFilters.Items[selectedIndex] = fsList[selectedIndex].Name;
            fsList[selectedIndex + 1] = fsPrev;
            listBoxFilters.Items[selectedIndex + 1] = fsList[selectedIndex + 1].Name;
            // ListBox̃CfbNX
            listBoxFilters.SelectedIndex = selectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxFilters.SelectedIndex == 0) buttonUp.Enabled = false;
            else buttonUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxFilters.SelectedIndex == fsList.Count - 1) buttonDown.Enabled = false;
            else buttonDown.Enabled = true;

            listBoxFilters.SelectedIndexChanged += new EventHandler(listBoxFilters_SelectedIndexChanged);
        }

        private void buttonDown_Click(object sender, EventArgs e)
        {
            listBoxFilters.SelectedIndexChanged -= new EventHandler(listBoxFilters_SelectedIndexChanged);

            // ݂̒lۑ
            SetValueToSetting(selectedIndex);
            selectedIndex++;
            // ɂACeޔ
            TabSetting fsPrev = (TabSetting)fsList[selectedIndex].Clone();
            //@̃CfbNXɑ
            fsList[selectedIndex] = (TabSetting)fsList[selectedIndex - 1].Clone();
            listBoxFilters.Items[selectedIndex] = fsList[selectedIndex].Name;
            fsList[selectedIndex - 1] = fsPrev;
            listBoxFilters.Items[selectedIndex - 1] = fsList[selectedIndex - 1].Name;
            // ListBox̃CfbNXグ
            listBoxFilters.SelectedIndex = selectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxFilters.SelectedIndex == 0) buttonUp.Enabled = false;
            else buttonUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxFilters.SelectedIndex == fsList.Count - 1) buttonDown.Enabled = false;
            else buttonDown.Enabled = true;

            listBoxFilters.SelectedIndexChanged += new EventHandler(listBoxFilters_SelectedIndexChanged);
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            Save();
            DialogResult = DialogResult.OK;
            Close();
        }

        private void Save()
        {
            if (fsList == null) return;
            SetValueToSetting(listBoxFilters.SelectedIndex);
            TabSetting.Save(fsList.ToArray());
            Settings.TabSettings = fsList.ToArray();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void buttonCheckRegEx_Click(object sender, EventArgs e)
        {
            try
            {
                Regex regex = new Regex(textBoxCondition.Text);
            }
            catch (ArgumentException)
            {
                MessageBox.Show("K\ɃG[܂B");
                return;
            }

            MessageBox.Show("K\ɃG[͂܂B");
        }

        private void listBoxFilters_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listBoxFilters.SelectedIndex == -1) return;
            if (listBoxFilters.Items.Count == 0) return;
            SetValueToSetting(selectedIndex);
            TabSetting fs = fsList[listBoxFilters.SelectedIndex];
            SetValueToUI(fs);
            selectedIndex = listBoxFilters.SelectedIndex;

            // IꂽACeԏȂA{^𖳌ɂ
            if (listBoxFilters.SelectedIndex == 0) buttonUp.Enabled = false;
            else buttonUp.Enabled = true;

            // IꂽACeԉȂA{^𖳌ɂ
            if (listBoxFilters.SelectedIndex == fsList.Count - 1) buttonDown.Enabled = false;
            else buttonDown.Enabled = true;
        }

        private void checkBoxUseRegEx_CheckedChanged(object sender, EventArgs e)
        {
            buttonCheckRegEx.Enabled = checkBoxUseRegEx.Checked;
        }

        private void FormFilterTabSetting_Load(object sender, EventArgs e)
        {
            if (Settings.TabSettings != null)
                fsList = new List<TabSetting>(Settings.TabSettings); /* = FilterSetting.Load(); */
            else fsList = new List<TabSetting>();
            Listup();
            if (fsList.Count >= 1)
            {
                SetValueToUI(fsList[0]);
                listBoxFilters.SelectedIndex = 0;
            }
        }

        private void Listup()
        {
            if (fsList == null) return;

            foreach (TabSetting fs in fsList)
            {
                listBoxFilters.Items.Add(fs.Name);
            }
        }

        private void FormFilterTabSetting_FormClosing(object sender, FormClosingEventArgs e)
        {

        }

        private void textBoxName_KeyUp(object sender, KeyEventArgs e)
        {
            if (listBoxFilters.Items.Count == 0) return;
            listBoxFilters.Items[listBoxFilters.SelectedIndex]
                = textBoxName.Text;
        }

        private void comboBoxChannelType_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBoxChannelType.SelectedIndex == 2 ||
                comboBoxChannelType.SelectedIndex == 3)
                listViewSelectYP.Enabled = false;
            else listViewSelectYP.Enabled = true;
        }
    }
}