using System;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using System.Windows.Forms.ColorPicker;
using pcmp.Setting;

namespace pcmp.Forms
{
    public partial class FormSetting : Form
    {
        // ----------------------------------------------------------
        // tB[h
        // ----------------------------------------------------------
        public GeneralSetting setting;
        private string tempPath = string.Empty;
        private ColorPicker picker = new ColorPicker();
        private Panel setColorPanel = null;
        private ApplicationSetting app;

        // ----------------------------------------------------------
        // \bh
        // ----------------------------------------------------------
        public FormSetting()
        {
            InitializeComponent();
            setting = Settings.GeneralSetting.Clone() as GeneralSetting;
            if (setting == null) setting = new GeneralSetting();
            tempPath = Path.Combine(Application.StartupPath, "templates\\");
            picker.ColorSelected += new ColorSelectedEventHandler(picker_ColorSelected);
            app = Settings.ApplicationSetting;
        }

        private void picker_ColorSelected(object sender, ColorSelectedEventArgs e)
        {
            if(setColorPanel != null)
                setColorPanel.BackColor = e.ColorSelected;
        }

        public void Save()
        {
            setting.BrowserPath = textBoxOtherBrowserPath.Text;
            setting.PeerCastPath = textBoxPeerCastPath.Text;
            setting.RunAsMinimize = checkBoxRunAsMinimize.Checked;
            setting.RunPeerCastOnStartup = checkBoxRunAtPeerCast.Checked;
            setting.UseOtherBrowser = checkBoxOtherBrowser.Checked;
            setting.UseMultiOption = checkBoxMulti.Checked;
            setting.TemplatePath = Path.Combine(tempPath, comboBoxTemplates.Text);
            setting.ShowGridLine = checkBoxShowGrid.Checked;
            setting.ListViewBack = panel2.BackColor;
            // setting.ListViewGrid = panelGridColor.BackColor;
            setting.ClosePeerCastOnExit = checkBoxClosePCastOnExit.Checked;
            //setting.UseBrowserOnYPViewer = checkBoxUseBrowserOnYPViewer.Checked;
            setting.Browser2chPath = textBox2chBrowserPath.Text;
            setting.UseBrowser2ch = checkBoxUse2ch.Checked;
            setting.HideOnMinimize = checkBoxInTaskTray.Checked;
            setting.SingleClickToReturn = checkBoxTraySingleClick.Checked;
            setting.Regex2chUrl = textBoxUrlRegex.Text;
            setting.GetYpOnStartup = checkBoxGetAtRun.Checked;
            setting.FrozenAtChannelName = checkBoxFrozenChannelName.Checked;
            setting.ProcessPriority = comboBoxPriority.SelectedIndex;
            setting.ChangeProcessPriority = checkBoxChangeAppPriority.Checked;
            setting.DoNotShowErrorChannel = checkBoxDoNotShowError.Checked;

            setting.NetworkSetting.HostAddr = textBoxHostAddr.Text;
            setting.NetworkSetting.TimeOut = int.Parse(textBoxTimeOut.Text);
            setting.NetworkSetting.HttpProtocol = comboBoxHttpProtocol.SelectedIndex;
            setting.NetworkSetting.UseProxy = checkBoxUseProxy.Checked;
            setting.NetworkSetting.UseIEProxy = checkBoxUseIEProxy.Checked;
            setting.NetworkSetting.ProxyAddr = textBoxProxyAddr.Text;

            setting.ShowYpBalloon = checkBoxYPRefreshComplete.Checked;
            setting.ShowFavoriteBalloon = checkBoxFavoriteChannelBalloon.Checked;
            setting.ShowNewBalloon = checkBoxNewChannelBalloon.Checked;
            //setting.ShowTooltip = checkBoxShowTooltipText.Checked;
            setting.ShowExitDialog = checkBoxShowDialogOnExit.Checked;

            setting.Save();
            Settings.GeneralSetting = setting;
            for (int i = 0; i < listViewColumns.Items.Count; i++)
            {
                ListViewItem item = listViewColumns.Items[i];
                app.Columns[i].Visible = item.Checked;
            }
            app.Save();
        }

        // ----------------------------------------------------------
        // Cxg
        // ----------------------------------------------------------
        private void checkBoxOtherBrowser_CheckedChanged(object sender, EventArgs e)
        {
            textBoxOtherBrowserPath.Enabled = checkBoxOtherBrowser.Checked;
            //checkBoxUseBrowserOnYPViewer.Enabled = checkBoxOtherBrowser.Checked;
        }

        private void buttonPCPath_Click(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "PeerCast.exe|peercast.exe";
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
                textBoxPeerCastPath.Text = openFileDialog1.FileName;
        }

        private void buttonBrowserPath_Click(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "st@C(*.exe)|*.exe|ׂẴt@C|*.*";
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
                textBoxOtherBrowserPath.Text = openFileDialog1.FileName;
        }

        private void FormSetting_Load(object sender, EventArgs e)
        {
        }

        private void comboBoxTemplates_SelectedIndexChanged(object sender, EventArgs e)
        {
            string path = Path.Combine(tempPath, comboBoxTemplates.Text);
            string[] files = Directory.GetFiles(path);
            if (files != null && files.Length != 0)
            {
                foreach (string file in files)
                {
                    string fileName = Path.GetFileName(file);
                    if (fileName == "ChannelInfoV.html" || fileName == "infoV.html")
                    {
                        textBoxChannelInfoV.Text = fileName;
                        break;
                    }
                    else
                    {
                        textBoxChannelInfoV.Text = string.Empty;
                    }
                }

                foreach (string file in files)
                {
                    string fileName = Path.GetFileName(file);
                    if (fileName == "ChannelInfoH.html" || fileName == "infoH.html")
                    {
                        textBoxChannelInfoH.Text = fileName;
                        break;
                    }
                    else
                    {
                        textBoxChannelInfoH.Text = string.Empty;
                    }
                }
            }
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            Save();
            DialogResult = DialogResult.OK;
            Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void buttonBackColor_Click(object sender, EventArgs e)
        {
            setColorPanel = panel2;
            Button btn_sender = (Button) sender;
            picker.Color = panel2.BackColor;
            picker.Location = btn_sender.Parent.PointToScreen(new Point(btn_sender.Right, btn_sender.Top));
            if (!picker.Visible)
                picker.Show();
        }

        private void checkBoxUse2ch_CheckedChanged(object sender, EventArgs e)
        {
            textBoxUrlRegex.Enabled = checkBoxUse2ch.Checked;
            textBox2chBrowserPath.Enabled = checkBoxUse2ch.Checked;
        }

        private void button2chBrowserPath_Click(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "st@C(*.exe)|*.exe|ׂẴt@C|*.*";
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
                textBox2chBrowserPath.Text = openFileDialog1.FileName;
        }

        private void FormSetting_Shown(object sender, EventArgs e)
        {
            textBoxOtherBrowserPath.Text = setting.BrowserPath;
            textBoxPeerCastPath.Text = setting.PeerCastPath;
            checkBoxRunAsMinimize.Checked = setting.RunAsMinimize;
            checkBoxRunAtPeerCast.Checked = setting.RunPeerCastOnStartup;
            checkBoxOtherBrowser.Checked = setting.UseOtherBrowser;
            checkBoxMulti.Checked = setting.UseMultiOption;
            checkBoxShowGrid.Checked = setting.ShowGridLine;
            panel2.BackColor = setting.ListViewBack;
            //panelGridColor.BackColor = setting.ListViewGrid;
            checkBoxClosePCastOnExit.Checked = setting.ClosePeerCastOnExit;
            //checkBoxUseBrowserOnYPViewer.Checked = setting.UseBrowserOnYPViewer;
            checkBoxUse2ch.Checked = setting.UseBrowser2ch;
            textBox2chBrowserPath.Text = setting.Browser2chPath;
            checkBoxTraySingleClick.Checked = setting.SingleClickToReturn;
            checkBoxInTaskTray.Checked = setting.HideOnMinimize;
            textBoxUrlRegex.Text = setting.Regex2chUrl;
            checkBoxGetAtRun.Checked = setting.GetYpOnStartup;
            checkBoxFrozenChannelName.Checked = setting.FrozenAtChannelName;
            comboBoxPriority.SelectedIndex = setting.ProcessPriority;
            checkBoxChangeAppPriority.Checked = setting.ChangeProcessPriority;
            checkBoxDoNotShowError.Checked = setting.DoNotShowErrorChannel;

            textBoxHostAddr.Text = setting.NetworkSetting.HostAddr;
            textBoxTimeOut.Text = setting.NetworkSetting.TimeOut.ToString();
            comboBoxHttpProtocol.SelectedIndex = setting.NetworkSetting.HttpProtocol;
            checkBoxUseProxy.Checked = setting.NetworkSetting.UseProxy;
            checkBoxUseIEProxy.Checked = setting.NetworkSetting.UseIEProxy;
            textBoxProxyAddr.Text = setting.NetworkSetting.ProxyAddr;

            checkBoxYPRefreshComplete.Checked = setting.ShowYpBalloon;
            checkBoxFavoriteChannelBalloon.Checked = setting.ShowFavoriteBalloon;
            checkBoxNewChannelBalloon.Checked = setting.ShowNewBalloon;
            //checkBoxShowTooltipText.Checked = setting.ShowTooltip;
            checkBoxShowDialogOnExit.Checked = setting.ShowExitDialog;

            string[] dirs = new string[0];

            // ev[gptH_̎擾
            if (Directory.Exists(tempPath))
                dirs = Directory.GetDirectories(tempPath);
            foreach (string dir in dirs)
            {
                if (Path.GetFileName(dir) != "yp-viewer")
                    comboBoxTemplates.Items.Add(Path.GetFileName(dir));
            }
            if (!string.IsNullOrEmpty(setting.TemplatePath))
            {
                string s = Path.GetFileName(setting.TemplatePath);
                comboBoxTemplates.SelectedIndex =
                    comboBoxTemplates.Items.IndexOf(s);
            }

            // \J̐ݒ
            foreach (ColumnSetting column in app.Columns)
            {
                ListViewItem item = new ListViewItem();
                item.Checked = column.Visible;
                item.Text = column.DisplayText;
                listViewColumns.Items.Add(item);
            }
        }

        private void checkBoxChangeAppPriority_CheckedChanged(object sender, EventArgs e)
        {
            comboBoxPriority.Enabled = checkBoxChangeAppPriority.Checked;
        }

        private void checkBoxUseProxy_CheckedChanged(object sender, EventArgs e)
        {
            groupBox9.Enabled = checkBoxUseProxy.Checked;
        }
    }
}