using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Windows.Forms.ColorPicker;

namespace pcmp.Forms
{
    public partial class ColorPicker : Form
    {
        public ColorPicker()
        {
            InitializeComponent();
        }

        public event ColorSelectedEventHandler ColorSelected;

        public Color Color
        {
            set { multiTabColorPicker1.Color = value; }
        }

        private void multiTabColorPicker_ColorSelected(object sender, ColorSelectedEventArgs e)
        {
            Hide();
            if (ColorSelected != null)
                ColorSelected(sender, e);
        }

        protected override void OnDeactivate(EventArgs e)
        {
            base.OnDeactivate(e);
            Hide();
        }

        protected override bool ProcessDialogKey(Keys keyData)
        {
            if (keyData == Keys.Escape)
            {
                Hide();
                return true;
            }
            return base.ProcessDialogKey(keyData);
        }
    }
}