using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using pcmp.Setting;

namespace pcmp
{
    public delegate void RefreshChannelCompleteEventHandler(string msg);

    public static class ChannelRefreshThread
    {
        public static bool IsBusy;
        public static event RefreshChannelCompleteEventHandler RefreshChannelsCompleteEvent;
        // public static IndexTextSource source = IndexTextSource.Both;

        public static void StartRefreshChannels(YpSetting[] yparray)
        {
            if (yparray == null || yparray.Length == 0) return;

            Thread t = new Thread(ThreadProc);
            t.Priority = ThreadPriority.BelowNormal;
            t.Start(yparray);
            IsBusy = true;
        }

        private static void ThreadProc(Object obj)
        {
            YpSetting[] yparray = (YpSetting[])obj;
            //#if DEBUG
            //            foreach (YpSetting yp in yparray)
            //            {
            //                for (int i = 0; i < 100; i++)
            //                {
            //                    Channel ch = new Channel();
            //                    ch.No = i + 1;
            //                    ch.Alt = "aaa";
            //                    ch.BitRate = new Bitrate(192);
            //                    ch.ChannelName = "AAAA";
            //                    ch.Comment = "AAAAAAA";
            //                    ch.ContactUrl = "http://aaaaaaaaaaaaaaaaaaaa";
            //                    ch.Desc = "aaa";
            //                    ch.Detail = "afafdfd";
            //                    ch.Diff = ChannelDiff.Down;
            //                    ch.Type = "AAA";
            //                    ch.YPName = yp.YpName;
            //                    ch.State = ChannelState.Broadcasting;
            //                    Channels.Add(ch);
            //                }
            //            }
            //#else
            ThreadGetIndexText thread = new ThreadGetIndexText();
            string msg = thread.GetIndexTextResult(yparray);
            //#endif
            IsBusy = false;
            if (RefreshChannelsCompleteEvent != null)
            {
                Form f = RefreshChannelsCompleteEvent.Target as Form;
                if (f != null)
                {
                    f.Invoke(
                        (MethodInvoker)delegate
                        {
                            RefreshChannelsCompleteEvent(msg);
                        }
                        );
                }
            }
        }
    }
}
