using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using System.Xml.Serialization;

namespace PeerCastMultiPlayer2
{
    public class YPViewPref
    {
        private FontStyle fontStyleContact;
        private FontStyle fontStyleDirect;
        private Font font;
        private Color foreColor;
        private Color backColor;
        private Color contactColor;
        private Color directColor;

        public FontStyle FontStyleContact
        {
            get { return fontStyleContact; }
            set { fontStyleContact = value; }
        }

        public FontStyle FontStyleDirect
        {
            get { return fontStyleDirect; }
            set { fontStyleDirect = value; }
        }

        public Font Font
        {
            get { return font; }
            set { font = value; }
        }

        public Color ForeColor
        {
            get { return foreColor; }
            set { foreColor = value; }
        }

        public Color BackColor
        {
            get { return backColor; }
            set { backColor = value; }
        }

        public Color ContactColor
        {
            get { return contactColor; }
            set { contactColor = value; }
        }

        public Color DirectColor
        {
            get { return directColor; }
            set { directColor = value; }
        }

        public static YPViewPref CreateFromYPS(YpSetting yps)
        {
            YPViewPref ypPref = new YPViewPref();
            int fontStyleContact = 0;
            if (yps.ContactBold) fontStyleContact += 1;
            if (yps.ContactItalic) fontStyleContact += 2;
            if (yps.ContactStrike) fontStyleContact += 8;
            if (yps.ContactULine) fontStyleContact += 4;
            ypPref.FontStyleContact = (FontStyle)fontStyleContact;
            int fontStyleDirect = 0;
            if (yps.DirectBold) fontStyleDirect += 1;
            if (yps.DirectItalic) fontStyleDirect += 2;
            if (yps.DirectStrike) fontStyleDirect += 8;
            if (yps.DirectULine) fontStyleDirect += 4;
            ypPref.FontStyleDirect = (FontStyle)fontStyleDirect;

            ypPref.ForeColor = yps.TextColor;
            ypPref.BackColor = yps.BackColor;
            ypPref.Font = yps.ListFont;
            ypPref.ContactColor = yps.ContactColor;
            ypPref.DirectColor = yps.DirectColor;

            return ypPref;
        }
    }

    [Serializable()]
    public class YpSetting : ICloneable
    {
        public static void Save(YpSetting[] ypSettingList)
        {
            Serializer.Save("YelloPages.xml", ypSettingList);
        }

        public static YpSetting[] Load()
        {
            YpSetting[] obj =
                Serializer.Load("YelloPages.xml", typeof(YpSetting[])) as YpSetting[];
            if (obj == null)
            {
                if (File.Exists(Path.Combine(Application.StartupPath, "YelloPages.xml")))
                {
                }
                return null;
            }
            return obj;
        }

        // ---------------------------------------------------------- //
        // tB[h                                                 //
        // ---------------------------------------------------------- //
        private bool enableYP = true;
        private string ypName = string.Empty;
        private string ypAddr = string.Empty;
        private bool useIndexTxt = true;
        private Color textColor = Color.FromKnownColor(KnownColor.WindowText);
        private Color backColor = Color.FromKnownColor(KnownColor.Window);
        private Font font;
        private Color contactColor = Color.Blue;
        private bool contactBold = false;
        private bool contactItalic = false;
        private bool contactStrike = false;
        private bool contactULine = true;
        private Color directColor = Color.Blue;
        private bool directBold = false;
        private bool directItalic = false;
        private bool directStrike = false;
        private bool directULine = true;
        private bool useFilterGenre = false;
        private string filterGenre = string.Empty;
        private bool useFilterBitrate = false;
        private string filterBitrate = string.Empty;
        private bool useFilterType = false;
        private string filterType = string.Empty;
        //private bool useFilterFind = false;
        //private string filterFind = string.Empty;
        private bool getByPCRaw = false;
        private bool showNewInfo = true;
        private bool getError = false;
        private string ypNamespace = string.Empty;
        private string encoding = string.Empty;
        private bool useEncoding;

        // Xg[擾p
        private IntPtr pcrawHandle = IntPtr.Zero;
        private bool haveIndexTextStream = false;
        private string indexTextStreamUrl = string.Empty;
        private uint lastUpdate;
        private string indexTextChannelName = string.Empty;

        // ---------------------------------------------------------- //
        // vpeB                                                 //
        // ---------------------------------------------------------- //
        public string IndexTextChannelName
        {
            get { return indexTextChannelName; }
            set { indexTextChannelName = value; }
        }
        
        public string Encoding
        {
            get { return encoding; }
            set { encoding = value; }
        }

        public bool UseEncoding
        {
            get { return useEncoding; }
            set { useEncoding = value; }
        }

        [XmlIgnore()]
        public uint LastUpdate
        {
            get { return lastUpdate; }
            set { lastUpdate = value; }
        }

        [XmlIgnore()]
        public bool GetError
        {
            get { return getError; }
            set { getError = value; }
        }

        public string YpNamespace
        {
            get { return ypNamespace; }
            set { ypNamespace = value; }
        }

        public bool ShowNewInfo
        {
            get { return showNewInfo; }
            set { showNewInfo = value; }
        }

        public bool GetByPCRaw
        {
            get { return getByPCRaw; }
            set { getByPCRaw = value; }
        }

        [XmlIgnore()]
        public IntPtr PcrawHandle
        {
            get { return pcrawHandle; }
            set { pcrawHandle = value; }
        }

        [XmlIgnore()]
        public string IndexTextStreamUrl
        {
            get { return indexTextStreamUrl; }
            set { indexTextStreamUrl = value; }
        }

        [XmlIgnore()]
        public bool HaveIndexTextStream
        {
            get { return haveIndexTextStream; }
            set { haveIndexTextStream = value; }
        }

        public bool UseFilterGenre
        {
            get { return useFilterGenre; }
            set { useFilterGenre = value; }
        }

        public string FilterGenre
        {
            get { return filterGenre; }
            set { filterGenre = value; }
        }

        public string FilterBitrate
        {
            get { return filterBitrate; }
            set { filterBitrate = value; }
        }

        public string FilterType
        {
            get { return filterType; }
            set { filterType = value; }
        }

        //public bool UseFilterFind
        //{
        //    get { return useFilterFind; }
        //    set { useFilterFind = value; }
        //}

        public bool UseFilterType
        {
            get { return useFilterType; }
            set { useFilterType = value; }
        }

        public bool UseFilterBitrate
        {
            get { return useFilterBitrate; }
            set { useFilterBitrate = value; }
        }

        //public string FilterFind
        //{
        //    get { return filterFind; }
        //    set { filterFind = value; }
        //}

        public bool EnableYP
        {
            get { return enableYP; }
            set { enableYP = value; }
        }

        public string YPName
        {
            get { return ypName; }
            set { ypName = value; }
        }

        public string YPAddr
        {
            get { return ypAddr; }
            set { ypAddr = value; }
        }

        public bool UseIndexTxt
        {
            get { return useIndexTxt; }
            set { useIndexTxt = value; }
        }

        [XmlIgnore()]
        public Color TextColor
        {
            get { return textColor; }
            set { textColor = value; }
        }

        [XmlElement("TextColor")]
        public string XmlTextColor
        {
            get { return Serializer.SerializeColor(TextColor); }
            set { TextColor = Serializer.DeserializeColor(value); }
        }

        [XmlIgnore()]
        public Color BackColor
        {
            get { return backColor; }
            set { backColor = value; }
        }

        [XmlElement("BackColor")]
        public string XmlBackColor
        {
            get { return Serializer.SerializeColor(BackColor); }
            set { BackColor = Serializer.DeserializeColor(value); }
        }

        [XmlIgnore()]
        public Font ListFont
        {
            get { return font; }
            set { font = value; }
        }

        [XmlElement("ListFont")]
        public XmlFont XmlListFont
        {
            get { return Serializer.SerializeFont(ListFont); }
            set { ListFont = Serializer.DeserializeFont(value); }
        }

        [XmlIgnore()]
        public Color ContactColor
        {
            get { return contactColor; }
            set { contactColor = value; }
        }

        [XmlElement("ContactColor")]
        public string XmlContactColor
        {
            get { return Serializer.SerializeColor(ContactColor); }
            set { ContactColor = Serializer.DeserializeColor(value); }
        }

        public bool ContactBold
        {
            get { return contactBold; }
            set { contactBold = value; }
        }

        public bool ContactItalic
        {
            get { return contactItalic; }
            set { contactItalic = value; }
        }

        public bool ContactStrike
        {
            get { return contactStrike; }
            set { contactStrike = value; }
        }

        public bool ContactULine
        {
            get { return contactULine; }
            set { contactULine = value; }
        }

        [XmlIgnore()]
        public Color DirectColor
        {
            get { return directColor; }
            set { directColor = value; }
        }

        [XmlElement("DirectColor")]
        public string XmlDirectColor
        {
            get { return Serializer.SerializeColor(DirectColor); }
            set { DirectColor = Serializer.DeserializeColor(value); }
        }

        public bool DirectBold
        {
            get { return directBold; }
            set { directBold = value; }
        }

        public bool DirectItalic
        {
            get { return directItalic; }
            set { directItalic = value; }
        }

        public bool DirectStrike
        {
            get { return directStrike; }
            set { directStrike = value; }
        }

        public bool DirectULine
        {
            get { return directULine; }
            set { directULine = value; }
        }

        #region ICloneable o

        public object Clone()
        {
            return MemberwiseClone();
        }

        #endregion

        public YPViewPref CreateYPViewPref()
        {
            YPViewPref ypPref = new YPViewPref();
            int fontStyleContact = 0;
            if (ContactBold) fontStyleContact += 1;
            if (ContactItalic) fontStyleContact += 2;
            if (ContactStrike) fontStyleContact += 8;
            if (ContactULine) fontStyleContact += 4;
            ypPref.FontStyleContact = (FontStyle)fontStyleContact;
            int fontStyleDirect = 0;
            if (DirectBold) fontStyleDirect += 1;
            if (DirectItalic) fontStyleDirect += 2;
            if (DirectStrike) fontStyleDirect += 8;
            if (DirectULine) fontStyleDirect += 4;
            ypPref.FontStyleDirect = (FontStyle)fontStyleDirect;

            ypPref.ForeColor = TextColor;
            ypPref.BackColor = BackColor;
            ypPref.Font = ListFont;
            ypPref.ContactColor = ContactColor;
            ypPref.DirectColor = DirectColor;

            return ypPref;
        }
    }
}