using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Xml.Serialization;
using System.IO;
using System.Windows.Forms;

namespace PeerCastMultiPlayer2
{
    public enum ColorFormat
    {
        NamedColor,
        ARGBColor
    }

    public static class Serializer
    {
        public static string SerializeColor(Color color)
        {
            if (color.IsNamedColor)
                return string.Format("{0}:{1}", ColorFormat.NamedColor, color.Name);
            else
                return string.Format("{0}:{1}:{2}:{3}:{4}", ColorFormat.ARGBColor, color.A, color.R, color.G, color.B);
        }

        public static Color DeserializeColor(string color)
        {
            if (string.IsNullOrEmpty(color)) return Color.Empty;
            byte a, r, g, b;

            string[] pieces = color.Split(new char[] { ':' });

            ColorFormat colorType = (ColorFormat)Enum.Parse(typeof(ColorFormat), pieces[0], true);

            switch (colorType)
            {
                case ColorFormat.NamedColor:
                    return Color.FromName(pieces[1]);

                case ColorFormat.ARGBColor:
                    a = byte.Parse(pieces[1]);
                    r = byte.Parse(pieces[2]);
                    g = byte.Parse(pieces[3]);
                    b = byte.Parse(pieces[4]);

                    return Color.FromArgb(a, r, g, b);
            }
            return Color.Empty;
        }

        public static XmlFont SerializeFont(Font font)
        {
            return new XmlFont(font);
        }

        public static Font DeserializeFont(XmlFont font)
        {
            return font.ToFont();
        }

        public static void Save(string file, object saveObj)
        {
            if (saveObj == null) throw new ArgumentException("saveObj  null łB");
            string fileName = Path.Combine(Application.StartupPath, "Config\\" + file);
            XmlSerializer xs = null;
            StreamWriter sw = null;
            try
            {
                xs = new XmlSerializer(saveObj.GetType());
                sw = new StreamWriter(fileName);
                xs.Serialize(sw, saveObj);
            }
            catch { }
            finally
            {
                if (sw != null)
                    sw.Close();
            }
        }

        public static object Load(string file, Type objType)
        {
            string fileName = Path.Combine(Application.StartupPath, "Config\\" + file);
            XmlSerializer xs = null;
            StreamReader sr = null;
            Object obj = null;
            try
            {
                xs = new XmlSerializer(objType);
                sr = new StreamReader(fileName);
                obj = xs.Deserialize(sr);
            }
            catch
            {
                return null;
            }
            finally
            {
                if (sr != null)
                    sr.Close();
            }
            return obj;
        }
    }
}
